/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.data.DataMigrations;
import codes.cookies.mod.data.Migration;
import codes.cookies.mod.data.player.PlayerStorage;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.events.profile.ProfileSwapEvent;
import codes.cookies.mod.events.profile.ServerSwapEvent;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.json.JsonUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ProfileStorage {
    private static final String LOGGING_KEY = "profileStorage";
    private static final Path PROFILE_DATA_FOLDER = Path.of("config/cookiesmod/profiles", new String[0]);
    private static ProfileData profileData;

    public static void register() {
        ProfileSwapEvent.AFTER_SET_NO_UUID.register(() -> CookiesMod.getExecutorService().execute(() -> {
            ProfileStorage.saveCurrentProfile();
            ProfileStorage.loadCurrentProfile();
        }));
        ServerSwapEvent.SERVER_SWAP.register(() -> CookiesMod.getExecutorService().execute(ProfileStorage::saveCurrentProfile));
        CookiesMod.getExecutorService().scheduleAtFixedRate(ProfileStorage::saveCurrentProfile, 5L, 5L, TimeUnit.MINUTES);
    }

    public static synchronized void saveCurrentProfile() {
        if (profileData == null) {
            return;
        }
        if (PlayerStorage.getCurrentPlayer().isEmpty() || SkyblockUtils.getLastProfileId().isEmpty() || LocationUtils.isOnHypixelAlpha()) {
            return;
        }
        long started = System.currentTimeMillis();
        Path playerDirectory = PROFILE_DATA_FOLDER.resolve(profileData.getPlayerUuid().toString());
        Path profileFile = playerDirectory.resolve(String.valueOf(profileData.getProfileUuid()) + ".json");
        DevUtils.log(LOGGING_KEY, "Saving profile data to %s", profileFile);
        ExceptionHandler.removeThrows(() -> Files.createDirectories(profileFile.getParent(), new FileAttribute[0]));
        JsonObject jsonObject = JsonUtils.toJsonObject(profileData);
        DataMigrations.writeLatest(jsonObject, Migration.Type.PROFILE);
        profileData.save();
        ExceptionHandler.removeThrows(() -> Files.writeString(profileFile, (CharSequence)JsonUtils.CLEAN_GSON.toJson((JsonElement)jsonObject), StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
        DevUtils.log(LOGGING_KEY, "Saved profile in %sms", System.currentTimeMillis() - started);
    }

    private static void loadCurrentProfile() {
        CookiesMod.getExecutorService().execute(() -> ProfileStorage.loadCurrentProfile(false));
    }

    public static synchronized void loadCurrentProfile(boolean skipCheck) {
        if (PlayerStorage.getCurrentPlayer().isEmpty() || SkyblockUtils.getLastProfileId().isEmpty() || skipCheck) {
            return;
        }
        long started = System.currentTimeMillis();
        Path playerDirectory = PROFILE_DATA_FOLDER.resolve(PlayerStorage.getCurrentPlayer().get().toString());
        Path profileFile = playerDirectory.resolve(String.valueOf(SkyblockUtils.getLastProfileId().get()) + ".json");
        if (!Files.exists(profileFile, new LinkOption[0])) {
            profileData = new ProfileData(PlayerStorage.getCurrentPlayer().get(), SkyblockUtils.getLastProfileId().get());
            profileData.load();
            ProfileStorage.saveCurrentProfile();
            return;
        }
        DevUtils.log(LOGGING_KEY, "Loading profile data from %s", profileFile);
        JsonObject jsonObject = (JsonObject)JsonUtils.CLEAN_GSON.fromJson(ExceptionHandler.removeThrows(() -> Files.readString(profileFile, StandardCharsets.UTF_8), "{}"), JsonObject.class);
        if (!DataMigrations.migrate(jsonObject, Migration.Type.PROFILE)) {
            CookiesUtils.sendFailedMessage("Failed to apply a mandatory data migration, resetting local profile data!");
            profileData = new ProfileData(PlayerStorage.getCurrentPlayer().get(), SkyblockUtils.getLastProfileId().get());
            profileData.load();
        } else {
            profileData = JsonUtils.fromJson(new ProfileData(PlayerStorage.getCurrentPlayer().get(), SkyblockUtils.getLastProfileId().get()), jsonObject);
            profileData.load();
        }
        DevUtils.log(LOGGING_KEY, "Loaded profile in %sms", System.currentTimeMillis() - started);
    }

    @NotNull
    public static Optional<ProfileData> getCurrentProfile() {
        if (!SkyblockUtils.isCurrentlyInSkyblock() || PlayerStorage.getCurrentPlayer().isEmpty()) {
            return Optional.empty();
        }
        if (Optional.ofNullable(profileData).map(ProfileData::isActive).orElse(false).booleanValue()) {
            return Optional.of(profileData);
        }
        CookiesMod.getExecutorService().execute(() -> {
            ProfileStorage.saveCurrentProfile();
            ProfileStorage.loadCurrentProfile();
        });
        return Optional.ofNullable(profileData);
    }
}

