/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.items;

import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.CraftableItemSource;
import codes.cookies.mod.data.profile.items.sources.StorageItemSource;
import codes.cookies.mod.data.profile.profile.IslandChestStorage;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_3902;
import org.apache.commons.lang3.ArrayUtils;

public final class ItemCompound {
    private final class_1799 itemStack;
    private final Set<Item<?>> items;
    private int amount;
    private CompoundType type;
    private Object data;

    public ItemCompound(Item<?> ... items) {
        this(Arrays.stream(items).mapToInt(Item::amount).sum(), items[0].itemStack(), new HashSet(Set.of(items)));
    }

    public ItemCompound(int amount, class_1799 itemStack, Set<Item<?>> items) {
        this.amount = amount;
        this.itemStack = itemStack;
        this.items = items;
        this.handleAny(items.iterator().next());
    }

    public void handleAny(Item<?> item) {
        if (this.type == CompoundType.MULTIPLE) {
            return;
        }
        if (this.type != null && !ArrayUtils.contains((Object[])CompoundType.getFor(item.source()), (Object)((Object)this.type))) {
            this.type = CompoundType.MULTIPLE;
            this.data = class_3902.field_17274;
            return;
        }
        switch (item.source()) {
            case SACKS: {
                this.setSacksType();
                break;
            }
            case CHESTS: {
                this.handleChest(item);
                break;
            }
            case STORAGE: {
                this.handleStorage(item);
                break;
            }
            case CRAFTABLE: {
                this.type = CompoundType.CRAFTABLE;
                this.data = item.data();
                break;
            }
            default: {
                this.type = CompoundType.of(item.source(), null);
                this.data = class_3902.field_17274;
            }
        }
    }

    private void setSacksType() {
        this.type = CompoundType.SACKS;
        this.data = class_3902.field_17274;
    }

    private void handleChest(Item<?> item) {
        IslandChestStorage.ChestItem data = (IslandChestStorage.ChestItem)item.data();
        if (this.type == null) {
            this.type = CompoundType.CHEST_POS;
            this.data = data;
            return;
        }
        if (data.blockPos() == this.data || data.secondChest() == this.data) {
            return;
        }
        this.type = CompoundType.CHEST;
        this.data = class_3902.field_17274;
    }

    private void handleStorage(Item<?> item) {
        StorageItemSource.Context data = (StorageItemSource.Context)item.data();
        if (this.type == null) {
            this.type = CompoundType.STORAGE_PAGE;
            this.data = data;
            return;
        }
        if (data.pageEquals(this.data)) {
            return;
        }
        this.type = CompoundType.STORAGE;
        this.data = class_3902.field_17274;
    }

    public void add(Item<?> item) {
        if (item.source() == ItemSources.CRAFTABLE) {
            return;
        }
        if (this.type == CompoundType.CRAFTABLE) {
            this.type = null;
            this.data = null;
            this.items.clear();
        }
        if (this.items.contains(item)) {
            return;
        }
        this.handleAny(item);
        this.items.add(item);
        this.amount += item.amount();
    }

    public int amount() {
        return this.amount;
    }

    public class_1799 itemStack() {
        return this.itemStack;
    }

    public Set<Item<?>> items() {
        return this.items;
    }

    public Set<Item<?>> getUsedItems() {
        Object object;
        if (this.type == CompoundType.CRAFTABLE && (object = this.data) instanceof CraftableItemSource.Data) {
            CraftableItemSource.Data craftData = (CraftableItemSource.Data)object;
            return craftData.amounts().values().stream().filter(CraftableItemSource.IngredientData::shouldBeIncluded).map(CraftableItemSource.IngredientData::items).flatMap(Collection::stream).filter(Predicate.not(item -> item.source().isSupportsSupercraft())).collect(Collectors.toSet());
        }
        return this.items;
    }

    public CompoundType type() {
        return this.type;
    }

    public Object data() {
        return this.data;
    }

    public String name() {
        return this.itemStack.method_7964().getString();
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.itemStack, this.items);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ItemCompound that = (ItemCompound)obj;
        return this.amount == that.amount && Objects.equals(this.itemStack, that.itemStack) && Objects.equals(this.items, that.items);
    }

    public String toString() {
        return "ItemCompound[amount=" + this.amount + ", itemStack=" + String.valueOf(this.itemStack) + ", items=" + String.valueOf(this.items) + "]";
    }

    public static enum CompoundType {
        CHEST_POS,
        CHEST,
        STORAGE_PAGE,
        STORAGE,
        SACKS,
        MULTIPLE,
        ACCESSORIES,
        SACK_OF_SACKS,
        VAULT,
        POTION_BAG,
        CRAFTABLE,
        INVENTORY,
        FORGE;


        public static CompoundType[] getFor(ItemSources itemSources) {
            CompoundType[] compoundTypeArray;
            ItemSources itemSources2 = itemSources;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STORAGE", "CHESTS", "SACKS", "VAULT", "POTION_BAG", "ACCESSORY_BAG", "SACK_OF_SACKS", "CRAFTABLE", "INVENTORY", "FORGE"}, (ItemSources)itemSources2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    CompoundType[] compoundTypeArray2 = new CompoundType[2];
                    compoundTypeArray2[0] = STORAGE;
                    compoundTypeArray = compoundTypeArray2;
                    compoundTypeArray2[1] = STORAGE_PAGE;
                    break;
                }
                case 1: {
                    CompoundType[] compoundTypeArray3 = new CompoundType[2];
                    compoundTypeArray3[0] = CHEST;
                    compoundTypeArray = compoundTypeArray3;
                    compoundTypeArray3[1] = CHEST_POS;
                    break;
                }
                case 2: {
                    CompoundType[] compoundTypeArray4 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray4;
                    compoundTypeArray4[0] = SACKS;
                    break;
                }
                case 3: {
                    CompoundType[] compoundTypeArray5 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray5;
                    compoundTypeArray5[0] = VAULT;
                    break;
                }
                case 4: {
                    CompoundType[] compoundTypeArray6 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray6;
                    compoundTypeArray6[0] = POTION_BAG;
                    break;
                }
                case 5: {
                    CompoundType[] compoundTypeArray7 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray7;
                    compoundTypeArray7[0] = ACCESSORIES;
                    break;
                }
                case 6: {
                    CompoundType[] compoundTypeArray8 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray8;
                    compoundTypeArray8[0] = SACK_OF_SACKS;
                    break;
                }
                case 7: {
                    CompoundType[] compoundTypeArray9 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray9;
                    compoundTypeArray9[0] = CRAFTABLE;
                    break;
                }
                case 8: {
                    CompoundType[] compoundTypeArray10 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray10;
                    compoundTypeArray10[0] = INVENTORY;
                    break;
                }
                case 9: {
                    CompoundType[] compoundTypeArray11 = new CompoundType[1];
                    compoundTypeArray = compoundTypeArray11;
                    compoundTypeArray11[0] = FORGE;
                    break;
                }
                case -1: {
                    compoundTypeArray = new CompoundType[]{};
                }
            }
            return compoundTypeArray;
        }

        public static CompoundType of(ItemSources source, Object data) {
            ItemSources itemSources = source;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SACKS", "CHESTS", "STORAGE", "VAULT", "SACK_OF_SACKS", "POTION_BAG", "ACCESSORY_BAG", "CRAFTABLE", "FORGE", "INVENTORY"}, (ItemSources)itemSources, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> SACKS;
                case 1 -> {
                    if (data != null) {
                        yield CHEST_POS;
                    }
                    yield CHEST;
                }
                case 2 -> {
                    if (data != null) {
                        yield STORAGE_PAGE;
                    }
                    yield STORAGE;
                }
                case 3 -> VAULT;
                case 4 -> SACK_OF_SACKS;
                case 5 -> POTION_BAG;
                case 6 -> ACCESSORIES;
                case 7 -> CRAFTABLE;
                case 8 -> FORGE;
                case 9 -> INVENTORY;
                case -1 -> null;
            };
        }
    }
}

