/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.items;

import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemSource;
import codes.cookies.mod.data.profile.items.sources.AccessoryItemSource;
import codes.cookies.mod.data.profile.items.sources.CraftableItemSource;
import codes.cookies.mod.data.profile.items.sources.ForgeItemSource;
import codes.cookies.mod.data.profile.items.sources.InventoryItemSource;
import codes.cookies.mod.data.profile.items.sources.IslandChestItemSource;
import codes.cookies.mod.data.profile.items.sources.MiscItemSource;
import codes.cookies.mod.data.profile.items.sources.SackItemSource;
import codes.cookies.mod.data.profile.items.sources.StorageItemSource;
import codes.cookies.mod.data.profile.sub.MiscItemData;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.class_2561;

public enum ItemSources {
    CHESTS((class_2561)class_2561.method_43471((String)"cookies.item_source.chest"), IslandChestItemSource.getInstance(), false),
    STORAGE((class_2561)class_2561.method_43471((String)"cookies.item_source.storage"), StorageItemSource.getInstance(), true),
    SACKS((class_2561)class_2561.method_43471((String)"cookies.item_source.sack"), SackItemSource.getInstance(), true),
    INVENTORY((class_2561)class_2561.method_43471((String)"cookies.item_source.inventory"), InventoryItemSource.getInstance(), true),
    FORGE((class_2561)class_2561.method_43471((String)"cookies.item_source.forge"), ForgeItemSource.getInstance(), false),
    VAULT((class_2561)class_2561.method_43471((String)"cookies.item_source.vault"), vault -> MiscItemSource.get(MiscItemData.Type.VAULT, vault)),
    SACK_OF_SACKS((class_2561)class_2561.method_43471((String)"cookies.item_source.sack_of_sacks"), sacks -> MiscItemSource.get(MiscItemData.Type.SACK_OF_SACKS, sacks)),
    POTION_BAG((class_2561)class_2561.method_43471((String)"cookies.item_source.potion_bag"), potionBag -> MiscItemSource.get(MiscItemData.Type.POTION_BAG, potionBag)),
    ACCESSORY_BAG((class_2561)class_2561.method_43471((String)"cookies.item_source.accessory_bag"), AccessoryItemSource.getInstance(), false),
    CRAFTABLE((class_2561)class_2561.method_43471((String)"cookies.item_source.craftable"), new CraftableItemSource(), false);

    private final class_2561 name;
    private final ItemSource<?> itemSource;
    private final boolean supportsSupercraft;

    private ItemSources(class_2561 name, Function<ItemSources, ItemSource<?>> itemSource) {
        this.name = name;
        this.itemSource = itemSource.apply(this);
        this.supportsSupercraft = false;
    }

    public static Collection<Item<?>> getItems() {
        return ItemSources.getItems(ItemSources.values());
    }

    public static Collection<Item<?>> getItems(ItemSources ... itemSources) {
        HashSet items = new HashSet();
        for (ItemSources itemSource : itemSources) {
            items.addAll(itemSource.itemSource.getAllItems());
        }
        return items;
    }

    public static ItemSources[] none() {
        return new ItemSources[0];
    }

    @Generated
    private ItemSources(class_2561 name, ItemSource<?> itemSource, boolean supportsSupercraft) {
        this.name = name;
        this.itemSource = itemSource;
        this.supportsSupercraft = supportsSupercraft;
    }

    @Generated
    public class_2561 getName() {
        return this.name;
    }

    @Generated
    public ItemSource<?> getItemSource() {
        return this.itemSource;
    }

    @Generated
    public boolean isSupportsSupercraft() {
        return this.supportsSupercraft;
    }
}

