/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.items.sources;

import codes.cookies.mod.config.categories.ItemSearchCategory;
import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemSource;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.CraftRecipe;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class CraftableItemSource
implements ItemSource<Data> {
    @Override
    public Collection<Item<?>> getAllItems() {
        Collection<Item<?>> items = ItemSources.getItems((ItemSources[])ArrayUtils.remove((Object[])ItemSources.values(), (int)ItemSources.CRAFTABLE.ordinal()));
        HashMap<RepositoryItem, Integer> repoItemMap = new HashMap<RepositoryItem, Integer>();
        HashMap<RepositoryItem, Integer> superCraftAvailable = new HashMap<RepositoryItem, Integer>();
        HashMap itemList = new HashMap();
        for (Item<?> item : items) {
            RepositoryItem repositoryItem = (RepositoryItem)item.itemStack().method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM);
            repoItemMap.computeIfPresent(repositoryItem, (r, amount) -> amount + item.amount());
            repoItemMap.computeIfAbsent(repositoryItem, r -> item.amount());
            List orDefault = itemList.getOrDefault(repositoryItem, new ArrayList());
            orDefault.add(item);
            itemList.put(repositoryItem, orDefault);
            if (!item.source().isSupportsSupercraft()) continue;
            superCraftAvailable.computeIfPresent(repositoryItem, (r, amount) -> amount + item.amount());
            superCraftAvailable.computeIfAbsent(repositoryItem, r -> item.amount());
        }
        ArrayList craftable = new ArrayList();
        for (CraftRecipe allCraftRecipe : Recipe.ALL_CRAFT_RECIPES) {
            if (allCraftRecipe.getOutput() == null) continue;
            boolean hasAllIngredients = true;
            HashMap<Ingredient, IngredientData> map = new HashMap<Ingredient, IngredientData>();
            boolean canSupercraft = true;
            boolean partialItems = false;
            boolean showSupercraftWarning = false;
            for (Ingredient ingredient : allCraftRecipe.getIngredients()) {
                RepositoryItem repositoryItem = ingredient.getRepositoryItem();
                if (repositoryItem == null) {
                    hasAllIngredients = false;
                    map.put(ingredient, IngredientData.EMPTY);
                    continue;
                }
                int superCraftAmount = Objects.requireNonNullElse((Integer)superCraftAvailable.get(repositoryItem), 0);
                int normalAmount = Objects.requireNonNullElse((Integer)repoItemMap.get(repositoryItem), 0);
                boolean bl = hasAllIngredients = hasAllIngredients && normalAmount >= ingredient.getAmount();
                if (normalAmount == 0) {
                    map.put(ingredient, IngredientData.EMPTY);
                    continue;
                }
                IngredientData ingredientData = new IngredientData(itemList.getOrDefault(repositoryItem, Collections.emptyList()), normalAmount, superCraftAmount, superCraftAmount >= ingredient.getAmount(), normalAmount >= ingredient.getAmount());
                canSupercraft = canSupercraft && ingredientData.canSupercraft();
                partialItems = partialItems || ingredientData.hasAllItems();
                showSupercraftWarning = showSupercraftWarning || ingredientData.hasAllItems() && !ingredientData.canSupercraft();
                map.put(ingredient, ingredientData);
            }
            if (!ItemSearchCategory.enableNonCraftableItems && !hasAllIngredients) continue;
            craftable.add(new Item<Data>(allCraftRecipe.getOutput().getAsItem(), ItemSources.CRAFTABLE, 1, new Data(map, hasAllIngredients, canSupercraft, partialItems, showSupercraftWarning, allCraftRecipe.getOutput())));
        }
        return craftable;
    }

    @Override
    public ItemSources getType() {
        return ItemSources.CRAFTABLE;
    }

    @Override
    public void remove(Item<?> item) {
    }

    public record IngredientData(List<Item<?>> items, int available, int availableSupercraft, boolean canSupercraft, boolean hasAllItems) {
        public static IngredientData EMPTY = new IngredientData(Collections.emptyList(), 0, 0, false, false);

        public boolean shouldBeIncluded() {
            if (ItemSearchCategory.showOnlyMissingItems) {
                return this.hasAllItems && !this.canSupercraft;
            }
            return true;
        }
    }

    public record Data(Map<Ingredient, IngredientData> amounts, boolean hasAllIngredients, boolean canSupercraft, boolean hasPartialItems, boolean showSupercraftWarning, Ingredient output) {
    }
}

