/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.items.sources;

import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemSource;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.sub.MiscItemData;
import codes.cookies.mod.utils.dev.FunctionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class MiscItemSource
implements ItemSource<Context> {
    @Override
    public Collection<Item<?>> getAllItems() {
        Optional<ProfileData> optionalProfile = ProfileStorage.getCurrentProfile();
        if (optionalProfile.isEmpty()) {
            return Collections.emptyList();
        }
        return optionalProfile.get().getMiscTracker().getValue().stream().filter(this::doFilter).map(this::map).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean doFilter(MiscItemData.MiscItem miscItem) {
        return true;
    }

    private Item<?> map(MiscItemData.MiscItem miscItem) {
        return new Item<Context>(miscItem.itemStack(), this.getType(), miscItem.itemStack().method_7947(), new Context(miscItem.type(), miscItem.slot()));
    }

    @Override
    public void remove(Item<?> item) {
        Context data = (Context)item.data();
        ProfileStorage.getCurrentProfile().map(ProfileData::getMiscTracker).map(FunctionUtils.function(MiscItemData::remove)).orElseGet(FunctionUtils::noOp2).accept(data.type, data.slot);
    }

    public static MiscItemSource get(final MiscItemData.Type type, final ItemSources sources) {
        return new MiscItemSource(){

            @Override
            public boolean doFilter(MiscItemData.MiscItem miscItem) {
                return miscItem.type() == type;
            }

            @Override
            public ItemSources getType() {
                return sources;
            }
        };
    }

    public record Context(MiscItemData.Type type, int slot) {
    }
}

