/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.migrations;

import codes.cookies.mod.data.Migration;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ProfileDataMigration_0001
implements Migration<JsonObject> {
    @Override
    public int getNumber() {
        return 1;
    }

    @Override
    public void apply(JsonObject value) {
        JsonElement storageData = value.remove("storage_data");
        if (storageData == null) {
            return;
        }
        JsonArray newData = new JsonArray();
        this.processOne(storageData.getAsJsonObject().getAsJsonObject("ender_chest"), newData, true);
        this.processOne(storageData.getAsJsonObject().getAsJsonObject("backpack"), newData, false);
        value.add("storage_data", (JsonElement)newData);
    }

    private void processOne(JsonObject object, JsonArray newData, boolean isEnderchest) {
        if (object == null) {
            return;
        }
        String location = isEnderchest ? "ENDER_CHEST" : "BACKPACK";
        for (String s : object.keySet()) {
            int page = Integer.parseInt(s);
            JsonArray asJsonArray = object.getAsJsonArray(s);
            for (JsonElement jsonElement : asJsonArray) {
                JsonObject itemStack;
                if (!jsonElement.isJsonObject()) {
                    return;
                }
                JsonObject entry = jsonElement.getAsJsonObject();
                int slot = entry.has("slot") ? entry.get("slot").getAsInt() : -1;
                JsonObject jsonObject = itemStack = entry.has("item_stack") ? entry.get("item_stack").getAsJsonObject() : null;
                if (slot == -1 || itemStack == null) continue;
                JsonObject newEntry = new JsonObject();
                newEntry.addProperty("location", location);
                newEntry.addProperty("page", (Number)page);
                newEntry.addProperty("slot", (Number)slot);
                newEntry.add("item", (JsonElement)itemStack);
                newData.add((JsonElement)newEntry);
            }
        }
    }

    @Override
    public Migration.Type getType() {
        return Migration.Type.PROFILE;
    }
}

