/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.profile;

import codes.cookies.mod.data.DataMigrations;
import codes.cookies.mod.data.Migration;
import codes.cookies.mod.data.player.PlayerStorage;
import codes.cookies.mod.data.profile.profile.GlobalProfileData;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.json.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class GlobalProfileStorage {
    private static final String LOGGING_KEY = "globalProfileStorage";
    private static final Path PROFILE_DATA_FOLDER = Path.of("config/cookiesmod/profiles", new String[0]);

    private GlobalProfileStorage() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static GlobalProfileData load(UUID uuid) {
        Path profileFile = PROFILE_DATA_FOLDER.resolve(String.valueOf(uuid) + ".json");
        if (!Files.exists(profileFile, new LinkOption[0])) {
            GlobalProfileData globalProfileData = new GlobalProfileData(uuid);
            GlobalProfileStorage.save(globalProfileData);
            return globalProfileData;
        }
        DevUtils.log(LOGGING_KEY, "Loading global profile data from %s", profileFile);
        JsonObject jsonObject = (JsonObject)JsonUtils.CLEAN_GSON.fromJson(ExceptionHandler.removeThrows(() -> Files.readString(profileFile, StandardCharsets.UTF_8)), JsonObject.class);
        if (!DataMigrations.migrate(jsonObject, Migration.Type.GLOBAL_PROFILE)) {
            CookiesUtils.sendFailedMessage("Failed to apply a mandatory data migration, resetting local global profile data!");
            return new GlobalProfileData(uuid);
        }
        return JsonUtils.fromJson(new GlobalProfileData(uuid), jsonObject);
    }

    public static void save(GlobalProfileData globalProfileData) {
        if (globalProfileData == null) {
            return;
        }
        if (PlayerStorage.getCurrentPlayer().isEmpty() || SkyblockUtils.getLastProfileId().isEmpty()) {
            return;
        }
        Path profileFile = PROFILE_DATA_FOLDER.resolve(String.valueOf(globalProfileData.getUuid()) + ".json");
        DevUtils.log(LOGGING_KEY, "Saving global profile data to %s", profileFile);
        ExceptionHandler.removeThrows(() -> Files.createDirectories(profileFile.getParent(), new FileAttribute[0]));
        JsonObject jsonObject = JsonUtils.toJsonObject(globalProfileData);
        DataMigrations.writeLatest(jsonObject, Migration.Type.GLOBAL_PROFILE);
        ExceptionHandler.removeThrows(() -> Files.writeString(profileFile, (CharSequence)JsonUtils.CLEAN_GSON.toJson((JsonElement)jsonObject), StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
    }
}

