/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.profile;

import codes.cookies.mod.events.ChestSaveEvent;
import codes.cookies.mod.utils.json.CodecJsonSerializable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_5699;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IslandChestStorage
implements CodecJsonSerializable<List<ChestItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IslandChestStorage.class);
    private final List<ChestItem> items = new ArrayList<ChestItem>();

    public void save(class_2338 blockPos, class_2338 secondChest, class_1799 stack, int slot) {
        Optional.ofNullable(ChestItem.create(blockPos, secondChest, stack, slot)).ifPresent(this.items::add);
    }

    private List<ChestItem> getItems(class_2338 pos) {
        return this.items.stream().filter(chestItem -> pos.equals((Object)chestItem.blockPos)).toList();
    }

    public void removeBlockSlot(class_2338 blockPos, int slot) {
        this.items.removeIf(item -> blockPos.equals((Object)item.blockPos) && item.slot == slot);
    }

    public void remove(ChestItem chestItem) {
        this.items.remove(chestItem);
    }

    public void removeBlock(class_2338 blockPos) {
        if (blockPos == null) {
            return;
        }
        this.items.removeIf(item -> blockPos.equals((Object)item.blockPos));
        Iterator<ChestItem> iterator = this.items.iterator();
        ArrayList toAdd = new ArrayList();
        while (iterator.hasNext()) {
            ChestItem chestItem = iterator.next();
            if (chestItem.secondChest == null || !chestItem.secondChest.isPresent() || !chestItem.secondChest.get().equals((Object)blockPos)) continue;
            iterator.remove();
            Optional.ofNullable(ChestItem.create(chestItem.blockPos, null, chestItem.itemStack, chestItem.slot)).ifPresent(toAdd::add);
        }
        this.items.addAll(toAdd);
    }

    public void clear() {
        this.items.clear();
    }

    @Override
    public Codec<List<ChestItem>> getCodec() {
        return ChestItem.LIST_CODEC;
    }

    @Override
    public void load(List<ChestItem> value) {
        this.items.addAll(value);
    }

    @Override
    public List<ChestItem> getValue() {
        return this.items;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public void sendEvent(class_2338 blockPos, class_2338 second) {
        if (blockPos != null && second != null) {
            ArrayList<ChestItem> bothItems = new ArrayList<ChestItem>();
            bothItems.addAll(this.getItems(blockPos));
            bothItems.addAll(this.getItems(second));
            ((ChestSaveEvent)ChestSaveEvent.EVENT.invoker()).onSave(blockPos, second, bothItems);
            return;
        }
        if (blockPos != null) {
            ((ChestSaveEvent)ChestSaveEvent.EVENT.invoker()).onSave(blockPos, second, this.getItems(blockPos));
        }
    }

    @Generated
    public List<ChestItem> getItems() {
        return this.items;
    }

    public record ChestItem(class_2338 blockPos, Optional<class_2338> secondChest, class_1799 itemStack, int slot) {
        public static Codec<ChestItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("block_pos").forGetter(ChestItem::blockPos), (App)class_2338.field_25064.optionalFieldOf("second_chest").forGetter(ChestItem::secondChest), (App)class_1799.field_24671.fieldOf("item").forGetter(ChestItem::itemStack), (App)class_5699.field_33441.fieldOf("slot").forGetter(ChestItem::slot)).apply((Applicative)instance, ChestItem::new));
        private static final Codec<List<ChestItem>> LIST_CODEC = CODEC.listOf();

        public static ChestItem create(class_2338 pos, class_2338 secondChest, class_1799 itemStack, int slot) {
            if (pos == null) {
                return null;
            }
            itemStack.method_57381(class_9334.field_49633);
            itemStack.method_57381(class_9334.field_52175);
            return new ChestItem(pos, Optional.ofNullable(secondChest), itemStack, slot);
        }
    }
}

