/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.sub;

import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.json.CodecJsonSerializable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForgeTracker
implements CodecJsonSerializable<List<Data>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForgeTracker.class);
    private final List<Data> data = new ArrayList<Data>();

    public void saveItem(RepositoryItem item, int slot, long timeStartedSeconds) {
        this.removeItem(slot);
        this.data.add(new Data(item, timeStartedSeconds + 1L, slot));
    }

    public void removeItem(int slot) {
        this.data.removeIf(data -> data.slot == slot);
    }

    @Override
    public Codec<List<Data>> getCodec() {
        return Data.LIST_CODEC;
    }

    @Override
    public void load(List<Data> value) {
        this.data.addAll(value);
    }

    @Override
    public List<Data> getValue() {
        return this.data;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public void remove(int slot) {
        this.data.removeIf(data -> data.slot == slot);
    }

    @Generated
    public List<Data> getData() {
        return this.data;
    }

    public record Data(RepositoryItem repositoryItem, long startedSeconds, int slot) {
        public static Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RepositoryItem.ID_CODEC.optionalFieldOf("item").xmap(item -> item.orElse(null), Optional::ofNullable).forGetter(Data::repositoryItem), (App)Codec.LONG.fieldOf("startedSeconds").forGetter(Data::startedSeconds), (App)Codec.INT.fieldOf("slot").forGetter(Data::slot)).apply((Applicative)instance, Data::new));
        public static Codec<List<Data>> LIST_CODEC = CODEC.listOf();
    }
}

