/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.sub;

import codes.cookies.mod.data.profile.sub.ForgeTracker;
import codes.cookies.mod.utils.json.CodecJsonSerializable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntBooleanImmutablePair;
import it.unimi.dsi.fastutil.ints.IntBooleanPair;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotmData
implements CodecJsonSerializable<List<Entry>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForgeTracker.class);
    private final CopyOnWriteArrayList<Entry> list = new CopyOnWriteArrayList();

    public void remove(String id) {
        this.list.removeIf(entry -> entry.id.equalsIgnoreCase(id));
    }

    public void save(String id, int level, boolean enabled) {
        this.remove(id);
        this.list.add(new Entry(id, level, enabled));
    }

    @Nullable
    public IntBooleanPair getStatus(String id) {
        return this.list.stream().filter(entry -> entry.id.equalsIgnoreCase(id)).findFirst().map(this::toPair).orElse(null);
    }

    private IntBooleanPair toPair(Entry entry) {
        return new IntBooleanImmutablePair(entry.level, entry.enabled);
    }

    @Override
    public Codec<List<Entry>> getCodec() {
        return Entry.LIST_CODEC;
    }

    @Override
    public void load(List<Entry> value) {
        this.list.addAll(value);
    }

    @Override
    public List<Entry> getValue() {
        return this.list;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public double getQuickForgeMultiplier() {
        IntBooleanPair quickForge = this.getStatus("quick_forge");
        if (quickForge == null || !quickForge.secondBoolean()) {
            return 1.0;
        }
        int level = quickForge.firstInt();
        double reduction = Math.min(30.0, (double)(10.0f + (float)level * 0.5f) + Math.floor((float)level / 20.0f) * 10.0);
        double reductionPercentage = reduction / 100.0;
        return 1.0 - reductionPercentage;
    }

    public record Entry(String id, int level, boolean enabled) {
        public static Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Entry::id), (App)Codec.INT.fieldOf("level").forGetter(Entry::level), (App)Codec.BOOL.fieldOf("enabled").forGetter(Entry::enabled)).apply((Applicative)instance, Entry::new));
        public static Codec<List<Entry>> LIST_CODEC = CODEC.listOf();
    }
}

