/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.sub;

import codes.cookies.mod.utils.json.CodecJsonSerializable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_3542;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiscItemData
implements CodecJsonSerializable<List<MiscItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiscItemData.class);
    private final List<MiscItem> items = new ArrayList<MiscItem>();

    @Override
    public Codec<List<MiscItem>> getCodec() {
        return MiscItem.LIST_CODEC;
    }

    @Override
    public void load(List<MiscItem> value) {
        this.items.clear();
        this.items.addAll(value);
    }

    @Override
    public List<MiscItem> getValue() {
        return this.items;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public void removeAll(Type type) {
        this.items.removeIf(item -> item.type == type);
    }

    public void save(Type type, class_1799 stack, int slot) {
        this.items.add(MiscItem.create(type, stack, slot));
    }

    public void remove(Type type, int slot) {
        this.items.removeIf(item -> item.type == type && item.slot == slot);
    }

    public record MiscItem(Type type, class_1799 itemStack, int slot) {
        private static final Codec<MiscItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("type").forGetter(MiscItem::type), (App)class_1799.field_24671.fieldOf("item").forGetter(MiscItem::itemStack), (App)Codec.INT.fieldOf("slot").forGetter(MiscItem::slot)).apply((Applicative)instance, MiscItem::create));
        private static final Codec<List<MiscItem>> LIST_CODEC = CODEC.listOf();

        public static MiscItem create(Type type, class_1799 itemStack, int slot) {
            itemStack.method_57381(class_9334.field_52175);
            itemStack.method_57381(class_9334.field_49633);
            return new MiscItem(type, itemStack, slot);
        }
    }

    public static enum Type implements class_3542
    {
        VAULT("Personal Vault"),
        SACK_OF_SACKS("Sack of Sacks"),
        POTION_BAG("Potion Bag");

        public static final Codec<Type> CODEC;
        private final String name;

        public String method_15434() {
            return this.name();
        }

        @Generated
        private Type(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }
}

