/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.sub;

import codes.cookies.mod.events.SackContentsChangeCallback;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.json.JsonSerializable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class SackTracker
implements JsonSerializable {
    private final Map<RepositoryItem, Integer> items = new ConcurrentHashMap<RepositoryItem, Integer>();

    @Override
    public void read(@NotNull JsonElement jsonElement) {
        if (!jsonElement.isJsonObject()) {
            logger.error("Failed to read sack tracker because element is not an object.\nResetting tracker.");
            return;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (String key : jsonObject.keySet()) {
            RepositoryItem repositoryItem = RepositoryItem.of(key);
            if (repositoryItem == null) continue;
            this.items.put(repositoryItem, jsonObject.get(key).getAsInt());
        }
    }

    @Override
    @NotNull
    public JsonElement write() {
        JsonObject jsonObject = new JsonObject();
        this.items.forEach((repositoryItem, integer) -> jsonObject.addProperty(repositoryItem.getInternalId(), (Number)integer));
        return jsonObject;
    }

    public void set(RepositoryItem item, int value) {
        Integer previous = this.items.get(item);
        if (previous != null) {
            ((BiConsumer)SackContentsChangeCallback.DELTA_CALLBACK.invoker()).accept(item, value - previous);
        }
        this.items.put(item, value);
        ((BiConsumer)SackContentsChangeCallback.CALLBACK.invoker()).accept(item, value);
    }

    public void modify(RepositoryItem item, int value) {
        ((BiConsumer)SackContentsChangeCallback.DELTA_CALLBACK.invoker()).accept(item, value);
        this.items.compute(item, (key, oldValue) -> Math.max(oldValue == null ? value : oldValue + value, 0));
        ((BiConsumer)SackContentsChangeCallback.CALLBACK.invoker()).accept(item, this.items.get(item));
    }

    public void clear() {
        this.items.clear();
    }

    @Generated
    public Map<RepositoryItem, Integer> getItems() {
        return this.items;
    }
}

