/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.data.profile.sub;

import codes.cookies.mod.utils.json.CodecJsonSerializable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3542;
import net.minecraft.class_3545;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageData
implements CodecJsonSerializable<List<StorageItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageData.class);
    private static final class_1799 VOID_ITEM = new class_1799((class_1935)class_1802.field_8688);
    private final List<StorageItem> items = new ArrayList<StorageItem>();

    public void saveItems(List<class_3545<Integer, class_1799>> itemStacks, int page, StorageLocation location) {
        this.items.removeAll(this.getItems(page, location));
        itemStacks.stream().map(pair -> this.createItem((class_1799)pair.method_15441(), page, (Integer)pair.method_15442(), location)).forEach(this.items::add);
    }

    public StorageItem createItem(class_1799 itemStack, int page, int slot, StorageLocation location) {
        return StorageItem.create(location, page, slot, itemStack);
    }

    public void saveItem(class_1799 itemStack, int page, int slot, StorageLocation location) {
        this.removeItem(page, slot, location);
        this.items.add(this.createItem(itemStack, page, slot, location));
    }

    public void removeItem(int page, int slot, StorageLocation location) {
        this.items.remove(this.getItem(page, slot, location));
    }

    public List<StorageItem> getItems(int page, StorageLocation location) {
        return this.items.stream().filter(item -> item.storageLocation() == location).filter(item -> item.page() == page).toList();
    }

    public StorageItem getItem(int page, int slot, StorageLocation location) {
        return this.items.stream().filter(item -> item.storageLocation() == location).filter(item -> item.page() == page).filter(item -> item.slot() == slot).findFirst().orElse(null);
    }

    public List<StorageItem> getAllItems() {
        return this.items;
    }

    public void clear() {
        this.items.clear();
    }

    @Override
    public Codec<List<StorageItem>> getCodec() {
        return StorageItem.LIST_CODEC;
    }

    @Override
    public void load(List<StorageItem> value) {
        this.items.addAll(value);
    }

    @Override
    public List<StorageItem> getValue() {
        return this.items;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public static enum StorageLocation implements class_3542
    {
        ENDER_CHEST("cookies.item_source.enderchest"),
        BACKPACK("cookies.item_source.backpack");

        private final String translationKey;
        public static final Codec<StorageLocation> CODEC;

        public String method_15434() {
            return this.name();
        }

        @Generated
        public String getTranslationKey() {
            return this.translationKey;
        }

        @Generated
        private StorageLocation(String translationKey) {
            this.translationKey = translationKey;
        }

        static {
            CODEC = class_3542.method_28140(StorageLocation::values);
        }
    }

    public record StorageItem(StorageLocation storageLocation, int page, int slot, class_1799 itemStack) {
        private final class_1799 itemStack;
        private static final Codec<StorageItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StorageLocation.CODEC.fieldOf("location").forGetter(StorageItem::storageLocation), (App)Codec.INT.fieldOf("page").forGetter(StorageItem::page), (App)Codec.INT.fieldOf("slot").forGetter(StorageItem::slot), (App)class_1799.field_24671.fieldOf("item").forGetter(StorageItem::getActualItemStack)).apply((Applicative)instance, StorageItem::create));
        private static final Codec<List<StorageItem>> LIST_CODEC = CODEC.listOf();

        public static StorageItem create(StorageLocation location, int page, int slot, class_1799 itemStack) {
            itemStack.method_57381(class_9334.field_52175);
            itemStack.method_57381(class_9334.field_49633);
            if (itemStack.method_7960()) {
                return new StorageItem(location, page, slot, VOID_ITEM);
            }
            return new StorageItem(location, page, slot, itemStack);
        }

        public class_1799 itemStack() {
            if (this.itemStack.method_31574(class_1802.field_8688)) {
                return class_1799.field_8037;
            }
            return this.itemStack;
        }

        public class_1799 getActualItemStack() {
            if (this.itemStack.method_7960()) {
                return VOID_ITEM;
            }
            return this.itemStack;
        }
    }
}

