/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.events;

import codes.cookies.mod.utils.cookies.CookiesUtils;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class InventoryEvents {
    public static void afterInit(String name, Predicate<class_465<?>> shouldInstrument, InventoryEvent inventoryEvent) {
        InventoryEvents.register(name, shouldInstrument, inventoryEvent, ScreenEvents.AFTER_INIT, event -> (client, screen, scaledWidth, scaledHeight) -> InventoryEvents.invokeIfInventory(screen, event));
    }

    private static <T> void register(String name, Predicate<class_465<?>> shouldInstrument, InventoryEvent inventoryEvent, Event<T> event, Function<InventoryEvent, T> inventoryEventMapper) {
        event.register(inventoryEventMapper.apply(InventoryEvents.registerInternal(name, shouldInstrument, inventoryEvent)));
    }

    private static void invokeIfInventory(class_437 screen, InventoryEvent inventoryEvent) {
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 handledScreen = (class_465)screen;
        inventoryEvent.open(handledScreen);
    }

    private static InventoryEvent registerInternal(String name, Predicate<class_465<?>> shouldInstrument, InventoryEvent inventoryEvent) {
        return screen -> {
            if (screen.method_25440() == null) {
                return;
            }
            String literalName = screen.method_25440().getString();
            if (!CookiesUtils.match(literalName, name)) {
                return;
            }
            if (!shouldInstrument.test(screen)) {
                return;
            }
            inventoryEvent.open(screen);
        };
    }

    public static void remove(class_437 originalScreen, String name, Predicate<class_465<?>> shouldInstrument, InventoryEvent inventoryEvent) {
        InventoryEvents.register(name, shouldInstrument, inventoryEvent, ScreenEvents.remove((class_437)originalScreen), event -> screen -> InventoryEvents.invokeIfInventory(screen, event));
    }

    public static void beforeInit(String name, Predicate<class_465<?>> shouldInstrument, InventoryEvent inventoryEvent) {
        InventoryEvents.register(name, shouldInstrument, inventoryEvent, ScreenEvents.BEFORE_INIT, event -> (client, screen, scaledWidth, scaledHeight) -> InventoryEvents.invokeIfInventory(screen, event));
    }

    private static <T> void register(String name, Event<T> event, InventoryEvent inventoryEvent, Function<InventoryEvent, T> inventoryEventMapper) {
        InventoryEvents.register(name, screen -> true, inventoryEvent, event, inventoryEventMapper);
    }

    public static interface InventoryEvent {
        public void open(class_465<?> var1);
    }
}

