/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons;

import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_465;

public class CroesusHelper {
    public CroesusHelper(class_465<?> handledScreen) {
        InventoryContentUpdateEvent.registerSlot(handledScreen.method_17577(), this::update);
    }

    public static void init() {
        InventoryEvents.beforeInit("Croesus", Predicates.alwaysTrue().and(o -> LocationUtils.Island.DUNGEON_HUB.isActive()), CroesusHelper::open);
    }

    private static void open(class_465<?> handledScreen) {
        if (!DungeonCategory.highlightUnclaimedChests) {
            return;
        }
        new CroesusHelper(handledScreen);
    }

    private void update(class_1735 slot) {
        class_1799 stack = slot.method_7677();
        if (!stack.method_31574(class_1802.field_8575)) {
            return;
        }
        String literalStackName = CookiesUtils.stripColor(stack.method_7964().getString());
        if (!this.isCatacombsOrMasterModeMame(literalStackName)) {
            return;
        }
        Optional<List<String>> optionalLore = ItemUtils.getLore(stack);
        if (optionalLore.isEmpty()) {
            return;
        }
        List<String> lore = optionalLore.get().stream().map(String::trim).toList();
        boolean hasntOpenedChests = lore.contains("No Chests Opened!");
        class_1792 backgroundStackItem = hasntOpenedChests ? class_1802.field_8581 : class_1802.field_8871;
        stack.method_57379(CookiesDataComponentTypes.BACKGROUND_ITEM, (Object)new class_1799((class_1935)backgroundStackItem));
    }

    private boolean isCatacombsOrMasterModeMame(String name) {
        return name.equalsIgnoreCase("Master Mode The Catacombs") || name.equalsIgnoreCase("The Catacombs");
    }
}

