/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons;

import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.events.ChatMessageEvents;
import codes.cookies.mod.features.dungeons.CroesusHelper;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.DungeonListeners;
import codes.cookies.mod.features.dungeons.SpiritLeapOverlay;
import codes.cookies.mod.features.dungeons.chests.CroesusChestHelper;
import codes.cookies.mod.features.dungeons.map.DungeonMapHud;
import codes.cookies.mod.features.dungeons.map.DungeonType;
import codes.cookies.mod.features.dungeons.solver.terminals.ChangeAllToSameColorTerminalSolver;
import codes.cookies.mod.features.dungeons.solver.terminals.ClickInOrderTerminalSolver;
import codes.cookies.mod.features.dungeons.solver.terminals.CorrectAllThePanesTerminalSolver;
import codes.cookies.mod.features.dungeons.solver.terminals.MelodyTerminalSolver;
import codes.cookies.mod.features.dungeons.solver.terminals.SelectAllColorsTerminalSolver;
import codes.cookies.mod.features.dungeons.solver.terminals.StartsWithTerminalSolver;
import codes.cookies.mod.render.hud.HudManager;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.maths.RomanNumerals;
import codes.cookies.mod.utils.skyblock.PartyUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.minecraft.class_2960;

public class DungeonFeatures {
    private static final class_2960 SEND_DEBUG_MESSAGES = DevUtils.createIdentifier("dungeons/send_debug_messages");
    private DungeonInstance currentInstance = null;
    private final Cache<String, DungeonInstance> cache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(45L, TimeUnit.MINUTES).removalListener(this::removeInstance).build();
    private long dungeonInstanceCreatorTime = -1L;
    private CompletableFuture<String> dungeonInstanceCreator;
    private static DungeonFeatures instance;

    private void removeInstance(RemovalNotification<String, DungeonInstance> listener) {
        DungeonFeatures.sendDebugMessage("Destroying dungeon instance for server " + (String)listener.getKey());
        Optional.ofNullable((DungeonInstance)listener.getValue()).ifPresent(DungeonInstance::destroy);
    }

    public DungeonFeatures() {
        if (instance != null) {
            throw new IllegalStateException("DungeonFeatures has already been initialized");
        }
        instance = this;
        ChatMessageEvents.register(this::onDungeonJoin, "cookies-regex:-+\\n(\\[.*?] )?[a-zA-Z0-9_]{1,16} entered (.*?), (Floor (.*?)|Entrance)!\n.*");
        DungeonListeners.initialize();
        new SelectAllColorsTerminalSolver();
        new StartsWithTerminalSolver();
        new ClickInOrderTerminalSolver();
        new CorrectAllThePanesTerminalSolver();
        new ChangeAllToSameColorTerminalSolver();
        new MelodyTerminalSolver();
        SpiritLeapOverlay.init(this);
        CroesusHelper.init();
        CroesusChestHelper.init();
        HudManager.register(DungeonMapHud.getInstance());
    }

    private void onDungeonJoin(String string) {
        int floorLevel;
        if (!DungeonCategory.useDungeonFeatures) {
            return;
        }
        String entered = string.split("entered ")[1].split("\n")[0];
        String[] split = entered.split(",");
        String type = split[0];
        DungeonType dungeonType = DungeonType.of(type);
        if (split[1].contains("Entrance")) {
            floorLevel = 0;
        } else {
            String floor = split[1].trim().substring(6).replace("!", "");
            floorLevel = RomanNumerals.romanToArabic(floor);
        }
        this.awaitDungeonCreation(dungeonType, floorLevel);
    }

    private void awaitDungeonCreation(DungeonType dungeonType, int floorLevel) {
        DungeonFeatures.sendDebugMessage("Awaiting dungeon creation " + dungeonType.name().toLowerCase() + " " + floorLevel);
        this.dungeonInstanceCreator = new CompletableFuture();
        this.dungeonInstanceCreatorTime = System.currentTimeMillis();
        PartyUtils.request();
        this.dungeonInstanceCreator.whenComplete(this.createDungeon(dungeonType, floorLevel));
    }

    private BiConsumer<? super String, ? super Throwable> createDungeon(DungeonType dungeonType, int floorLevel) {
        return (string, throwable) -> {
            DungeonInstance dungeonInstance = new DungeonInstance(dungeonType, floorLevel, (String)string);
            if (this.currentInstance != null) {
                this.currentInstance.unload();
            }
            this.setInstance(dungeonInstance);
        };
    }

    private void setInstance(DungeonInstance dungeonInstance) {
        this.currentInstance = dungeonInstance;
        if (this.currentInstance != null) {
            this.currentInstance.load();
            this.cache.put((Object)this.currentInstance.serverId(), (Object)this.currentInstance);
        }
    }

    public void startDungeon(String serverId) {
        this.exitDungeon();
        if (this.dungeonInstanceCreatorTime + 20000L < System.currentTimeMillis()) {
            this.setInstance((DungeonInstance)this.cache.getIfPresent((Object)serverId));
        }
        if (this.currentInstance != null) {
            DungeonFeatures.sendDebugMessage("Restored dungeon session " + this.currentInstance.serverId());
        }
        if (this.currentInstance == null && this.dungeonInstanceCreator != null) {
            this.dungeonInstanceCreator.complete(serverId);
            this.dungeonInstanceCreator = null;
            this.dungeonInstanceCreatorTime = -1L;
        }
    }

    public void exitDungeon() {
        if (this.currentInstance != null) {
            this.currentInstance.unload();
            DungeonFeatures.sendDebugMessage("Removed dungeon session " + this.currentInstance.serverId());
        }
        this.currentInstance = null;
    }

    public Optional<DungeonInstance> getCurrentInstance() {
        if (this.currentInstance != null && this.currentInstance.getPlayer() == null) {
            this.startDungeon("");
            return Optional.empty();
        }
        return Optional.ofNullable(this.currentInstance);
    }

    public static void sendDebugMessage(String message) {
        if (!DevUtils.isEnabled(SEND_DEBUG_MESSAGES)) {
            return;
        }
        CookiesUtils.sendInformation(message);
    }

    @Generated
    public static DungeonFeatures getInstance() {
        return instance;
    }
}

