/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons;

import codes.cookies.mod.api.ws.WebsocketConnection;
import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.events.dungeon.DungeonEvents;
import codes.cookies.mod.features.dungeons.DungeonFeatures;
import codes.cookies.mod.features.dungeons.DungeonPlayer;
import codes.cookies.mod.features.dungeons.map.DungeonMap;
import codes.cookies.mod.features.dungeons.map.DungeonMapRenderer;
import codes.cookies.mod.features.dungeons.map.DungeonPhase;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.map.DungeonType;
import codes.cookies.mod.features.dungeons.map.PuzzleType;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolverInstance;
import codes.cookies.mod.features.dungeons.solver.puzzle.WaterBoardPuzzleSolver;
import codes.cookies.mod.utils.skyblock.PartyUtils;
import codes.cookies.mod.utils.skyblock.playerlist.PlayerListUtils;
import dev.morazzer.cookies.entities.websocket.Packet;
import dev.morazzer.cookies.entities.websocket.packets.DungeonJoinPacket;
import dev.morazzer.cookies.entities.websocket.packets.DungeonLeavePacket;
import dev.morazzer.cookies.entities.websocket.packets.DungeonSyncPlayerLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.joml.Vector2i;

public final class DungeonInstance {
    private static final Pattern PLAYER_PATTERN = Pattern.compile("^\\[(\\d+)] (?:\\[\\w+] )?(\\w+) .?[\u2672\u24b7 ]? ?\\((\\w+)(?: (\\w+))?\\)$");
    private final DungeonType type;
    private final int floor;
    private final String serverId;
    private DungeonPlayer currentPlayer;
    private final DungeonPlayer[] players = new DungeonPlayer[5];
    private final Map<String, Integer> playerIdMap = new HashMap<String, Integer>();
    private String playerNick;
    private DungeonPhase phase = DungeonPhase.BEFORE;
    private final DungeonMap dungeonMap;
    private DungeonMapRenderer mapRenderer;
    private final UUID partyLeader;
    private final boolean relayToBackend;
    private final boolean debugInstance;
    private String[] puzzles = null;
    private final List<class_3545<PuzzleType, Integer>> knownPuzzles = new ArrayList<class_3545<PuzzleType, Integer>>();
    private long lastPuzzleUpdate = -1L;
    private final PuzzleSolverInstance puzzleSolverInstance;
    private DungeonRoom currentRoom;
    private final long timeStarted;

    public DungeonInstance(DungeonType type, int floor, String serverId) {
        this.type = type;
        this.floor = floor;
        this.serverId = serverId;
        DungeonFeatures.sendDebugMessage("Created dungeon instance, %s:%s for server %s".formatted(new Object[]{type, floor, serverId}));
        this.dungeonMap = new DungeonMap(this);
        this.partyLeader = PartyUtils.getPartyLeader();
        if (serverId.contains("cookies_internal_")) {
            this.relayToBackend = false;
            this.debugInstance = true;
        } else {
            this.debugInstance = false;
            this.relayToBackend = this.partyLeader != null && DungeonCategory.relayToBackend;
        }
        this.timeStarted = System.currentTimeMillis();
        this.puzzleSolverInstance = new PuzzleSolverInstance(this);
    }

    public int getRoomAmount() {
        return switch (this.floor) {
            case 0 -> 4;
            case 1, 2, 3 -> 5;
            case 4, 5, 6, 7 -> 6;
            default -> -1;
        };
    }

    public boolean isLastColumnPuzzlesOnly() {
        return switch (this.floor) {
            case 4, 5, 6 -> true;
            default -> false;
        };
    }

    public DungeonType type() {
        return this.type;
    }

    public int floor() {
        return this.floor;
    }

    public String serverId() {
        return this.serverId;
    }

    public void unload() {
        this.send(new DungeonLeavePacket());
        DungeonFeatures.sendDebugMessage("Unloading %s".formatted(this.serverId));
        this.puzzleSolverInstance.unloadCurrent();
        this.mapRenderer = null;
    }

    public void send(Packet<?> packet) {
        if (!this.relayToBackend) {
            return;
        }
        WebsocketConnection.sendMessageAsync(packet);
    }

    public void load() {
        this.subscribe();
        this.mapRenderer = new DungeonMapRenderer(this);
    }

    public void destroy() {
        WaterBoardPuzzleSolver.LeverType.remove(this);
    }

    public void processSecrets(String s) {
        this.dungeonMap.updateSecrets(s);
    }

    public void syncPlayers() {
        class_746 player = this.getPlayer();
        class_638 world = class_310.method_1551().field_1687;
        if (player == null || world == null) {
            return;
        }
        if (this.phase == DungeonPhase.BEFORE || this.phase == DungeonPhase.BOSS || this.phase == DungeonPhase.AFTER) {
            return;
        }
        for (class_742 worldPlayer : world.method_18456()) {
            String name;
            DungeonPlayer dungeonPlayer;
            if (worldPlayer == null || (dungeonPlayer = this.getPlayer(name = this.getName(worldPlayer))) == null || dungeonPlayer.isSkip() || !dungeonPlayer.wasRecentlyUpdateLocal() || dungeonPlayer.isUsingMod() && !dungeonPlayer.isSelf()) continue;
            this.send(new DungeonSyncPlayerLocation(dungeonPlayer.getName(), dungeonPlayer.getX(), dungeonPlayer.getY(), dungeonPlayer.getRotation().getTarget()));
        }
    }

    public void updatePlayer(DungeonSyncPlayerLocation packet) {
        DungeonPlayer player = this.getPlayer(packet.username);
        if (player == null) {
            return;
        }
        if (player.getLastSocketUpdate() > packet.timestamp) {
            return;
        }
        player.updatePositionSocket(packet.x, packet.y);
        player.updateRotationSocket(packet.rotation);
    }

    public void subscribe() {
        this.send(new DungeonJoinPacket(this.serverId, this.partyLeader));
    }

    public void updatePuzzles() {
        if (this.phase == DungeonPhase.BEFORE) {
            return;
        }
        class_746 player = this.getPlayer();
        if (player == null) {
            return;
        }
        Collection listedPlayerListEntries = player.field_3944.method_45732();
        List<class_640> list = listedPlayerListEntries.stream().filter(PlayerListUtils.isInColumn(2)).sorted(Comparator.comparingInt(PlayerListUtils::getRow)).filter(entry -> PlayerListUtils.getRow(entry) >= 7 && PlayerListUtils.getRow(entry) <= 12).toList();
        list.forEach(this::handlePuzzleEntry);
    }

    public void loadPuzzle(DungeonRoom dungeonRoom) {
        this.puzzleSolverInstance.onEnterPuzzleRoom(dungeonRoom);
    }

    public void unloadPuzzle(DungeonRoom dungeonRoom) {
        this.puzzleSolverInstance.onExitRoom(dungeonRoom);
    }

    public void swapRoom(Vector2i lastMapPosition) {
        this.unloadPuzzle(this.currentRoom);
        this.currentRoom = this.dungeonMap.getRoomAt(lastMapPosition.x, lastMapPosition.y);
        this.loadPuzzle(this.currentRoom);
    }

    private void handlePuzzleEntry(class_640 playerListEntry) {
        class_2561 displayName = playerListEntry.method_2971();
        if (displayName == null) {
            return;
        }
        this.handlePuzzleEntry(displayName, PlayerListUtils.getRow(playerListEntry));
    }

    private void handlePuzzleEntry(class_2561 text, int row) {
        String literal = text.getString().trim();
        if (literal.isEmpty() || literal.isBlank()) {
            return;
        }
        if (literal.startsWith("Puzzles")) {
            if (this.puzzles == null) {
                this.puzzles = new String[Integer.parseInt(literal.replaceAll("\\D", ""))];
            }
            return;
        }
        if (this.puzzles == null) {
            return;
        }
        int index = row - 8;
        String puzzleName = literal.substring(0, literal.lastIndexOf(":"));
        if (index >= this.puzzles.length) {
            return;
        }
        if (this.puzzles[index] == null) {
            this.puzzles[index] = puzzleName;
        }
        if (this.puzzles[index].equals(puzzleName)) {
            return;
        }
        this.puzzles[index] = puzzleName;
        this.knownPuzzles.removeIf(pair -> (Integer)pair.method_15441() == index);
        this.knownPuzzles.add((class_3545<PuzzleType, Integer>)new class_3545((Object)PuzzleType.ofName(puzzleName), (Object)index));
        this.knownPuzzles.sort(Comparator.comparingInt(class_3545::method_15441));
        this.lastPuzzleUpdate = System.currentTimeMillis();
    }

    public void periodicalTicks5() {
        if (this.getPhase() == DungeonPhase.BLOOD && (this.getPlayerPosition().field_1352 > (double)(-200 + 32 * this.dungeonMap.getRoomsInX()) || this.getPlayerPosition().field_1350 > (double)(-200 + 32 * this.dungeonMap.getRoomsInY()))) {
            this.setPhase(DungeonPhase.BOSS);
            return;
        }
        if (this.getPhase() == DungeonPhase.BEFORE || this.getPhase() == DungeonPhase.CLEAR || this.getPhase() == DungeonPhase.BLOOD) {
            this.dungeonMap.updateMap();
        }
    }

    public class_243 getPlayerPosition() {
        if (this.getPlayer() == null) {
            return class_243.field_1353;
        }
        return this.getPlayer().method_19538();
    }

    @Nullable
    public class_746 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    private String getName(class_742 clientPlayer) {
        if (clientPlayer == null) {
            return "?";
        }
        return clientPlayer.method_5477().getString();
    }

    public void updatePlayersFromWorld() {
        for (DungeonPlayer player : this.players) {
            if (player == null) continue;
            if (class_310.method_1551().field_1687 == null) {
                return;
            }
            if (!class_310.method_1551().field_1687.method_18456().contains(player.getPlayer()) || player.getPlayer() == null) continue;
            player.updatePositionLocal((int)player.getPlayer().method_23317(), (int)player.getPlayer().method_23321());
            player.updateRotationLocal(player.getPlayer().method_5791());
        }
    }

    public void updatePlayers() {
        class_746 player = this.getPlayer();
        if (player == null) {
            return;
        }
        Collection listedPlayerListEntries = player.field_3944.method_45732();
        List<class_640> list = listedPlayerListEntries.stream().filter(PlayerListUtils.isInColumn(0)).sorted(Comparator.comparingInt(PlayerListUtils::getRow)).toList();
        if (list.isEmpty()) {
            return;
        }
        int index = 0;
        for (class_640 playerListEntry : list) {
            Matcher matcher;
            String listEntry;
            class_2561 displayName = playerListEntry.method_2971();
            if (displayName == null || !(listEntry = displayName.getString()).startsWith("[") || !listEntry.matches("\\[\\d+].*") || !(matcher = PLAYER_PATTERN.matcher(listEntry)).find()) continue;
            String name = matcher.group(2);
            String clazz = matcher.group(3);
            String clazzLevel = matcher.group(4);
            if (this.getPlayer().method_5477().getString().equals(name)) {
                if (this.currentPlayer == null) {
                    this.currentPlayer = new DungeonPlayer(this, name, clazz, clazzLevel);
                }
                this.currentPlayer.setPlayerListEntry(playerListEntry);
                this.currentPlayer.update(name, clazz, clazzLevel);
                continue;
            }
            if (this.players[index] == null || this.players[index] == this.currentPlayer) {
                this.players[index] = new DungeonPlayer(this, name, clazz, clazzLevel);
            }
            this.players[index].setPlayerListEntry(playerListEntry);
            this.playerIdMap.put(name, index);
            this.players[index].update(name, clazz, clazzLevel);
            ++index;
        }
        if (this.currentPlayer != null) {
            if (this.players[index] == null || this.players[index] != this.currentPlayer) {
                this.players[index] = this.currentPlayer;
            }
            this.playerIdMap.put(this.currentPlayer.getName(), index);
        } else if (this.playerNick == null) {
            for (class_640 playerListEntry : player.field_3944.method_2880()) {
                if (!playerListEntry.method_2966().getId().equals(player.method_5667())) continue;
                this.playerNick = Optional.ofNullable(playerListEntry.method_2971()).map(class_2561::getString).orElse(null);
                break;
            }
        }
    }

    @Nullable
    public DungeonPlayer getPlayer(int index) {
        if (this.players.length <= index) {
            return null;
        }
        return this.players[index];
    }

    @Nullable
    public DungeonPlayer getPlayer(String name) {
        int playerIndex = this.getPlayerIndex(name);
        if (playerIndex == -1) {
            return null;
        }
        return this.players[playerIndex];
    }

    public int applyOffset(@Range(from=0L, to=4L) int start) {
        if (start < this.players.length - 1 && this.players[start] != null && this.players[start].isSkip()) {
            return this.applyOffset(start + 1);
        }
        return start;
    }

    private int getPlayerIndex(String playerName) {
        return this.playerIdMap.getOrDefault(playerName, -1);
    }

    public void setPhase(DungeonPhase phase) {
        ((Consumer)DungeonEvents.DUNGEON_PHASE_CHANGE.invoker()).accept(phase);
        DungeonFeatures.sendDebugMessage("Change phase to " + String.valueOf((Object)phase));
        this.phase = phase;
    }

    @Generated
    public DungeonPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    @Generated
    public DungeonPlayer[] getPlayers() {
        return this.players;
    }

    @Generated
    public DungeonPhase getPhase() {
        return this.phase;
    }

    @Generated
    public DungeonMap getDungeonMap() {
        return this.dungeonMap;
    }

    @Generated
    public DungeonMapRenderer getMapRenderer() {
        return this.mapRenderer;
    }

    @Generated
    public boolean isDebugInstance() {
        return this.debugInstance;
    }

    @Generated
    public List<class_3545<PuzzleType, Integer>> getKnownPuzzles() {
        return this.knownPuzzles;
    }

    @Generated
    public long getLastPuzzleUpdate() {
        return this.lastPuzzleUpdate;
    }

    @Generated
    public PuzzleSolverInstance getPuzzleSolverInstance() {
        return this.puzzleSolverInstance;
    }

    @Generated
    public DungeonRoom getCurrentRoom() {
        return this.currentRoom;
    }

    @Generated
    public long getTimeStarted() {
        return this.timeStarted;
    }
}

