/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons;

import codes.cookies.mod.events.ChatMessageEvents;
import codes.cookies.mod.events.IslandChangeEvent;
import codes.cookies.mod.events.WebsocketEvent;
import codes.cookies.mod.features.dungeons.DungeonFeatures;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.map.DungeonPhase;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.FunctionUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import dev.morazzer.cookies.entities.websocket.Packet;
import dev.morazzer.cookies.entities.websocket.packets.DungeonSyncPlayerLocation;
import dev.morazzer.cookies.entities.websocket.packets.DungeonUpdateRoomSecrets;
import java.util.Optional;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;

public class DungeonListeners {
    private static int ticks = 0;

    public static void initialize() {
        ClientTickEvents.END_CLIENT_TICK.register(DungeonListeners::clientTick);
        IslandChangeEvent.EVENT.register(DungeonListeners::onIslandChange);
        Packet.onReceive(DungeonSyncPlayerLocation.class, DungeonListeners::syncPlayerLocation);
        Packet.onReceive(DungeonUpdateRoomSecrets.class, DungeonListeners::updateRoomSecrets);
        ChatMessageEvents.BEFORE_MODIFY.register(DungeonListeners::receiveGameMessage);
        WebsocketEvent.CONNECT.register(DungeonListeners::connectWebsocket);
        WorldRenderEvents.BEFORE_ENTITIES.register(DungeonListeners::beforeEntities);
        UseBlockCallback.EVENT.register(DungeonListeners::rightClickBlock);
    }

    private static void clientTick(class_310 minecraftClient) {
        DungeonListeners.getInstance().ifPresent(instance -> {
            if (++ticks % 20 == 0) {
                ticks = 0;
            }
            instance.updatePlayers();
            instance.updatePuzzles();
            if (ticks % 5 == 0) {
                instance.periodicalTicks5();
            }
            if (ticks % 2 == 0) {
                instance.syncPlayers();
            }
            instance.getPuzzleSolverInstance().getCurrent().ifPresent(PuzzleSolver::tick);
        });
    }

    private static void onIslandChange(LocationUtils.Island previous, LocationUtils.Island current) {
        if (current == LocationUtils.Island.CATACOMBS) {
            DungeonFeatures.getInstance().startDungeon(LocationUtils.getLastServer());
        } else {
            DungeonFeatures.getInstance().exitDungeon();
        }
    }

    private static void syncPlayerLocation(DungeonSyncPlayerLocation packet) {
        DungeonListeners.getInstance().ifPresent(instance -> instance.updatePlayer(packet));
    }

    private static void updateRoomSecrets(DungeonUpdateRoomSecrets packet) {
        DungeonListeners.getInstance().ifPresent(instance -> {
            DungeonRoom roomAt = instance.getDungeonMap().getRoomAt(packet.roomMapX, packet.roomMapY);
            if (roomAt != null) {
                if (roomAt.getMaxSecrets() < packet.maxSecrets) {
                    roomAt.setMaxSecrets(packet.maxSecrets);
                }
                roomAt.setCollectedSecrets(packet.collectedSecrets);
            }
        });
    }

    private static void receiveGameMessage(class_2561 text, boolean isOverlay) {
        DungeonListeners.getInstance().ifPresent(instance -> {
            String string = CookiesUtils.stripColor(text.getString()).trim();
            if (isOverlay) {
                if (!string.endsWith("Secrets")) {
                    instance.processSecrets(null);
                    return;
                }
                String s = string.replaceAll(".* (\\d+/\\d+ Secrets).*", "$1");
                String[] split = s.split(" ");
                instance.processSecrets(split[0]);
            } else {
                if (string.contains("> EXTRA STATS <")) {
                    instance.setPhase(DungeonPhase.AFTER);
                }
                instance.getPuzzleSolverInstance().getCurrent().map(FunctionUtils.function(PuzzleSolver::onChatMessage)).orElseGet(FunctionUtils::noOp).accept(string);
                instance.getPuzzleSolverInstance().getAll().forEach(puzzleSolver -> puzzleSolver.onUnloadedChatMessage(string));
            }
        });
    }

    private static void connectWebsocket() {
        DungeonListeners.getInstance().ifPresent(DungeonInstance::subscribe);
    }

    private static void beforeEntities(WorldRenderContext worldRenderContext) {
        DungeonListeners.getInstance().ifPresent(instance -> {
            worldRenderContext.tickCounter().method_60637(false);
            instance.getPuzzleSolverInstance().getCurrent().map(FunctionUtils.function(PuzzleSolver::beforeRender)).orElseGet(FunctionUtils::noOp).accept(Float.valueOf(worldRenderContext.tickCounter().method_60637(false)));
        });
    }

    private static class_1269 rightClickBlock(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        DungeonListeners.getInstance().ifPresent(instance -> instance.getPuzzleSolverInstance().getCurrent().map(FunctionUtils.function(PuzzleSolver::onInteract)).orElseGet(FunctionUtils::noOp3).accept((Object)world, (Object)blockHitResult, (Object)hand));
        return class_1269.field_5811;
    }

    private static Optional<DungeonInstance> getInstance() {
        return DungeonFeatures.getInstance().getCurrentInstance();
    }
}

