/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons;

import codes.cookies.mod.config.categories.dungeons.ClassColorCategory;
import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.DungeonPosition;
import codes.cookies.mod.utils.Result;
import codes.cookies.mod.utils.accessors.GlowingEntityAccessor;
import codes.cookies.mod.utils.cookies.CookiesBackendUtils;
import codes.cookies.mod.utils.maths.InterpolatedInteger;
import codes.cookies.mod.utils.maths.LinearInterpolatedInteger;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import java.util.OptionalInt;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DungeonPlayer {
    private UUID uuid;
    @Nullable
    private class_742 player;
    private String name;
    private int classLevel;
    private InterpolatedInteger rotation = new LinearInterpolatedInteger(50L, 0);
    private String dungeonClass;
    private class_640 playerListEntry;
    private DungeonInstance dungeonInstance;
    private DungeonPosition position;
    private boolean skip;
    private long lastLocalUpdate;
    private long lastSocketUpdate;

    public DungeonPlayer(DungeonInstance dungeonInstance, String name, String clazz, String clazzLevel) {
        this.dungeonInstance = dungeonInstance;
        this.name = name;
        this.findUuid();
        this.dungeonClass = clazz;
        this.setClassLevel(clazzLevel);
        this.position = new DungeonPosition(0, 0, dungeonInstance);
        this.updateGlowColor();
    }

    private void findUuid() {
        class_310 instance = class_310.method_1551();
        if (instance == null || instance.field_1687 == null) {
            return;
        }
        class_638 world = instance.field_1687;
        for (class_742 player : world.method_18456()) {
            if (player.method_5477() == null || !player.method_5477().getString().equals(this.name)) continue;
            this.uuid = player.method_5667();
            this.player = player;
            return;
        }
    }

    private void updateGlowColor() {
        if (this.player != null && DungeonCategory.glowInClassColor && this.getColor().isPresent()) {
            GlowingEntityAccessor.setGlowing((class_1297)this.player, true);
            GlowingEntityAccessor.setGlowColor((class_1297)this.player, this.getColor().getAsInt());
        }
    }

    private void setClassLevel(String classLevel) {
        int level;
        try {
            level = Integer.parseInt(classLevel);
        }
        catch (NumberFormatException e) {
            level = 0;
        }
        this.classLevel = level;
    }

    public int getX() {
        return DungeonPosition.target(this.position::getWorldX);
    }

    public int getY() {
        return DungeonPosition.target(this.position::getWorldY);
    }

    public Result<ItemBuilder, String> getItem() {
        return this.getItem(true);
    }

    public Result<ItemBuilder, String> getItem(boolean useSkullsIfPossible) {
        if (this.player != null && useSkullsIfPossible) {
            if (this.isSelf()) {
                return Result.success(new ItemBuilder(class_1802.field_8575).set(class_9334.field_49617, new class_9296(class_310.method_1551().method_53462())));
            }
            return Result.success(new ItemBuilder(class_1802.field_8575).set(class_9334.field_49617, new class_9296(this.player.method_7334())));
        }
        if (this.dungeonClass == null) {
            return Result.error("Neither player nor class found");
        }
        char[] charArray = this.dungeonClass.toCharArray();
        if (charArray.length == 0) {
            return Result.error("Neither player nor class found");
        }
        ItemBuilder itemBuilder = new ItemBuilder(class_1802.field_8575);
        switch (this.dungeonClass.toLowerCase().toCharArray()[0]) {
            case 't': {
                itemBuilder.setSkin("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmE1MjYzMmE5YzhmN2JkZTk0NzE5MDY0MjM0OTIwZGVkNDg2MTRlMmJkOGJjOTFhZmU3ZmZjMmNkOGE0NmYxOSJ9fX0=");
                break;
            }
            case 'm': {
                itemBuilder.setSkin("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmI5YzQ5ZmZkZjRjZTRjNmY1ZjA0OWVmYzhjYTBlMDhiOWI1YmJmM2M2YTg3ODNkZmFhY2NhZDc3ZGZjOTk3YSJ9fX0=");
                break;
            }
            case 'h': {
                itemBuilder.setSkin("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjgzMjM2NjM5NjA3MDM2YzFiYTM5MWMyYjQ2YTljN2IwZWZkNzYwYzhiZmEyOTk2YTYwNTU1ODJiNGRhNSJ9fX0=");
                break;
            }
            case 'b': {
                itemBuilder.setSkin("ewogICJ0aW1lc3RhbXAiIDogMTY5MjI5ODIyMjY4MywKICAicHJvZmlsZUlkIiA6ICI4NzE3ZGFhNmM3OTU0NzE2YmJlYWQ0MDRkYzg0NDQzZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJTa3VsbDAwMDAiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTUyMjg2NzcyMTJiZTQzZWFhZDIzZDQ3ZWQ4NDNlMTVmYjFlNjgzODQ1OTRjMDliNThiMjNmODI0MjdlNTQ5YSIKICAgIH0KICB9Cn0=");
                break;
            }
            case 'a': {
                itemBuilder.setSkin("ewogICJ0aW1lc3RhbXAiIDogMTY5NzYyNzM1MDg1NSwKICAicHJvZmlsZUlkIiA6ICIxMzEzZGFmMDc2OGQ0YmQ5Yjc1ODJkMGI1NWUwZGQxNiIsCiAgInByb2ZpbGVOYW1lIiA6ICJMZW50aWNjaGllIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2U5YzU4OGE4YjYyYWZmZDc0NjQzZTBkNjY0MWJkYTNhMDc4NGEzMDRjNTc5YzA2N2ZhNDk1ZTJjNDNlYzk0NjIiCiAgICB9CiAgfQp9");
                break;
            }
            default: {
                return Result.error("Unknown class: " + this.dungeonClass);
            }
        }
        return Result.success(itemBuilder);
    }

    public boolean isSelf() {
        return this.player instanceof class_746;
    }

    public OptionalInt getColor() {
        if (this.dungeonClass == null || this.dungeonClass.isEmpty()) {
            return OptionalInt.empty();
        }
        return switch (this.dungeonClass.toLowerCase().toCharArray()[0]) {
            case 'h' -> OptionalInt.of(ClassColorCategory.healer);
            case 'm' -> OptionalInt.of(ClassColorCategory.mage);
            case 'b' -> OptionalInt.of(ClassColorCategory.bers);
            case 'a' -> OptionalInt.of(ClassColorCategory.arch);
            case 't' -> OptionalInt.of(ClassColorCategory.tank);
            default -> OptionalInt.empty();
        };
    }

    public void updatePositionSocket(int x, int y) {
        if (this.wasRecentlyUpdateLocal()) {
            this.lastSocketUpdate = System.currentTimeMillis();
            return;
        }
        this.setPosition(x, y);
        this.lastSocketUpdate = System.currentTimeMillis();
    }

    public boolean wasRecentlyUpdateLocal() {
        return System.currentTimeMillis() - this.lastLocalUpdate < 500L;
    }

    public void setPosition(int x, int y) {
        this.position.setWorldX(x);
        this.position.setWorldY(y);
    }

    public void updatePositionLocal(int x, int y) {
        this.setPosition(x, y);
        this.lastLocalUpdate = System.currentTimeMillis();
    }

    public void setPosition(byte x, byte y) {
        if (this.wasRecentlyUpdated()) {
            return;
        }
        this.position.setMapX((x + 128) / 2);
        this.position.setMapY((y + 128) / 2);
    }

    public boolean wasRecentlyUpdated() {
        return this.wasRecentlyUpdatedSocket() || this.wasRecentlyUpdateLocal();
    }

    public boolean wasRecentlyUpdatedSocket() {
        return System.currentTimeMillis() - this.lastSocketUpdate < 500L;
    }

    public void updateRotationSocket(int rotation) {
        if (this.wasRecentlyUpdateLocal()) {
            this.lastSocketUpdate = System.currentTimeMillis();
            return;
        }
        this.setRotationWithWrap(rotation);
        this.lastSocketUpdate = System.currentTimeMillis();
    }

    private void setRotationWithWrap(int newRotation) {
        int rotation = newRotation - this.rotation.getValue();
        if (rotation > 180) {
            this.rotation.setValue(this.rotation.getValue() + 360);
        } else if (rotation < -180) {
            this.rotation.setValue(this.rotation.getValue() - 360);
        }
        this.rotation.setTargetValue(newRotation);
    }

    public void updateRotationLocal(float rotation) {
        int newRotation = (int)(rotation % 360.0f);
        this.setRotationWithWrap(newRotation);
        this.lastLocalUpdate = System.currentTimeMillis();
    }

    public void setRotation(byte rotation) {
        if (this.wasRecentlyUpdated()) {
            return;
        }
        int i = Math.round((float)rotation * 22.5f % 360.0f);
        this.setRotationWithWrap(i);
    }

    public void update(String name, String clazz, String clazzLevel) {
        this.name = name;
        this.findUuid();
        switch (clazz) {
            case "EMPTY": 
            case "DEAD": {
                this.skip = true;
                break;
            }
            default: {
                this.skip = false;
                this.dungeonClass = clazz;
                this.setClassLevel(clazzLevel);
                this.updateGlowColor();
            }
        }
    }

    public void tick() {
        this.position.tick();
        this.rotation.tick();
    }

    public int getInterpolatedX() {
        return DungeonPosition.interpolated(this.position::getMapX);
    }

    public int getInterpolatedY() {
        return DungeonPosition.interpolated(this.position::getMapY);
    }

    public boolean isUsingMod() {
        if (this.uuid == null) {
            return false;
        }
        return CookiesBackendUtils.usesMod(this.uuid);
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    @Generated
    public class_742 getPlayer() {
        return this.player;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getClassLevel() {
        return this.classLevel;
    }

    @Generated
    public InterpolatedInteger getRotation() {
        return this.rotation;
    }

    @Generated
    public String getDungeonClass() {
        return this.dungeonClass;
    }

    @Generated
    public class_640 getPlayerListEntry() {
        return this.playerListEntry;
    }

    @Generated
    public DungeonInstance getDungeonInstance() {
        return this.dungeonInstance;
    }

    @Generated
    public DungeonPosition getPosition() {
        return this.position;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public long getLastLocalUpdate() {
        return this.lastLocalUpdate;
    }

    @Generated
    public long getLastSocketUpdate() {
        return this.lastSocketUpdate;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setPlayer(@Nullable class_742 player) {
        this.player = player;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDungeonClass(String dungeonClass) {
        this.dungeonClass = dungeonClass;
    }

    @Generated
    public void setPlayerListEntry(class_640 playerListEntry) {
        this.playerListEntry = playerListEntry;
    }

    @Generated
    public void setDungeonInstance(DungeonInstance dungeonInstance) {
        this.dungeonInstance = dungeonInstance;
    }

    @Generated
    public void setPosition(DungeonPosition position) {
        this.position = position;
    }

    @Generated
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Generated
    public void setLastLocalUpdate(long lastLocalUpdate) {
        this.lastLocalUpdate = lastLocalUpdate;
    }

    @Generated
    public void setLastSocketUpdate(long lastSocketUpdate) {
        this.lastSocketUpdate = lastSocketUpdate;
    }
}

