/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons;

import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.map.DungeonMap;
import codes.cookies.mod.utils.maths.InterpolatedInteger;
import codes.cookies.mod.utils.maths.LinearInterpolatedInteger;
import com.mojang.datafixers.util.Function4;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import lombok.Generated;
import net.minecraft.class_3532;
import org.joml.Vector2i;

public class DungeonPosition {
    private final InterpolatedInteger worldX;
    private final InterpolatedInteger worldY;
    private final DungeonInstance dungeonInstance;

    public DungeonPosition(int worldX, int worldY, DungeonInstance dungeonInstance) {
        this.worldX = new LinearInterpolatedInteger(100L, worldX);
        this.worldY = new LinearInterpolatedInteger(100L, worldY);
        this.dungeonInstance = dungeonInstance;
    }

    public static ToIntFunction<DungeonPosition> toInt(Function<DungeonPosition, Integer> toInt) {
        return toInt::apply;
    }

    public static Function<DungeonPosition, Integer> interpolate(BiFunction<DungeonPosition, Function<InterpolatedInteger, Integer>, Integer> mapper) {
        return value -> (Integer)mapper.apply((DungeonPosition)value, InterpolatedInteger::getValue);
    }

    public static Function<DungeonPosition, Integer> target(BiFunction<DungeonPosition, Function<InterpolatedInteger, Integer>, Integer> mapper) {
        return value -> (Integer)mapper.apply((DungeonPosition)value, InterpolatedInteger::getTarget);
    }

    public static int interpolated(Function<Function<InterpolatedInteger, Integer>, Integer> mapper) {
        return mapper.apply(InterpolatedInteger::getValue);
    }

    public static int target(Function<Function<InterpolatedInteger, Integer>, Integer> mapper) {
        return mapper.apply(InterpolatedInteger::getTarget);
    }

    public int getMapX(Function<InterpolatedInteger, Integer> mapper) {
        return this.withCoordinates(this.map(mapper.apply(this.worldX), DungeonMap::getRoomsInX, Vector2i::x, this::mapWorldCoordinatesToMap), this::zero);
    }

    public int getMapY(Function<InterpolatedInteger, Integer> mapper) {
        return this.withCoordinates(this.map(mapper.apply(this.worldY), DungeonMap::getRoomsInY, Vector2i::y, this::mapWorldCoordinatesToMap), this::zero);
    }

    public int getWorldX(Function<InterpolatedInteger, Integer> mapper) {
        return mapper.apply(this.worldX);
    }

    public int getWorldY(Function<InterpolatedInteger, Integer> mapper) {
        return mapper.apply(this.worldY);
    }

    public void setWorldX(int worldX) {
        this.worldX.setTargetValue(worldX);
    }

    public void setWorldY(int worldY) {
        this.worldY.setTargetValue(worldY);
    }

    public int getRoomMapX(Function<InterpolatedInteger, Integer> mapper) {
        return this.mapToRoomMap(mapper.apply(this.worldX));
    }

    public int getRoomMapY(Function<InterpolatedInteger, Integer> mapper) {
        return this.mapToRoomMap(mapper.apply(this.worldY));
    }

    public void setRoomMapX(int x) {
        this.worldX.setTargetValue(this.mapRoomMapToWorld(x));
    }

    public void setRoomMapY(int y) {
        this.worldY.setTargetValue(this.mapRoomMapToWorld(y));
    }

    public void setMapX(int mapX) {
        this.worldX.setTargetValue(this.withCoordinates(this.map(mapX, DungeonMap::getRoomsInX, Vector2i::x, this::mapMapCoordinatesToWorld), this::zero));
    }

    public void setMapY(int mapY) {
        this.worldY.setTargetValue(this.withCoordinates(this.map(mapY, DungeonMap::getRoomsInY, Vector2i::y, this::mapMapCoordinatesToWorld), this::zero));
    }

    public void tick() {
        this.worldX.tick();
        this.worldY.tick();
    }

    private DungeonMap getDungeonMap() {
        return this.dungeonInstance.getDungeonMap();
    }

    private int mapRoomMapToWorld(int value) {
        return value * 32 - 200;
    }

    private int mapToRoomMap(int value) {
        return Math.round(((float)value + 200.0f) / 32.0f * 2.0f) / 2;
    }

    private int zero() {
        return 0;
    }

    private int mapWorldCoordinatesToMap(int value, int topLeft, int bottomRight, int rooms) {
        return (int)class_3532.method_37958((float)value, (float)-200.0f, (float)(-200 + rooms * 32), (float)topLeft, (float)bottomRight);
    }

    private int mapMapCoordinatesToWorld(int value, int topLeft, int bottomRight, int rooms) {
        return (int)class_3532.method_37958((float)value, (float)topLeft, (float)bottomRight, (float)-200.0f, (float)(-200 + rooms * 32));
    }

    private <T> BiFunction<Vector2i, Vector2i, T> map(T value, Function<DungeonMap, T> rooms, Function<Vector2i, T> mapper, Function4<T, T, T, T, T> function) {
        return (topLeft, topRight) -> function.apply(value, mapper.apply((Vector2i)topLeft), mapper.apply((Vector2i)topRight), rooms.apply(this.getDungeonMap()));
    }

    private <T> T withCoordinates(BiFunction<Vector2i, Vector2i, T> consumer, Supplier<T> defaultValue) {
        Vector2i topLeft = this.getTopLeft();
        Vector2i bottomRight = this.getBottomRight();
        if (topLeft == null || bottomRight == null) {
            return defaultValue.get();
        }
        return consumer.apply(topLeft, bottomRight);
    }

    private Vector2i getTopLeft() {
        if (this.dungeonInstance == null) {
            return null;
        }
        return this.dungeonInstance.getDungeonMap().getTopLeftPixel();
    }

    private Vector2i getBottomRight() {
        if (this.dungeonInstance == null) {
            return null;
        }
        return this.dungeonInstance.getDungeonMap().getBottomRightPixel();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DungeonPosition) {
            DungeonPosition other = (DungeonPosition)obj;
            return this.worldX == other.worldX && this.worldY == other.worldY;
        }
        return super.equals(obj);
    }

    @Generated
    public DungeonInstance getDungeonInstance() {
        return this.dungeonInstance;
    }
}

