/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons;

import codes.cookies.mod.config.categories.dungeons.SpiritLeapCategory;
import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.features.dungeons.DungeonFeatures;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.DungeonPlayer;
import codes.cookies.mod.features.dungeons.map.DungeonMapHud;
import codes.cookies.mod.features.dungeons.map.DungeonMapRenderer;
import codes.cookies.mod.screen.CookiesScreen;
import codes.cookies.mod.utils.Result;
import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.ChatUtils;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_7532;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiritLeapOverlay {
    private static final class_2960 DEBUG = DevUtils.createIdentifier("dungeons/spirit_skip");
    private static final Logger log = LoggerFactory.getLogger(SpiritLeapOverlay.class);
    public static boolean isOpen;
    private static DungeonFeatures features;
    private final class_465<?> handledScreen;
    private final Player[] actualPlayers = new Player[4];
    private final Player[] players = new Player[4];
    private int amountOfPlayers = -1;
    private int rows = 1;
    private int columns = 1;
    private boolean enableCustomLeap = true;

    public SpiritLeapOverlay(class_465<?> handledScreen) {
        isOpen = true;
        this.handledScreen = handledScreen;
        ScreenEvents.beforeRender(handledScreen).register(this::beforeRender);
        ScreenEvents.afterRender(handledScreen).register(this::afterRender);
        InventoryContentUpdateEvent.registerSlot(handledScreen.method_17577(), this::update);
        ScreenMouseEvents.allowMouseClick(handledScreen).register(this::mouseClicked);
        ScreenMouseEvents.allowMouseRelease(handledScreen).register(this::mouseRelease);
        ScreenMouseEvents.allowMouseScroll(handledScreen).register(this::mouseScroll);
        ScreenKeyboardEvents.allowKeyPress(handledScreen).register(this::allowKey);
        ScreenKeyboardEvents.allowKeyRelease(handledScreen).register((screen, key, scancode, modifiers) -> false);
        ScreenEvents.remove(handledScreen).register(screen -> {
            isOpen = false;
        });
    }

    public static void init(DungeonFeatures features) {
        SpiritLeapOverlay.features = features;
        InventoryEvents.beforeInit("Spirit Leap", Predicates.alwaysTrue().and(o -> DungeonFeatures.getInstance().getCurrentInstance().isPresent()).or(o -> DevUtils.isEnabled(DEBUG)), SpiritLeapOverlay::open);
    }

    private static void open(class_465<?> handledScreen) {
        if (!SpiritLeapCategory.modifyNormalIfPossible && !SpiritLeapCategory.spiritLeapUi) {
            return;
        }
        new SpiritLeapOverlay(handledScreen);
    }

    private void beforeRender(class_437 screen, class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (!this.enableCustomLeap) {
            return;
        }
        drawContext.method_44379(0, 0, 0, 0);
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416(10000.0f, 0.0f, 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void afterRender(class_437 screen, class_332 drawContext, int mouseX, int mouseY, float delta) {
        DungeonMapRenderer mapRenderer;
        if (!this.enableCustomLeap) {
            return;
        }
        drawContext.method_44380();
        drawContext.method_51448().method_22909();
        drawContext.method_51448().method_22903();
        int startX = drawContext.method_51421() / 4;
        int endX = drawContext.method_51421() / 4 * 3;
        int offsetY = drawContext.method_51443() / 8;
        int startY = drawContext.method_51443() / 4 - offsetY;
        int endY = drawContext.method_51443() / 2 - offsetY;
        int width = endX - startX;
        int height = endY - startY;
        int individualWidth = width / this.columns;
        int individualHeight = height / this.rows;
        for (int i = 0; i < this.players.length; ++i) {
            Player player = this.players[i];
            if (player == null || player.slot.method_7677().method_7960()) continue;
            int row = i / this.columns;
            int column = i % this.columns;
            int playerX = startX + individualWidth * column + 2;
            int playerY = startY + individualHeight * row + 1;
            int playerEndX = startX + individualWidth * (column + 1) - 3;
            int playerEndY = startY + individualHeight * (row + 1) - 3;
            int playerWidth = playerEndX - playerX;
            int playerHeight = playerEndY - playerY;
            player.location.x = playerX;
            player.location.y = playerY;
            player.location.width = playerWidth;
            player.location.height = playerHeight;
            class_2561 name = player.slot.method_7677().method_7964();
            int nameWidth = class_310.method_1551().field_1772.method_27525((class_5348)name);
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416((float)(playerX + playerWidth - 10), (float)playerY + (float)playerHeight / 2.0f, 1.0f);
            float maxWidth = (float)playerWidth / 4.0f * 2.5f;
            float scale = maxWidth / (float)Math.max(nameWidth, 54);
            drawContext.method_51448().method_22905(scale, scale, 1.0f);
            drawContext.method_51439(class_310.method_1551().field_1772, name, -nameWidth, -4, -1, true);
            drawContext.method_51448().method_22909();
            drawContext.method_25294(playerX, playerY, playerEndX, playerEndY, this.getColor(player));
            int size = playerHeight / 16 * 14;
            int skullOffsetY = (playerHeight - size) / 2;
            if (player.dungeonPlayer == null || player.dungeonPlayer.getPlayer() == null) {
                drawContext.method_25294(playerX + skullOffsetY, playerY + skullOffsetY, playerX + skullOffsetY + size, playerY + skullOffsetY + size, -1);
                continue;
            }
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416((float)(playerX + skullOffsetY + size), (float)(playerY + skullOffsetY + size), 1.0f);
            drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            class_7532.method_44445((class_332)drawContext, (class_2960)player.dungeonPlayer.getPlayer().method_52814().comp_1626(), (int)0, (int)0, (int)size, (boolean)true, (boolean)true, (int)-1);
            drawContext.method_51448().method_22909();
        }
        if (!SpiritLeapCategory.showMap) {
            return;
        }
        if (features.getCurrentInstance().isEmpty()) {
            if (!DevUtils.isEnabled(DEBUG)) return;
            mapRenderer = DungeonMapHud.getInstance().getMockInstance().getMapRenderer();
        } else {
            mapRenderer = features.getCurrentInstance().map(DungeonInstance::getMapRenderer).orElse(null);
        }
        if (mapRenderer == null) {
            return;
        }
        drawContext.method_51448().method_22903();
        int size = 140;
        float halfSize = 70.0f;
        drawContext.method_51448().method_46416((float)drawContext.method_51421() / 2.0f - 70.0f, (float)drawContext.method_51443() / 2.0f * 0.8f, 1.0f);
        mapRenderer.render(drawContext);
        drawContext.method_51448().method_22909();
    }

    private void update(class_1735 slot) {
        int index;
        int slotId = slot.field_7874;
        if (slotId == 0) {
            this.amountOfPlayers = -1;
            Arrays.fill(this.actualPlayers, null);
        }
        if (slotId < 11 || slotId > 15) {
            return;
        }
        if (slot.method_7677().method_7909() != class_1802.field_8575) {
            return;
        }
        if (this.amountOfPlayers == -1 || this.amountOfPlayers == 2 && slotId == 13) {
            switch (slotId) {
                case 11: {
                    int n = 4;
                    break;
                }
                case 12: {
                    int n = 2;
                    break;
                }
                case 13: {
                    int n;
                    if (this.amountOfPlayers == 2) {
                        n = 3;
                        break;
                    }
                    n = 1;
                    break;
                }
                default: {
                    int n = this.amountOfPlayers = -1;
                }
            }
            if (this.amountOfPlayers > 1) {
                this.rows = 2;
            }
            if (this.amountOfPlayers > 2) {
                this.columns = 2;
            }
        }
        DungeonPlayer dungeonPlayer = features.getCurrentInstance().map(instance -> instance.getPlayer(slot.method_7677().method_7964().getString())).orElseGet(() -> new DungeonPlayer(null, "meowora", "mage", "test"));
        int noOffset = slotId - 11;
        switch (this.amountOfPlayers) {
            case 1: {
                int n;
                if (noOffset == 2) {
                    n = 0;
                    break;
                }
                n = -1;
                break;
            }
            case 2: {
                int n;
                if (noOffset == 1) {
                    n = 0;
                    break;
                }
                if (noOffset == 3) {
                    n = 1;
                    break;
                }
                n = -1;
                break;
            }
            case 3: {
                int n = noOffset - 1;
                break;
            }
            case 4: {
                int n;
                if (noOffset == 2) {
                    n = -1;
                    break;
                }
                if (noOffset > 2) {
                    n = noOffset - 1;
                    break;
                }
                n = noOffset;
                break;
            }
            default: {
                int n = index = -1;
            }
        }
        if (index < 0 || index >= this.actualPlayers.length) {
            return;
        }
        this.actualPlayers[index] = new Player(slot, dungeonPlayer, new Location());
        if (index == this.amountOfPlayers - 1) {
            this.setPlayers();
        }
    }

    private boolean mouseClicked(class_437 screen, double mouseX, double mouseY, int button) {
        if (!this.enableCustomLeap) {
            return true;
        }
        for (Player player : this.actualPlayers) {
            if (player == null || !CookiesScreen.isInBound((int)mouseX, (int)mouseY, player.location.x, player.location.y, player.location.width, player.location.height)) continue;
            this.clickedPlayer(player.slot, player.dungeonPlayer());
            break;
        }
        return false;
    }

    private boolean mouseRelease(class_437 screen, double mouseX, double mouseY, int button) {
        return !this.enableCustomLeap;
    }

    private boolean mouseScroll(class_437 screen, double v, double v1, double v2, double v3) {
        return !this.enableCustomLeap;
    }

    private boolean allowKey(class_437 screen, int key, int scancode, int modifiers) {
        if (!this.enableCustomLeap) {
            return true;
        }
        if (this.handledScreen.method_25422() && key == 256) {
            this.handledScreen.method_25419();
        }
        if (class_310.method_1551().field_1690.field_1822.method_1417(key, scancode)) {
            this.handledScreen.method_25419();
        }
        return false;
    }

    private int getColor(Player player) {
        if (!SpiritLeapCategory.colorInClassColor) {
            return SpiritLeapCategory.colorOption;
        }
        return Optional.ofNullable(player).map(Player::dungeonPlayer).map(DungeonPlayer::getColor).orElseGet(OptionalInt::empty).orElseGet(() -> SpiritLeapCategory.colorOption);
    }

    private void setPlayers() {
        if (this.modifyNormalIfAvailable()) {
            ArrayList<DungeonPlayer> dungeonPlayers = new ArrayList<DungeonPlayer>(features.getCurrentInstance().map(DungeonInstance::getPlayers).map(Arrays::asList).orElseGet(Collections::emptyList));
            dungeonPlayers.removeIf(Objects::isNull);
            long count = dungeonPlayers.stream().map(DungeonPlayer::getDungeonClass).distinct().count();
            if (count == 5L) {
                List<String> classes = List.of("Tank", "Mage", "Healer", "Berserk", "Archer");
                int slotId = 11;
                boolean failed = false;
                ArrayList runnables = new ArrayList();
                for (String currentClass : classes) {
                    Result<Runnable, String> result = this.setClass(currentClass, dungeonPlayers, this.actualPlayers, slotId++);
                    if (result.isError()) {
                        failed = true;
                        result.getError().ifPresent(CookiesUtils::sendFailedMessage);
                        break;
                    }
                    result.getResult().ifPresent(runnables::add);
                }
                if (!failed) {
                    this.enableCustomLeap = false;
                    isOpen = false;
                    try {
                        runnables.forEach(Runnable::run);
                    }
                    catch (Exception e) {
                        CookiesUtils.sendFailedMessage("An error occurred while modifying the leap ui!");
                        log.error("Error while modifying leap ui", (Throwable)e);
                    }
                    return;
                }
            }
        }
        if (!SpiritLeapCategory.spiritLeapUi) {
            this.enableCustomLeap = false;
            return;
        }
        if (SpiritLeapCategory.sortByClassName) {
            System.arraycopy(this.actualPlayers, 0, this.players, 0, this.actualPlayers.length);
            return;
        }
        this.enableCustomLeap = true;
        List<Player> players = Arrays.stream(this.actualPlayers).filter(Objects::nonNull).sorted(Comparator.comparing(player -> Optional.ofNullable(player.dungeonPlayer()).map(DungeonPlayer::getDungeonClass).orElse(""), String::compareToIgnoreCase)).toList();
        for (int i = 0; i < players.size(); ++i) {
            Player player2;
            this.players[i] = player2 = players.get(i);
        }
    }

    public void clickedPlayer(class_1735 slot, @Nullable DungeonPlayer player) {
        class_310.method_1551().field_1761.method_2906(this.handledScreen.method_17577().field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
        if (player != null && SpiritLeapCategory.announceLeaps) {
            StringBuilder message = new StringBuilder("Leaped to ");
            message.append(player.getName());
            if (player.getPlayer() != null && SpiritLeapCategory.announceLeapCoords) {
                message.append(" at coords ").append(player.getPlayer().method_24515().method_46558().toString());
            }
            message.append("!");
            ChatUtils.sendPartyMessage(message.toString());
        }
    }

    private boolean modifyNormalIfAvailable() {
        return SpiritLeapCategory.modifyNormalIfPossible && this.amountOfPlayers == 4;
    }

    private Result<Runnable, String> setClass(String name, List<DungeonPlayer> players, Player[] leapPlayers, int slotId) {
        boolean isSelf;
        class_1735 slot = this.handledScreen.method_17577().method_7611(slotId);
        DungeonPlayer dungeonPlayer = players.stream().filter(Objects::nonNull).filter(player -> player.getDungeonClass().equals(name)).findFirst().orElse(null);
        Player leapPlayer = Arrays.stream(leapPlayers).filter(Objects::nonNull).filter(player -> player.dungeonPlayer == dungeonPlayer).findFirst().orElse(null);
        boolean bl = isSelf = leapPlayer == null;
        if (dungeonPlayer == null) {
            return Result.error("No player found for class %s".formatted(name));
        }
        return Result.success(() -> {
            Result<ItemBuilder, String> item = dungeonPlayer.getItem(SpiritLeapCategory.usePlayerHeadsInsteadOfClassItems);
            ItemBuilder itemBuilder = item.getResult().orElseGet(() -> new ItemBuilder(class_1802.field_8264)).setName("Leap to " + name).setLore(new class_2561[]{TextUtils.literal("Left-click to leap to the " + name, class_124.field_1054), class_2561.method_43473(), TextUtils.literal(name + ": " + dungeonPlayer.getName(), class_124.field_1080)}).setGlint(isSelf).setClickRunnable(() -> {
                if (isSelf) {
                    this.handledScreen.method_25419();
                    CookiesUtils.sendFailedMessage("Can't leap to yourself!");
                } else {
                    this.clickedPlayer(leapPlayer.slot, dungeonPlayer);
                }
            });
            if (DevUtils.isEnabled(DEBUG)) {
                itemBuilder.appendLore(new class_2561[]{class_2561.method_43470((String)("Leap player: " + Optional.ofNullable(leapPlayer).map(Player::dungeonPlayer).map(DungeonPlayer::getName).orElse("<empty>"))), class_2561.method_43470((String)("Dungeon Player: " + dungeonPlayer.getName()))});
            }
            if (SpiritLeapCategory.colorInClassColor) {
                itemBuilder.set(CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR, dungeonPlayer.getColor().orElse(0));
            }
            if (item.isError()) {
                itemBuilder.appendLore(new class_2561[]{class_2561.method_43473(), TextUtils.literal(item.getError().orElse("An error occurred while creating this item!"))});
            }
            slot.method_7677().method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)itemBuilder.build());
        });
    }

    private record Player(class_1735 slot, @Nullable DungeonPlayer dungeonPlayer, @NotNull Location location) {
    }

    private static class Location {
        int x;
        int y;
        int width;
        int height;

        private Location() {
        }
    }
}

