/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.chests;

import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_465;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class CroesusChestHelper {
    private final List<String> chestsNames = List.of("Wood Chest", "Gold Chest", "Diamond Chest", "Emerald Chest", "Obsidian Chest", "Bedrock Chest");

    public CroesusChestHelper(class_465<?> handledScreen) {
        InventoryContentUpdateEvent.registerSlot(handledScreen.method_17577(), this::update);
    }

    private void update(class_1735 slot) {
        class_1799 stack = slot.method_7677();
        if (!stack.method_31574(class_1802.field_8575)) {
            return;
        }
        String literalStackName = stack.method_7964().getString();
        if (!this.isChestName(literalStackName)) {
            return;
        }
        Optional<class_1799> stackForChest = this.getStackForChest(stack);
        stackForChest.ifPresent(itemStack -> this.modifyItem(stack, (class_1799)itemStack));
    }

    private void modifyItem(class_1799 originalStack, @NotNull class_1799 overrideStack) {
        ItemUtils.copy(class_9334.field_49632, originalStack, overrideStack);
        ItemUtils.copy(class_9334.field_49631, originalStack, overrideStack);
        ItemUtils.copy(class_9334.field_50239, originalStack, overrideStack);
        if (overrideStack.method_31574(class_1802.field_8575)) {
            originalStack.method_57379(CookiesDataComponentTypes.FOREGROUND_ITEM, (Object)overrideStack);
        } else {
            originalStack.method_57379(CookiesDataComponentTypes.OVERRIDE_RENDER_ITEM, (Object)overrideStack);
        }
    }

    private boolean isChestName(String name) {
        return this.chestsNames.contains(name);
    }

    public static void init() {
        InventoryEvents.beforeInit("cookies-regex:Master Mode The Catacombs - F.*", Predicates.alwaysTrue().and(o -> LocationUtils.Island.DUNGEON_HUB.isActive()), CroesusChestHelper::open);
        InventoryEvents.beforeInit("cookies-regex:The Catacombs - F.*", Predicates.alwaysTrue().and(o -> LocationUtils.Island.DUNGEON_HUB.isActive()), CroesusChestHelper::open);
    }

    private static void open(class_465<?> handledScreen) {
        if (!DungeonCategory.replaceChestItemWithHighestRarityItem) {
            return;
        }
        new CroesusChestHelper(handledScreen);
    }

    private Optional<class_1799> getStackForChest(class_1799 chest) {
        Optional<List<String>> optionalLore = ItemUtils.getLore(chest);
        if (optionalLore.isEmpty()) {
            return Optional.empty();
        }
        List<String> lore = optionalLore.get();
        List contents = lore.stream().skip(1L).takeWhile(line -> !line.isEmpty()).collect(Collectors.toList());
        contents.removeIf(string -> string.contains("Essence"));
        ArrayList<RepositoryItem> items = new ArrayList<RepositoryItem>();
        boolean containsEnchantedBooks = false;
        for (String content : contents) {
            if (content.startsWith("Enchanted Book")) {
                containsEnchantedBooks = true;
            }
            RepositoryItem.ofName(content).ifPresent(items::add);
        }
        items.sort(Comparator.comparingInt(item -> item.getTier().ordinal()));
        if (!items.isEmpty()) {
            return Optional.ofNullable(((RepositoryItem)items.getFirst()).constructItemStack());
        }
        if (containsEnchantedBooks) {
            return Optional.of(new class_1799((class_1935)class_1802.field_8598));
        }
        return Optional.empty();
    }
}

