/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.map;

import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.DungeonPlayer;
import codes.cookies.mod.features.dungeons.DungeonPosition;
import codes.cookies.mod.features.dungeons.map.Checkmark;
import codes.cookies.mod.features.dungeons.map.DungeonDoor;
import codes.cookies.mod.features.dungeons.map.DungeonPhase;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.map.PuzzleType;
import codes.cookies.mod.features.dungeons.map.RoomType;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.maths.MathUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3620;
import net.minecraft.class_746;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class DungeonMap {
    private static final class_2960 ADD_DEBUG_LINES_ON_MAP = DevUtils.createIdentifier("dungeon/debug_lines_on_map");
    private final DungeonInstance instance;
    private final DungeonRoom[][] roomMap;
    private final Set<DungeonDoor> doors = new HashSet<DungeonDoor>();
    private final Set<DungeonRoom> puzzles = new LinkedHashSet<DungeonRoom>();
    private int mapId = -1;
    private Vector2i topLeftPixel;
    private int roomSize;
    private int halfRoomSize;
    private int doorRoomSize;
    private int roomsInX = 0;
    private int roomsInY = 0;
    private Vector2i bottomRightPixel;
    private Vector2i lastMapPosition;
    private long lastRoomSwitch;

    public DungeonMap(DungeonInstance instance) {
        this.instance = instance;
        this.roomMap = new DungeonRoom[this.instance.getRoomAmount()][this.instance.getRoomAmount()];
    }

    @Contract
    public void updateMap() {
        class_746 player = this.instance.getPlayer();
        if (player == null) {
            return;
        }
        class_1799 stack = player.method_31548().method_5438(8);
        if (stack.method_7960()) {
            return;
        }
        if (!stack.method_31574(class_1802.field_8204) && this.mapId != -1) {
            this.discoverMapInfo();
            return;
        }
        class_9209 mapIdComponent = (class_9209)stack.method_57824(class_9334.field_49646);
        if (mapIdComponent != null && this.mapId == -1) {
            this.mapId = mapIdComponent.comp_2315();
        }
        if (mapIdComponent == null) {
            return;
        }
        class_22 mapState = this.getState(mapIdComponent);
        this.processMapState(mapState);
    }

    public void updateSecrets(@Nullable String secretLine) {
        if (this.canUpdateRooms()) {
            Vector2i playerMapPosition = this.getPlayerRoomMapPosition();
            DungeonRoom roomAt = this.getRoomAt(playerMapPosition.x, playerMapPosition.y);
            if (roomAt == null) {
                return;
            }
            roomAt.updateSecrets(secretLine, playerMapPosition.x, playerMapPosition.y);
        }
    }

    @Contract
    private boolean canUpdateRooms() {
        this.updateTimes();
        return System.currentTimeMillis() - this.lastRoomSwitch > 1000L;
    }

    @NotNull
    @Contract(pure=true)
    public Vector2i getPlayerRoomMapPosition() {
        class_243 playerPosition = this.instance.getPlayerPosition();
        int playerMapX = (int)Math.floor((playerPosition.field_1352 + 200.0) / 32.0);
        int playerMapY = (int)Math.floor((playerPosition.field_1350 + 200.0) / 32.0);
        return new Vector2i(playerMapX, playerMapY);
    }

    @Nullable
    @Contract
    public DungeonRoom getRoomAt(int x, int y) {
        if (x < 0 || y < 0 || x >= this.roomMap.length || y >= this.roomMap.length) {
            return null;
        }
        DungeonRoom dungeonRoom = this.roomMap[x][y];
        if (dungeonRoom != null && dungeonRoom.getMergedWith() != null) {
            this.setRoom(x, y, dungeonRoom.getMergedWith());
            if (dungeonRoom.equals(dungeonRoom.getMergedWith())) {
                dungeonRoom.setMergedWith(null);
                return dungeonRoom;
            }
            dungeonRoom.getPosition().forEach(dungeonRoom.getMergedWith()::addPosition);
            return dungeonRoom.getMergedWith();
        }
        return dungeonRoom;
    }

    @Contract
    private void updateTimes() {
        Vector2i playerMapPosition = this.getPlayerRoomMapPosition();
        if (!playerMapPosition.equals((Object)this.lastMapPosition)) {
            this.lastMapPosition = playerMapPosition;
            this.lastRoomSwitch = System.currentTimeMillis();
            this.instance.swapRoom(this.lastMapPosition);
        }
    }

    public void setRoom(int x, int y, @NotNull DungeonRoom dungeonRoom) {
        if (x < 0 || y < 0 || x >= this.roomMap.length || y >= this.roomMap.length) {
            return;
        }
        DungeonPosition dungeonPosition = new DungeonPosition(0, 0, this.instance);
        dungeonPosition.setRoomMapX(x);
        dungeonPosition.setRoomMapY(y);
        dungeonRoom.addPosition(dungeonPosition);
        this.roomMap[x][y] = dungeonRoom;
    }

    @Contract(pure=true)
    public boolean isMapDebug() {
        return DevUtils.isEnabled(ADD_DEBUG_LINES_ON_MAP);
    }

    @Contract
    public void addDoor(int x, int y, boolean left, @NotNull DungeonDoor.Type doorType) {
        for (DungeonDoor door : this.doors) {
            if (door.x() != x || door.y() != y || door.left() != left) continue;
            DungeonDoor.Type existing = door.type();
            if (DungeonCategory.keepWitherDoors) {
                if (existing == DungeonDoor.Type.UNKNOWN && doorType != DungeonDoor.Type.UNKNOWN || existing == DungeonDoor.Type.WITHER && doorType == DungeonDoor.Type.FAIRY) {
                    door.setType(doorType);
                }
            } else {
                door.setType(doorType);
            }
            return;
        }
        DungeonDoor dungeonDoor = new DungeonDoor(x, y, left, doorType);
        this.doors.add(dungeonDoor);
    }

    @Contract
    private void discoverMapInfo() {
        class_9209 mapIdComponent = new class_9209(this.mapId);
        class_22 state = this.getState(mapIdComponent);
        this.processMapState(state);
    }

    @Contract(pure=true)
    @Nullable
    private class_22 getState(@NotNull class_9209 mapIdComponent) {
        if (this.instance.getPlayer() == null) {
            return null;
        }
        return this.instance.getPlayer().method_37908().method_17891(mapIdComponent);
    }

    @Contract
    private void processMapState(class_22 mapState) {
        if (mapState == null) {
            return;
        }
        if (this.instance.getPhase() == DungeonPhase.BEFORE) {
            this.instance.setPhase(DungeonPhase.CLEAR);
        }
        this.updateTimes();
        if (this.topLeftPixel == null) {
            for (int i = 0; i < mapState.field_122.length; ++i) {
                byte color;
                int colIndex = i % 128;
                int rowIndex = i / 128;
                if (colIndex % 128 + 15 > 128 || !RoomType.SPAWN.is(color = mapState.field_122[i]) || !RoomType.SPAWN.is(mapState.field_122[i + 7]) || !RoomType.SPAWN.is(mapState.field_122[i + 15])) continue;
                int width = 0;
                while (RoomType.SPAWN.is(mapState.field_122[i + width])) {
                    ++width;
                }
                this.roomSize = width;
                this.halfRoomSize = this.roomSize / 2;
                this.doorRoomSize = this.roomSize + 4;
                int x = colIndex % this.doorRoomSize;
                int y = rowIndex % this.doorRoomSize;
                if (this.instance.floor() <= 1) {
                    x += this.doorRoomSize;
                }
                if (this.instance.floor() == 0) {
                    y += this.doorRoomSize;
                }
                this.topLeftPixel = new Vector2i(x, y);
                int mostRight = this.topLeftPixel.x;
                this.roomsInX = 0;
                while (mostRight < 128 - this.topLeftPixel.x) {
                    mostRight += this.doorRoomSize;
                    ++this.roomsInX;
                    if (!this.isMapDebug()) continue;
                    mapState.field_122[this.getMapIndex((int)mostRight, (int)0)] = (byte)class_3620.field_16020.field_16011;
                }
                this.roomsInY = 0;
                int mostDown = this.topLeftPixel.y;
                while (mostDown < 128 - this.topLeftPixel.y) {
                    mostDown += this.doorRoomSize;
                    ++this.roomsInY;
                    if (!this.isMapDebug()) continue;
                    mapState.field_122[this.getMapIndex((int)0, (int)mostDown)] = (byte)class_3620.field_16020.field_16011;
                }
                this.bottomRightPixel = new Vector2i(mostRight, mostDown).sub(4, 4);
                break;
            }
        }
        if (this.topLeftPixel != null) {
            this.scanForRooms(mapState);
            if (this.isMapDebug()) {
                mapState.field_122[this.getMapIndex((int)this.bottomRightPixel.x, (int)this.bottomRightPixel.y)] = (byte)class_3620.field_16020.field_16011;
                mapState.field_122[this.getMapIndex((int)(this.topLeftPixel.x - 1), (int)(this.topLeftPixel.y - 1))] = (byte)class_3620.field_16020.field_16011;
            }
        }
        this.parseDecorations(mapState.method_32373());
    }

    @Contract
    private void scanForRooms(@NotNull class_22 mapState) {
        for (int x = 0; x < this.roomMap.length; ++x) {
            int roomMapX = this.roomXToMapX(x);
            for (int y = 0; y < this.roomMap.length; ++y) {
                int roomMapY = this.roomYToMapY(y);
                this.addDoors(x, y, roomMapX, roomMapY, mapState);
            }
        }
        int puzzleCount = 0;
        this.puzzles.forEach(DungeonRoom::markPuzzleDirty);
        for (int x = 0; x < this.roomMap.length; ++x) {
            int roomMapX = this.roomXToMapX(x);
            for (int y = 0; y < this.roomMap.length; ++y) {
                int roomMapY = this.roomYToMapY(y);
                byte color = mapState.field_122[this.roomIndexToMapIndex(x, y)];
                RoomType roomType = this.getType(color);
                if (roomType == RoomType.PUZZLE) {
                    DungeonRoom roomAt = this.getRoomAt(x, y);
                    if (roomAt == null) continue;
                    if (roomAt.getPuzzleId() == -1) {
                        this.puzzles.add(roomAt);
                    }
                    if (!this.instance.isLastColumnPuzzlesOnly() || x != this.roomMap.length - 1) {
                        roomAt.markPuzzleClean();
                        roomAt.setPuzzleId(puzzleCount++);
                    }
                }
                if (roomType != null) {
                    this.updateRoom(x, y, roomType);
                }
                this.checkAndSetState(x, y, mapState);
                if (roomType != RoomType.NORMAL) continue;
                this.updateNormalRoom(x, y, roomMapX, roomMapY, roomType, mapState);
            }
        }
        HashSet<PuzzleType> skipPuzzles = new HashSet<PuzzleType>();
        List<class_3545<PuzzleType, Integer>> knownPuzzles = this.instance.getKnownPuzzles();
        if (knownPuzzles.size() != this.puzzles.size()) {
            return;
        }
        for (DungeonRoom puzzle : this.puzzles) {
            int puzzleId = puzzle.getPuzzleId();
            if (puzzleId < 0 || puzzleId > knownPuzzles.size() - 1) continue;
            PuzzleType puzzleType = (PuzzleType)((Object)knownPuzzles.get(puzzle.getPuzzleId()).method_15442());
            skipPuzzles.add(puzzleType);
            if (puzzle.getPuzzleType() == puzzleType) continue;
            puzzle.setPuzzleType(puzzleType);
        }
        HashSet<DungeonRoom> missingRooms = new HashSet<DungeonRoom>();
        for (DungeonRoom dungeonRoom : this.puzzles.stream().filter(DungeonRoom::isPuzzleDirty).sorted(Comparator.comparingLong(DungeonRoom::getBecamePuzzleAt)).toList()) {
            if (dungeonRoom.getPuzzleType() != null) {
                skipPuzzles.add(dungeonRoom.getPuzzleType());
                continue;
            }
            missingRooms.add(dungeonRoom);
        }
        block6: for (DungeonRoom missingRoom : missingRooms) {
            for (class_3545<PuzzleType, Integer> knownPuzzle : knownPuzzles) {
                if (skipPuzzles.contains(knownPuzzle.method_15442())) continue;
                missingRoom.setPuzzleType((PuzzleType)((Object)knownPuzzle.method_15442()));
                continue block6;
            }
        }
    }

    @Contract
    private void addDoors(int x, int y, int roomMapX, int roomMapY, @NotNull class_22 mapState) {
        DungeonDoor.Type doorType;
        int roomMiddleX = roomMapX + this.halfRoomSize;
        int roomMiddleY = roomMapY + this.halfRoomSize;
        if (mapState.field_122[this.getMapIndex(roomMiddleX - this.halfRoomSize - 2, roomMiddleY - this.halfRoomSize / 2)] == 0 && (doorType = DungeonDoor.Type.ofId(mapState.field_122[this.getMapIndex(roomMiddleX - this.halfRoomSize - 2, roomMiddleY)])) != null) {
            this.addDoor(x, y, true, doorType);
        }
        if (mapState.field_122[this.getMapIndex(roomMiddleX - this.halfRoomSize / 2, roomMiddleY + this.halfRoomSize + 2)] == 0 && (doorType = DungeonDoor.Type.ofId(mapState.field_122[this.getMapIndex(roomMiddleX, roomMiddleY + this.halfRoomSize + 2)])) != null) {
            this.addDoor(x, y, false, doorType);
        }
    }

    @Contract
    private void checkAndSetState(int roomMapX, int roomMapY, @NotNull class_22 mapState) {
        Checkmark checkmark;
        DungeonRoom room = this.getRoomAt(roomMapX, roomMapY);
        if (room == null) {
            return;
        }
        int roomMiddleX = this.roomXToMapX(roomMapX) + this.halfRoomSize;
        int roomMiddleY = this.roomYToMapY(roomMapY) + this.halfRoomSize;
        byte color = mapState.field_122[this.getMapIndex(roomMiddleX, roomMiddleY)];
        if (room.getCheckmark() == Checkmark.DONE) {
            return;
        }
        Checkmark roomCheckmark = room.getCheckmark();
        if (roomCheckmark == (checkmark = Checkmark.getByColor(color))) {
            return;
        }
        if (checkmark == Checkmark.OPENED && roomCheckmark == Checkmark.CLEARED) {
            return;
        }
        room.setCheckmark(checkmark);
    }

    private void updateNormalRoom(int x, int y, int roomMapX, int roomMapY, @NotNull RoomType roomType, @NotNull class_22 mapState) {
        RoomType currentRoomType;
        DungeonRoom currentRoom = this.getRoomAt(x, y);
        DungeonRoom oneUp = this.getRoomIfNormal(x, y - 1, roomMapX, roomMapY - 1, mapState);
        DungeonRoom oneLeft = this.getRoomIfNormal(x - 1, y, roomMapX - 1, roomMapY, mapState);
        DungeonRoom oneUpRight = this.getRoomIfNormal(x + 1, y - 1, roomMapX + this.roomSize, roomMapY - 1, mapState);
        if (currentRoom == null && oneUp == null && oneLeft == null) {
            this.setNewRoom(x, y, roomType);
            return;
        }
        if (currentRoom == null) {
            return;
        }
        if (this.isMapDebug()) {
            mapState.field_122[roomMapX + 1 + (roomMapY + 1) * 128] = (byte)currentRoom.getDebugRoomColor();
        }
        if ((currentRoomType = currentRoom.getRoomType()) == RoomType.UNKNOWN || currentRoom.getCheckmark() == Checkmark.UNKNOWN) {
            currentRoom.setRoomType(roomType);
            currentRoom.setCheckmark(Checkmark.OPENED);
        }
        if (this.isMapDebug()) {
            int i;
            if (currentRoom.equals(oneLeft)) {
                for (i = 0; i <= this.doorRoomSize; ++i) {
                    mapState.field_122[this.getMapIndex((int)(roomMapX - i), (int)(roomMapY + 1))] = (byte)currentRoom.getDebugRoomColor();
                }
            }
            if (currentRoom.equals(oneUp)) {
                for (i = 0; i <= this.doorRoomSize; ++i) {
                    mapState.field_122[this.getMapIndex((int)(roomMapX + 1), (int)(roomMapY + 1 - i))] = (byte)currentRoom.getDebugRoomColor();
                }
            }
        }
        if (oneLeft != null && !currentRoom.equals(oneLeft) && oneLeft.getRoomType() == RoomType.NORMAL) {
            this.setMerged(x - 1, y, currentRoom);
        }
        if (oneUp != null && !currentRoom.equals(oneUp) && oneUp.getRoomType() == RoomType.NORMAL) {
            this.setMerged(x, y - 1, currentRoom);
        }
        if (oneUpRight != null && !currentRoom.equals(oneUpRight) && oneUpRight.getRoomType() == RoomType.NORMAL && currentRoom.equals(oneUp)) {
            this.setMerged(x + 1, y - 1, currentRoom);
        }
    }

    @Contract
    private void setMerged(int x, int y, @NotNull DungeonRoom mergedWith) {
        DungeonRoom roomAt = this.getRoomAt(x, y);
        if (roomAt != null) {
            roomAt.setMergedWith(mergedWith);
        }
        this.setRoom(x, y, mergedWith);
    }

    @Nullable
    private DungeonRoom getRoomIfNormal(int x, int y, int roomMapX, int roomMapY, @NotNull class_22 mapState) {
        if (x < 0 || y < 0 || x >= this.roomMap.length || y >= this.roomMap.length) {
            return null;
        }
        if (this.isMapDebug()) {
            mapState.field_122[this.getMapIndex((int)roomMapX, (int)(roomMapY - 1))] = 31;
        }
        if (RoomType.NORMAL.is(mapState.field_122[this.getMapIndex(roomMapX, roomMapY)])) {
            return this.getRoomAt(x, y);
        }
        return null;
    }

    @Contract(pure=true)
    private int roomIndexToMapIndex(int x, int y) {
        return this.getMapIndex(this.roomXToMapX(x), this.roomYToMapY(y));
    }

    @Contract(pure=true)
    private int roomXToMapX(int x) {
        return this.topLeftPixel.x + x * this.doorRoomSize;
    }

    @Contract(pure=true)
    private int roomYToMapY(int y) {
        return this.topLeftPixel.y + y * this.doorRoomSize;
    }

    @Contract(pure=true)
    private int getMapIndex(int x, int y) {
        return MathUtils.clamp(x + y * 128, 0, 16383);
    }

    @Contract
    private void updateRoom(int x, int y, @NotNull RoomType roomType) {
        DungeonRoom dungeonRoom;
        if (roomType == RoomType.BLOOD && this.instance.getPhase().ordinal() < DungeonPhase.BLOOD.ordinal()) {
            this.instance.setPhase(DungeonPhase.BLOOD);
        }
        if ((dungeonRoom = this.getRoomAt(x, y)) == null) {
            this.setNewRoom(x, y, roomType);
        } else {
            if (dungeonRoom.getRoomType() != roomType || dungeonRoom.getRoomType() == RoomType.UNKNOWN) {
                dungeonRoom.setRoomType(roomType);
                dungeonRoom.setCheckmark(Checkmark.OPENED);
            }
            if (dungeonRoom.getCheckmark() == Checkmark.UNKNOWN && dungeonRoom.getRoomType() != RoomType.UNKNOWN) {
                dungeonRoom.setCheckmark(Checkmark.OPENED);
            }
        }
    }

    private void setNewRoom(int x, int y, @NotNull RoomType roomType) {
        DungeonRoom dungeonRoom = new DungeonRoom(this.instance, roomType);
        dungeonRoom.setCheckmark(roomType == RoomType.UNKNOWN ? Checkmark.UNKNOWN : Checkmark.OPENED);
        this.setRoom(x, y, dungeonRoom);
    }

    @Nullable
    @Contract(pure=true)
    private RoomType getType(byte color) {
        for (RoomType value : RoomType.VALUES) {
            if (!value.is(color)) continue;
            return value;
        }
        return null;
    }

    private void parseDecorations(@NotNull Iterable<class_20> decorations) {
        int index = 0;
        for (class_20 decoration : decorations) {
            DungeonPlayer player = this.instance.getPlayer(index = this.instance.applyOffset(index));
            if (player == null) continue;
            player.setPosition(decoration.comp_1843(), decoration.comp_1844());
            player.setRotation(decoration.comp_1845());
            ++index;
        }
    }

    @Generated
    public Set<DungeonDoor> getDoors() {
        return this.doors;
    }

    @Generated
    public Vector2i getTopLeftPixel() {
        return this.topLeftPixel;
    }

    @Generated
    public void setTopLeftPixel(Vector2i topLeftPixel) {
        this.topLeftPixel = topLeftPixel;
    }

    @Generated
    public int getRoomsInX() {
        return this.roomsInX;
    }

    @Generated
    public void setRoomsInX(int roomsInX) {
        this.roomsInX = roomsInX;
    }

    @Generated
    public int getRoomsInY() {
        return this.roomsInY;
    }

    @Generated
    public void setRoomsInY(int roomsInY) {
        this.roomsInY = roomsInY;
    }

    @Generated
    public Vector2i getBottomRightPixel() {
        return this.bottomRightPixel;
    }

    @Generated
    public void setBottomRightPixel(Vector2i bottomRightPixel) {
        this.bottomRightPixel = bottomRightPixel;
    }
}

