/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.map;

import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.features.dungeons.DungeonFeatures;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.DungeonPlayer;
import codes.cookies.mod.features.dungeons.SpiritLeapOverlay;
import codes.cookies.mod.features.dungeons.map.Checkmark;
import codes.cookies.mod.features.dungeons.map.DungeonDoor;
import codes.cookies.mod.features.dungeons.map.DungeonMap;
import codes.cookies.mod.features.dungeons.map.DungeonMapRenderer;
import codes.cookies.mod.features.dungeons.map.DungeonPhase;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.map.DungeonType;
import codes.cookies.mod.features.dungeons.map.PuzzleType;
import codes.cookies.mod.features.dungeons.map.RoomType;
import codes.cookies.mod.render.hud.elements.HudElement;
import codes.cookies.mod.render.hud.internal.HudEditAction;
import codes.cookies.mod.render.hud.settings.HudElementSettingBuilder;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.joml.Vector2i;

public class DungeonMapHud
extends HudElement {
    private static final DungeonMapHud instance = new DungeonMapHud();
    private DungeonInstance mockInstance;

    private DungeonMapHud() {
        super(class_2960.method_60655((String)"cookies", (String)"dungeon_map"));
    }

    @Override
    public void render(class_332 drawContext, class_327 textRenderer, float ticks) {
        DungeonInstance dungeonInstance = this.getCurrentInstance().filter(instance -> instance.getPhase() != DungeonPhase.BOSS && instance.getPhase() != DungeonPhase.AFTER).orElseGet(this::getMockInstance);
        if (dungeonInstance == null) {
            return;
        }
        if (!dungeonInstance.isDebugInstance()) {
            dungeonInstance.updatePlayersFromWorld();
        }
        DungeonMapRenderer mapRenderer = dungeonInstance.getMapRenderer();
        mapRenderer.render(drawContext);
    }

    private Optional<DungeonInstance> getCurrentInstance() {
        return DungeonFeatures.getInstance().getCurrentInstance();
    }

    @Override
    public boolean shouldRender() {
        if (SpiritLeapOverlay.isOpen) {
            return false;
        }
        if (this.hudEditAction == HudEditAction.SHOW_ALL) {
            return true;
        }
        if (!DungeonCategory.renderMap) {
            return false;
        }
        if (this.hudEditAction == HudEditAction.ALL_ENABLED) {
            return true;
        }
        return DungeonFeatures.getInstance() != null && DungeonFeatures.getInstance().getCurrentInstance().isPresent();
    }

    @Override
    public int getWidth() {
        return 140;
    }

    @Override
    public int getHeight() {
        return this.getWidth();
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43470((String)"Dungeon Map").method_27692(class_124.field_1079);
    }

    @Override
    public void buildSettings(HudElementSettingBuilder builder) {
        this.addBasicSetting(builder);
        this.addConfigSetting(builder);
    }

    public DungeonInstance getMockInstance() {
        if (this.hudEditAction == HudEditAction.NONE) {
            return null;
        }
        if (this.mockInstance != null) {
            return this.mockInstance;
        }
        DungeonInstance instance = new DungeonInstance(DungeonType.CATACOMBS, 7, "cookies_internal_test");
        instance.load();
        instance.setPhase(DungeonPhase.CLEAR);
        DungeonMap dungeonMap = instance.getDungeonMap();
        dungeonMap.setTopLeftPixel(new Vector2i(5, 5));
        dungeonMap.setBottomRightPixel(new Vector2i(121, 121));
        dungeonMap.setRoomsInX(6);
        dungeonMap.setRoomsInY(6);
        DungeonRoom one = new DungeonRoom(instance, RoomType.NORMAL);
        one.setCheckmark(Checkmark.OPENED);
        dungeonMap.setRoom(0, 0, one);
        dungeonMap.setRoom(0, 1, one);
        DungeonRoom start = new DungeonRoom(instance, RoomType.SPAWN);
        dungeonMap.setRoom(1, 0, start);
        start.setCheckmark(Checkmark.DONE);
        DungeonRoom two = new DungeonRoom(instance, RoomType.NORMAL);
        two.setMaxSecrets(7);
        two.setCollectedSecrets(5);
        two.setCheckmark(Checkmark.CLEARED);
        dungeonMap.setRoom(1, 1, two);
        dungeonMap.setRoom(2, 1, two);
        DungeonRoom three = new DungeonRoom(instance, RoomType.TRAP);
        three.setCheckmark(Checkmark.OPENED);
        dungeonMap.setRoom(2, 0, three);
        DungeonRoom four = new DungeonRoom(instance, RoomType.UNKNOWN);
        dungeonMap.setRoom(3, 1, four);
        DungeonRoom five = new DungeonRoom(instance, RoomType.UNKNOWN);
        dungeonMap.setRoom(0, 2, five);
        DungeonRoom six = new DungeonRoom(instance, RoomType.NORMAL);
        six.setCheckmark(Checkmark.CLEARED);
        six.setMaxSecrets(0);
        six.setCollectedSecrets(0);
        dungeonMap.setRoom(1, 2, six);
        DungeonRoom seven = new DungeonRoom(instance, RoomType.NORMAL);
        seven.setCheckmark(Checkmark.CLEARED);
        seven.setMaxSecrets(3);
        seven.setCollectedSecrets(1);
        dungeonMap.setRoom(2, 2, seven);
        DungeonRoom eight = new DungeonRoom(instance, RoomType.NORMAL);
        eight.setCheckmark(Checkmark.DONE);
        eight.setMaxSecrets(4);
        eight.setCollectedSecrets(4);
        dungeonMap.setRoom(3, 2, eight);
        dungeonMap.setRoom(4, 2, eight);
        dungeonMap.setRoom(5, 2, eight);
        DungeonRoom nine = new DungeonRoom(instance, RoomType.NORMAL);
        nine.setCheckmark(Checkmark.CLEARED);
        dungeonMap.setRoom(2, 3, nine);
        dungeonMap.setRoom(2, 4, nine);
        DungeonRoom ten = new DungeonRoom(instance, RoomType.FAIRY);
        ten.setCheckmark(Checkmark.DONE);
        dungeonMap.setRoom(3, 3, ten);
        DungeonRoom eleven = new DungeonRoom(instance, RoomType.UNKNOWN);
        dungeonMap.setRoom(4, 3, eleven);
        DungeonRoom twelve = new DungeonRoom(instance, RoomType.PUZZLE);
        twelve.setCheckmark(Checkmark.DONE);
        twelve.setPuzzleType(PuzzleType.ICE_FILL);
        dungeonMap.setRoom(2, 5, twelve);
        dungeonMap.addDoor(0, 1, false, DungeonDoor.Type.UNKNOWN);
        dungeonMap.addDoor(1, 1, true, DungeonDoor.Type.NORMAL);
        dungeonMap.addDoor(1, 0, false, DungeonDoor.Type.WITHER);
        dungeonMap.addDoor(1, 1, false, DungeonDoor.Type.WITHER);
        dungeonMap.addDoor(2, 2, true, DungeonDoor.Type.WITHER);
        dungeonMap.addDoor(2, 2, false, DungeonDoor.Type.NORMAL);
        dungeonMap.addDoor(3, 2, true, DungeonDoor.Type.WITHER);
        dungeonMap.addDoor(3, 2, false, DungeonDoor.Type.WITHER);
        dungeonMap.addDoor(4, 3, true, DungeonDoor.Type.WITHER);
        dungeonMap.addDoor(2, 4, false, DungeonDoor.Type.PUZZLE);
        dungeonMap.addDoor(2, 0, false, DungeonDoor.Type.TRAP);
        dungeonMap.addDoor(3, 1, true, DungeonDoor.Type.UNKNOWN);
        DungeonPlayer dungeonPlayer = new DungeonPlayer(instance, class_310.method_1551().method_1548().method_1676(), "Mage", "XII");
        dungeonPlayer.updateRotationLocal(-95.0f);
        dungeonPlayer.updatePositionLocal(-90, -90);
        instance.getPlayers()[0] = dungeonPlayer;
        this.mockInstance = instance;
        return this.mockInstance;
    }

    @Generated
    public static DungeonMapHud getInstance() {
        return instance;
    }
}

