/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.map;

import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.features.dungeons.DungeonFeatures;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.DungeonPlayer;
import codes.cookies.mod.features.dungeons.map.Checkmark;
import codes.cookies.mod.features.dungeons.map.DungeonDoor;
import codes.cookies.mod.features.dungeons.map.DungeonMap;
import codes.cookies.mod.features.dungeons.map.DungeonPhase;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.map.RoomType;
import codes.cookies.mod.utils.RenderUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_7833;

public class DungeonMapRenderer {
    public static final int HALLWAY_SIZE = 4;
    private static final int ROOM_SIZE = 20;
    public static final int TOTAL_SIZE = 24;
    private static final int DOOR_SIZE = 6;
    private final DungeonInstance dungeonInstance;
    private final DungeonMap dungeonMap;

    public DungeonMapRenderer(DungeonInstance dungeonInstance) {
        this.dungeonInstance = dungeonInstance;
        this.dungeonMap = dungeonInstance.getDungeonMap();
    }

    private static void drawPlayerArrow(class_332 drawContext, DungeonPlayer player) {
        class_2960 texture = player.getPlayer() instanceof class_746 ? class_2960.method_60656((String)"textures/map/decorations/frame.png") : class_2960.method_60656((String)"textures/map/decorations/player.png");
        drawContext.method_25302(class_1921::method_62277, texture, -4, -4, 0.0f, 0.0f, 8, 8, 8, 8, 8, 8);
    }

    public void render(class_332 drawContext) {
        if (!this.dungeonInstance.isDebugInstance() && this.dungeonInstance != DungeonFeatures.getInstance().getCurrentInstance().orElse(null)) {
            return;
        }
        if (this.dungeonInstance.isDebugInstance()) {
            for (DungeonPlayer player : this.dungeonInstance.getPlayers()) {
                if (player == null) continue;
                player.tick();
            }
        }
        if (!DungeonCategory.renderMap) {
            return;
        }
        if (this.dungeonMap.getTopLeftPixel() == null) {
            return;
        }
        if (this.dungeonInstance.getPhase() == DungeonPhase.BOSS || this.dungeonInstance.getPhase() == DungeonPhase.AFTER) {
            return;
        }
        drawContext.method_25294(0, 0, 140, 140, DungeonCategory.mapBackgroundColor);
        drawContext.method_51448().method_22903();
        int max = Math.max(this.dungeonMap.getRoomsInY(), this.dungeonMap.getRoomsInX());
        drawContext.method_51448().method_22905(6.0f / (float)max, 6.0f / (float)max, 1.0f);
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                DungeonRoom roomAt = this.dungeonMap.getRoomAt(x, y);
                if (roomAt == null) continue;
                this.renderRoom(drawContext, x, y, roomAt);
            }
        }
        for (DungeonDoor door : this.dungeonMap.getDoors()) {
            this.renderDoor(drawContext, door);
        }
        drawContext.method_51448().method_22909();
        for (DungeonPlayer player : this.dungeonInstance.getPlayers()) {
            this.renderPlayer(drawContext, player);
        }
    }

    private void renderRoom(class_332 drawContext, int x, int y, DungeonRoom roomAt) {
        int color = 0xFF000000 | (switch (roomAt.getRoomType()) {
            default -> throw new MatchException(null, null);
            case RoomType.NORMAL -> class_3620.field_16000.field_16011;
            case RoomType.SPAWN -> class_3620.field_16004.field_16011;
            case RoomType.PUZZLE -> class_3620.field_16014.field_16011;
            case RoomType.FAIRY -> class_3620.field_16030.field_16011;
            case RoomType.BLOOD -> class_3620.field_16020.field_16011;
            case RoomType.TRAP -> class_3620.field_15987.field_16011;
            case RoomType.MINIBOSS -> class_3620.field_16010.field_16011;
            case RoomType.UNKNOWN -> class_3620.field_15978.field_16011;
        });
        int locationX = x * 24;
        int locationY = y * 24;
        boolean isConnectedUp = roomAt.isAt(x, y - 1);
        boolean isConnectedLeft = roomAt.isAt(x - 1, y);
        boolean isConnectedLeftTop = roomAt.isAt(x - 1, y - 1);
        boolean isConnectedBottomLeft = roomAt.isAt(x - 1, y + 1);
        if (isConnectedLeft) {
            drawContext.method_25294(locationX - 4, locationY, locationX + 20, locationY + 20, color);
        }
        if (isConnectedUp) {
            drawContext.method_25294(locationX, locationY - 4, locationX + 20, locationY + 20, color);
        }
        if (isConnectedLeft && isConnectedUp && isConnectedLeftTop) {
            drawContext.method_25294(locationX - 4, locationY - 4, locationX, locationY, color);
        }
        if (!isConnectedUp && !isConnectedLeft) {
            drawContext.method_25294(locationX, locationY, locationX + 20, locationY + 20, color);
            if (!isConnectedBottomLeft) {
                if (roomAt.canHaveSecrets() || roomAt.getRoomType() == RoomType.PUZZLE) {
                    this.drawRoomText(drawContext, roomAt, locationX, locationY);
                } else {
                    this.drawRoomCheckmark(drawContext, roomAt.getCheckmark(), locationX, locationY);
                }
            }
        }
    }

    private void renderDoor(class_332 drawContext, DungeonDoor door) {
        int sizeY;
        int sizeX;
        int locationY;
        int locationX;
        int roomX = door.x();
        int roomY = door.y();
        boolean isLeft = door.left();
        DungeonDoor.Type type = door.type();
        int n = 0;
        int color = 0xFF000000 | (switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BLOOD", "WITHER", "NORMAL", "UNKNOWN", "TRAP", "MINIBOSS", "PUZZLE", "FAIRY"}, (DungeonDoor.Type)type, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> class_3620.field_16020.field_16011;
            case 1 -> class_3620.field_16009.field_16011;
            case 2 -> class_3620.field_16000.field_16011;
            case 3 -> class_3620.field_15978.field_16011;
            case 4 -> class_3620.field_15987.field_16011;
            case 5 -> class_3620.field_16010.field_16011;
            case 6 -> class_3620.field_16014.field_16011;
            case 7 -> class_3620.field_16030.field_16011;
            case -1 -> class_3620.field_15984.field_16011;
        });
        if (isLeft) {
            locationX = roomX * 24 - 4;
            locationY = roomY * 24 + 12 - 6 + 1;
            sizeX = 4;
            sizeY = 6;
        } else {
            locationX = roomX * 24 + 12 - 6 + 1;
            locationY = roomY * 24 + 24 - 4;
            sizeX = 6;
            sizeY = 4;
        }
        drawContext.method_25294(locationX, locationY, locationX + sizeX, locationY + sizeY, color);
    }

    private void renderPlayer(class_332 drawContext, DungeonPlayer player) {
        if (player == null || this.dungeonInstance.getDungeonMap().getTopLeftPixel() == null || player.isSkip()) {
            return;
        }
        player.tick();
        if (player.getPlayer() == null) {
            return;
        }
        int max = Math.max(this.dungeonMap.getRoomsInY(), this.dungeonMap.getRoomsInX());
        int x = (int)class_3532.method_37958((float)player.getInterpolatedX(), (float)this.dungeonMap.getTopLeftPixel().x, (float)this.dungeonMap.getBottomRightPixel().x, (float)0.0f, (float)(144.0f * ((float)this.dungeonMap.getRoomsInX() / (float)max))) - 2;
        int y = (int)class_3532.method_37958((float)player.getInterpolatedY(), (float)this.dungeonMap.getTopLeftPixel().y, (float)this.dungeonMap.getBottomRightPixel().y, (float)0.0f, (float)(144.0f * ((float)this.dungeonMap.getRoomsInY() / (float)max))) - 2;
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)x, (float)y, 0.0f);
        if (DungeonCategory.renderOverRoomText) {
            drawContext.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
        }
        drawContext.method_51448().method_22903();
        if (DungeonCategory.showPlayerSkulls && player.getPlayer() != null) {
            if (DungeonCategory.rotatePlayerHeads) {
                drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float)player.getRotation().getValue()));
            } else {
                drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            }
            this.drawPlayerHead(drawContext, player);
            if (!DungeonCategory.rotatePlayerHeads) {
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416(4.0f, 4.0f, 0.0f);
                drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float)player.getRotation().getValue()));
                DungeonMapRenderer.drawPlayerArrow(drawContext, player);
                drawContext.method_51448().method_22909();
            }
        } else {
            drawContext.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float)player.getRotation().getValue() - 180.0f));
            DungeonMapRenderer.drawPlayerArrow(drawContext, player);
        }
        drawContext.method_51448().method_22909();
        if (DungeonCategory.showPlayerNames) {
            RenderUtils.renderTextCenteredScaled(drawContext, (class_2561)class_2561.method_43470((String)player.getName()), 0.5f, 0, 6, player.isUsingMod() ? -8921737 : -38559);
        }
        drawContext.method_51448().method_22909();
    }

    private void drawRoomText(class_332 drawContext, DungeonRoom roomAt, int locationX, int locationY) {
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        if (roomAt.getRoomType() == RoomType.PUZZLE) {
            if (!DungeonCategory.showPuzzleName) {
                drawContext.method_51448().method_22909();
                this.drawRoomCheckmark(drawContext, roomAt.getCheckmark(), locationX, locationY);
                return;
            }
            String name = roomAt.getPuzzleType() == null ? "???" : roomAt.getPuzzleType().getDisplayName();
            String[] lines = name.split(" ");
            class_327 textRenderer = class_310.method_1551().field_1772;
            int n = lines.length;
            Objects.requireNonNull(textRenderer);
            int totalSize = n * 9;
            int offsetY = totalSize / 2;
            float scale = 1.0f;
            if (totalSize > 18) {
                scale = 18.0f / (float)totalSize;
            }
            for (String string : lines) {
                if (textRenderer.method_1727(string) <= 18) continue;
                scale = Math.min(scale, 18.0f / (float)textRenderer.method_1727(string));
            }
            if (scale < 0.6f) {
                scale = 0.5f;
            }
            for (int i = 0; i < lines.length; ++i) {
                drawContext.method_51448().method_22903();
                class_4587 class_45872 = drawContext.method_51448();
                float f = (float)locationX + 10.0f;
                float f2 = (float)locationY + 10.0f - (float)offsetY * scale;
                Objects.requireNonNull(textRenderer);
                class_45872.method_46416(f, f2 + (float)(i * 9) * scale, 0.0f);
                if (scale != 1.0f) {
                    drawContext.method_51448().method_22905(scale, scale, 1.0f);
                }
                drawContext.method_25300(textRenderer, lines[i], 0, 0, roomAt.getRoomTextColor());
                drawContext.method_51448().method_22909();
            }
            drawContext.method_51448().method_22909();
            return;
        }
        String secretString = roomAt.getSecretString();
        if (secretString == null || !DungeonCategory.showSecrets) {
            drawContext.method_51448().method_22909();
            this.drawRoomCheckmark(drawContext, roomAt.getCheckmark(), locationX, locationY);
        } else {
            this.renderSecretString(drawContext, secretString, locationX, locationY, roomAt.getRoomTextColor());
            drawContext.method_51448().method_22909();
        }
    }

    private void drawRoomCheckmark(class_332 drawContext, Checkmark checkmark, int locationX, int locationY) {
        if (checkmark == null || checkmark.getIdentifier() == null) {
            return;
        }
        class_2960 identifier = checkmark.getIdentifier();
        drawContext.method_25290(class_1921::method_62277, identifier, locationX, locationY, 0.0f, 0.0f, 20, 20, 20, 20);
    }

    private void drawPlayerHead(class_332 drawContext, DungeonPlayer player) {
        drawContext.method_51448().method_46416(-4.0f, -4.0f, 0.0f);
        class_7532.method_44445((class_332)drawContext, (class_2960)player.getPlayer().method_52814().comp_1626(), (int)0, (int)0, (int)8, (boolean)true, (boolean)true, (int)-1);
    }

    private void renderSecretString(class_332 drawContext, String secretString, int x, int y, int color) {
        int offset = secretString.length() > 3 ? (secretString.length() - 3) * 2 : 0;
        drawContext.method_25300(class_310.method_1551().field_1772, secretString, x + 10 + offset, y + 10 - 4, color);
    }
}

