/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.map;

import codes.cookies.mod.config.categories.dungeons.DungeonCategory;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.DungeonPosition;
import codes.cookies.mod.features.dungeons.map.Checkmark;
import codes.cookies.mod.features.dungeons.map.PuzzleType;
import codes.cookies.mod.features.dungeons.map.RoomType;
import codes.cookies.mod.render.Renderable;
import codes.cookies.mod.utils.maths.InterpolatedInteger;
import dev.morazzer.cookies.entities.websocket.packets.DungeonUpdateRoomSecrets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.joml.Vector2i;

public class DungeonRoom {
    private static int counter = 0;
    private final int debugRoomColor;
    private final DungeonInstance instance;
    private boolean isActive;
    private RoomType roomType;
    private PuzzleType puzzleType;
    private Checkmark checkmark;
    private DungeonRoom mergedWith;
    private Collection<DungeonPosition> position = new ArrayList<DungeonPosition>();
    private int x;
    private int y;
    private int width;
    private int height;
    private int rotation;
    private String shape;
    private List<Renderable> waypoints = null;
    private int maxSecrets = -1;
    private int collectedSecrets = -1;
    private int puzzleId = -1;
    boolean isPuzzleDirty = false;
    private long becamePuzzleAt = -1L;

    public DungeonRoom(DungeonInstance instance, RoomType roomType) {
        this.debugRoomColor = counter++;
        this.instance = instance;
        this.roomType = roomType;
        this.checkmark = Checkmark.UNKNOWN;
    }

    public String getSecretString() {
        if (this.maxSecrets == 0) {
            return null;
        }
        if (this.maxSecrets == -1 && this.collectedSecrets == -1) {
            return "?/?";
        }
        if (this.maxSecrets == -1) {
            return this.collectedSecrets + "/?";
        }
        if (this.collectedSecrets == -1) {
            return "?/" + this.maxSecrets;
        }
        return this.collectedSecrets + "/" + this.maxSecrets;
    }

    public boolean isAt(int x, int y) {
        if (x < 0 && y < 0) {
            return false;
        }
        return this.equals(this.instance.getDungeonMap().getRoomAt(x, y));
    }

    public String findShape() {
        if (this.position.size() == 1) {
            return "1x1";
        }
        if (this.position.size() == 2) {
            return "1x2";
        }
        List<Integer> xList = this.position.stream().map(DungeonPosition.target(DungeonPosition::getRoomMapX)).distinct().toList();
        List<Integer> yList = this.position.stream().map(DungeonPosition.target(DungeonPosition::getRoomMapY)).distinct().toList();
        int xSize = xList.size();
        int ySize = yList.size();
        if (xSize == 2 && ySize == 2 && this.position.size() == 4) {
            return "2x2";
        }
        if (Math.min(xSize, ySize) == 1) {
            int max = Math.max(xSize, ySize);
            if (max == 3) {
                return "1x3";
            }
            if (max == 4) {
                return "1x4";
            }
        }
        return "L";
    }

    public boolean canHaveSecrets() {
        return switch (this.roomType) {
            case RoomType.NORMAL, RoomType.TRAP -> true;
            default -> false;
        };
    }

    public void updateSecrets(String s, int x, int y) {
        int max;
        int collected;
        if (!this.canHaveSecrets()) {
            return;
        }
        if (s == null) {
            collected = Math.max(0, this.collectedSecrets);
            max = Math.max(0, this.maxSecrets);
        } else {
            String[] split = s.split("/");
            collected = Integer.parseInt(split[0]);
            max = Integer.parseInt(split[1]);
        }
        int newMax = Math.max(this.maxSecrets, max);
        if (this.maxSecrets != newMax || this.collectedSecrets != collected) {
            this.updateSecrets(x, y, collected, newMax);
        }
        this.maxSecrets = max;
        this.collectedSecrets = collected;
    }

    public void markPuzzleDirty() {
        this.isPuzzleDirty = true;
    }

    public void markPuzzleClean() {
        this.isPuzzleDirty = false;
    }

    public boolean isPuzzleDirty() {
        return this.isPuzzleDirty;
    }

    private void updateSecrets(int x, int y, int collected, int newMax) {
        this.instance.send(new DungeonUpdateRoomSecrets(x, y, collected, newMax));
    }

    private void findMin() {
        for (DungeonPosition dungeonPosition : this.position) {
            if (this.x > DungeonPosition.target(dungeonPosition::getWorldX)) {
                this.x = DungeonPosition.target(dungeonPosition::getWorldX);
            }
            if (this.y <= DungeonPosition.target(dungeonPosition::getWorldY)) continue;
            this.y = DungeonPosition.target(dungeonPosition::getWorldY);
        }
    }

    private int getMax(BiFunction<DungeonPosition, Function<InterpolatedInteger, Integer>, Integer> mapper) {
        return this.position.stream().max(Comparator.comparingInt(DungeonPosition.toInt(DungeonPosition.target(mapper)))).map(DungeonPosition.target(mapper)).orElse(0);
    }

    private int getMin(BiFunction<DungeonPosition, Function<InterpolatedInteger, Integer>, Integer> mapper) {
        return this.position.stream().min(Comparator.comparingInt(DungeonPosition.toInt(DungeonPosition.target(mapper)))).map(DungeonPosition.target(mapper)).orElse(0);
    }

    public void findSize() {
        int maxX = this.getMax(DungeonPosition::getWorldX);
        int minX = this.getMin(DungeonPosition::getWorldX);
        int maxY = this.getMax(DungeonPosition::getWorldY);
        int minY = this.getMin(DungeonPosition::getWorldY);
        this.width = 30 + 32 * (maxX - minX);
        this.height = 30 + 32 * (maxY - minY);
    }

    public void addPosition(DungeonPosition dungeonPosition) {
        if (this.position.contains(dungeonPosition)) {
            return;
        }
        this.position.add(dungeonPosition);
        this.shape = this.findShape();
        this.findMin();
        this.findSize();
    }

    public void setRoomType(RoomType roomType) {
        if (this.roomType == roomType) {
            return;
        }
        if (roomType == RoomType.PUZZLE && this.becamePuzzleAt == -1L) {
            this.becamePuzzleAt = System.currentTimeMillis();
        }
        if ((this.roomType == null || this.roomType == RoomType.UNKNOWN) && roomType != RoomType.UNKNOWN) {
            this.setCheckmark(Checkmark.OPENED);
        }
        this.roomType = roomType;
        if (roomType == RoomType.UNKNOWN) {
            this.setCheckmark(Checkmark.UNKNOWN);
        }
    }

    public void setCheckmark(Checkmark checkmark) {
        if (checkmark == Checkmark.UNKNOWN && this.roomType != RoomType.UNKNOWN) {
            return;
        }
        if (checkmark == Checkmark.FAILED && this.roomType != RoomType.PUZZLE) {
            return;
        }
        this.checkmark = checkmark;
    }

    public int getRoomTextColor() {
        if (!DungeonCategory.showRoomStatusAsTextColor) {
            return -1;
        }
        if (this.roomType == RoomType.PUZZLE) {
            return switch (this.checkmark) {
                case Checkmark.DONE -> -8921737;
                case Checkmark.FAILED -> -38559;
                default -> this.getPuzzleType() == null ? -5592406 : -1;
            };
        }
        return switch (this.checkmark) {
            case Checkmark.OPENED -> {
                if (DungeonCategory.showTrapAsCleared && this.roomType == RoomType.TRAP) {
                    yield -1;
                }
                yield -38559;
            }
            case Checkmark.DONE -> -8921737;
            case Checkmark.CLEARED -> {
                if (this.canHaveSecrets() && this.maxSecrets != -1 && this.collectedSecrets >= this.maxSecrets) {
                    yield -8921737;
                }
                yield -1;
            }
            default -> -1;
        };
    }

    public void setPuzzleType(PuzzleType puzzleType) {
        this.puzzleType = puzzleType;
        if (this.instance.getCurrentRoom() == this) {
            this.instance.loadPuzzle(this);
        }
    }

    public Optional<Vector2i> getTopLeft() {
        if (this.position.size() > 1) {
            return Optional.empty();
        }
        return this.position.stream().findFirst().map(DungeonRoom::toRoomPosition);
    }

    public Optional<Vector2i> getCenter() {
        return this.getTopLeft().map(vector2i -> vector2i.add(15, 15));
    }

    private static Vector2i toRoomPosition(DungeonPosition dungeonPosition) {
        return new Vector2i(DungeonPosition.target(dungeonPosition::getWorldX), DungeonPosition.target(dungeonPosition::getWorldY));
    }

    @Generated
    public int getDebugRoomColor() {
        return this.debugRoomColor;
    }

    @Generated
    public DungeonInstance getInstance() {
        return this.instance;
    }

    @Generated
    public boolean isActive() {
        return this.isActive;
    }

    @Generated
    public RoomType getRoomType() {
        return this.roomType;
    }

    @Generated
    public PuzzleType getPuzzleType() {
        return this.puzzleType;
    }

    @Generated
    public Checkmark getCheckmark() {
        return this.checkmark;
    }

    @Generated
    public DungeonRoom getMergedWith() {
        return this.mergedWith;
    }

    @Generated
    public Collection<DungeonPosition> getPosition() {
        return this.position;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public int getRotation() {
        return this.rotation;
    }

    @Generated
    public String getShape() {
        return this.shape;
    }

    @Generated
    public List<Renderable> getWaypoints() {
        return this.waypoints;
    }

    @Generated
    public int getMaxSecrets() {
        return this.maxSecrets;
    }

    @Generated
    public int getCollectedSecrets() {
        return this.collectedSecrets;
    }

    @Generated
    public int getPuzzleId() {
        return this.puzzleId;
    }

    @Generated
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Generated
    public void setMergedWith(DungeonRoom mergedWith) {
        this.mergedWith = mergedWith;
    }

    @Generated
    public void setPosition(Collection<DungeonPosition> position) {
        this.position = position;
    }

    @Generated
    public void setX(int x) {
        this.x = x;
    }

    @Generated
    public void setY(int y) {
        this.y = y;
    }

    @Generated
    public void setWidth(int width) {
        this.width = width;
    }

    @Generated
    public void setHeight(int height) {
        this.height = height;
    }

    @Generated
    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setShape(String shape) {
        this.shape = shape;
    }

    @Generated
    public void setWaypoints(List<Renderable> waypoints) {
        this.waypoints = waypoints;
    }

    @Generated
    public void setMaxSecrets(int maxSecrets) {
        this.maxSecrets = maxSecrets;
    }

    @Generated
    public void setCollectedSecrets(int collectedSecrets) {
        this.collectedSecrets = collectedSecrets;
    }

    @Generated
    public void setPuzzleId(int puzzleId) {
        this.puzzleId = puzzleId;
    }

    @Generated
    public void setPuzzleDirty(boolean isPuzzleDirty) {
        this.isPuzzleDirty = isPuzzleDirty;
    }

    @Generated
    public void setBecamePuzzleAt(long becamePuzzleAt) {
        this.becamePuzzleAt = becamePuzzleAt;
    }

    @Generated
    public long getBecamePuzzleAt() {
        return this.becamePuzzleAt;
    }
}

