/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.map;

import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.solver.puzzle.CreeperBeamPuzzleSolver;
import codes.cookies.mod.features.dungeons.solver.puzzle.HigherLowerPuzzleSolver;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.features.dungeons.solver.puzzle.QuizPuzzleSolver;
import codes.cookies.mod.features.dungeons.solver.puzzle.ThreeWeirdosPuzzleSolver;
import codes.cookies.mod.features.dungeons.solver.puzzle.WaterBoardPuzzleSolver;
import codes.cookies.mod.utils.dev.FunctionUtils;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public enum PuzzleType {
    QUIZ("Quiz", FunctionUtils.wrapOptionalSupplier(QuizPuzzleSolver::new)),
    TIC_TAC_TOE("Tic Tac Toe"),
    WEIRDOS("Three Weirdos", FunctionUtils.wrapOptionalSupplier(ThreeWeirdosPuzzleSolver::new)),
    ICE_PATH("Ice Path"),
    ICE_FILL("Ice Fill"),
    HIGHER_LOWER("Higher Or Lower", "Higher Lower", FunctionUtils.wrapOptionalSupplier(HigherLowerPuzzleSolver::new)),
    CREEPER("Creeper Beams", "Creeper", FunctionUtils.wrapOptionalSupplier(CreeperBeamPuzzleSolver::new)),
    WATERBOARD("Water Board", FunctionUtils.wrapOptionalF(WaterBoardPuzzleSolver::new)),
    BOULDER("Boulder"),
    MAZE("Teleport Maze", "Maze"),
    UNKNOWN("Unknown");

    private final String tabName;
    private final String displayName;
    private final Function<DungeonInstance, Optional<PuzzleSolver>> solverFunction;

    private PuzzleType(String name) {
        this(name, name);
    }

    private PuzzleType(String tabName, String displayName) {
        this(tabName, displayName, Optional::empty);
    }

    private PuzzleType(String tabName, Supplier<Optional<PuzzleSolver>> supplier) {
        this(tabName, tabName, supplier);
    }

    private PuzzleType(String tabName, String displayName, Supplier<Optional<PuzzleSolver>> supplier) {
        this(tabName, displayName, (DungeonInstance instance) -> (Optional)supplier.get());
    }

    private PuzzleType(String tabName, Function<DungeonInstance, Optional<PuzzleSolver>> solverFunction) {
        this(tabName, tabName, solverFunction);
    }

    private PuzzleType(String tabName, String displayName, Function<DungeonInstance, Optional<PuzzleSolver>> solverFunction) {
        this.tabName = tabName;
        this.displayName = displayName;
        this.solverFunction = solverFunction;
    }

    public static PuzzleType ofName(String puzzleName) {
        for (PuzzleType value : PuzzleType.values()) {
            if (!value.tabName.equals(puzzleName)) continue;
            return value;
        }
        return UNKNOWN;
    }

    @Generated
    public String getTabName() {
        return this.tabName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public Function<DungeonInstance, Optional<PuzzleSolver>> getSolverFunction() {
        return this.solverFunction;
    }
}

