/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.puzzle;

import codes.cookies.mod.config.categories.dungeons.PuzzleCategory;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.render.types.Line;
import codes.cookies.mod.utils.maths.MathUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_638;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Vector2i;

public class CreeperBeamPuzzleSolver
extends PuzzleSolver {
    private static final class_2248[] BLOCKS = new class_2248[]{class_2246.field_10135, class_2246.field_10174};
    private static final int[] COLORS = new int[]{-8921737, -4271362, -131690, -9521665};

    public CreeperBeamPuzzleSolver() {
        super(PuzzleCategory.creeperBeams);
    }

    @Override
    protected void onRoomEnter(DungeonRoom dungeonRoom) {
        this.clearRenderables();
        if (this.isDisabled()) {
            return;
        }
        super.onRoomEnter(dungeonRoom);
        class_2338 first = dungeonRoom.getTopLeft().map(block -> new class_2338(block.x, 70, block.y)).orElse(null);
        class_2338 second = dungeonRoom.getCenter().map(block -> new class_2338(block.x + 15, 84, block.y + 15)).orElse(null);
        if (first == null || second == null) {
            return;
        }
        Vector2i roomCenter = dungeonRoom.getCenter().get();
        class_2338 center = new class_2338(roomCenter.x, 75, roomCenter.y);
        class_638 clientWorld = this.getWorld().orElse(null);
        if (clientWorld == null) {
            return;
        }
        List<class_2338> list = class_2338.method_20437((class_2338)first, (class_2338)second).filter(blockPos -> ArrayUtils.contains((Object[])BLOCKS, (Object)clientWorld.method_8320(blockPos).method_26204())).map(class_2338::method_25503).map(class_2338.class::cast).toList();
        class_243 creeperCenter = center.method_10084().method_46558();
        HashSet<Connection> map = new HashSet<Connection>();
        for (int firstIndex = 0; firstIndex < list.size(); ++firstIndex) {
            class_2338 firstPos = list.get(firstIndex);
            for (int secondIndex = firstIndex; secondIndex < list.size(); ++secondIndex) {
                class_2338 secondPos = list.get(secondIndex);
                map.add(new Connection(creeperCenter, firstPos, secondPos));
            }
        }
        HashSet usedBlocks = new HashSet();
        AtomicInteger currentColor = new AtomicInteger();
        map.stream().sorted(Comparator.comparingDouble(Connection::distance)).filter(connection -> {
            if (usedBlocks.contains(connection.pos1) || usedBlocks.contains(connection.pos2)) {
                return false;
            }
            usedBlocks.add(connection.pos1);
            usedBlocks.add(connection.pos2);
            return true;
        }).limit(4L).forEach(connection -> this.addRenderable(new Line(connection.pos1.method_46558(), connection.pos2.method_46558(), COLORS[Math.min(currentColor.getAndIncrement(), COLORS.length - 1)])));
    }

    record Connection(double distance, class_2338 pos1, class_2338 pos2) {
        public Connection(class_243 point, class_2338 pos1, class_2338 pos2) {
            this(MathUtils.distance(point, pos1.method_46558(), pos2.method_46558()), pos1, pos2);
        }
    }
}

