/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.puzzle;

import codes.cookies.mod.config.categories.dungeons.PuzzleCategory;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.render.types.BlockHighlight;
import codes.cookies.mod.render.types.Line;
import codes.cookies.mod.utils.accessors.GlowingEntityAccessor;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1545;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import net.minecraft.class_638;
import org.joml.Vector2i;

public class HigherLowerPuzzleSolver
extends PuzzleSolver {
    private static final Pattern PATTERN = Pattern.compile("\\[Lv15] Blaze [\\d,]+/([\\d,]+)\u2764");
    private class_2350 direction = null;
    private int lastBlazeCount = -1;
    private class_1297 first;
    private class_1297 second;
    private long enteredBlaze = -1L;
    private long startedBlaze = 1L;

    public HigherLowerPuzzleSolver() {
        super(PuzzleCategory.higherLower);
    }

    @Override
    protected void onRoomEnter(DungeonRoom dungeonRoom) {
        if (this.isDisabled()) {
            return;
        }
        if (this.direction == null) {
            this.findDirection(dungeonRoom);
        }
        if (this.enteredBlaze == -1L) {
            this.enteredBlaze = System.currentTimeMillis();
        }
        super.onRoomEnter(dungeonRoom);
    }

    private void findDirection(DungeonRoom dungeonRoom) {
        Optional<Vector2i> center = dungeonRoom.getCenter();
        if (center.isEmpty()) {
            return;
        }
        if (HigherLowerPuzzleSolver.isDebugEnabled()) {
            this.addDebugRenderable(new BlockHighlight(new class_2338(center.get().x + 1, 118, center.get().y), -1466946));
        }
        class_2338 platformLocation = center.map(vector2i -> new class_2338(vector2i.x + 1, 118, vector2i.y)).get();
        this.direction = this.getWorld().map(world -> world.method_8320(platformLocation).method_26215()).map(isAir -> isAir != false ? class_2350.field_11033 : class_2350.field_11036).orElse(null);
    }

    @Override
    public void tick() {
        if (this.isDisabled()) {
            return;
        }
        HashSet blazes = new HashSet();
        ((Iterable)this.getWorld().map(class_638::method_18112).orElse(Collections.emptyList())).forEach(entity -> {
            if (!(entity instanceof class_1531)) {
                return;
            }
            class_1531 armorStandEntity = (class_1531)entity;
            Matcher matcher = PATTERN.matcher(CookiesUtils.stripColor(armorStandEntity.method_5477().getString()));
            if (!matcher.find()) {
                return;
            }
            String hp = matcher.group(1).replaceAll("\\D", "");
            blazes.add(new class_3545(entity, (Object)Integer.parseInt(hp)));
        });
        Comparator<class_3545> comparator = Comparator.comparingInt(class_3545::method_15441);
        if (this.direction == class_2350.field_11033) {
            comparator = comparator.reversed();
        }
        if (this.lastBlazeCount == blazes.size()) {
            return;
        }
        if (blazes.size() == 9) {
            this.startedBlaze = System.currentTimeMillis();
        }
        if (blazes.isEmpty()) {
            this.finishBlaze();
        }
        this.lastBlazeCount = blazes.size();
        this.clearRenderables();
        this.first = null;
        this.second = null;
        AtomicInteger count = new AtomicInteger(0);
        blazes.stream().sorted(comparator).forEach(pair -> {
            class_1297 left = (class_1297)pair.method_15442();
            List otherEntities = left.method_37908().method_8335(left, new class_238(left.method_24515()).method_1014(1.0));
            for (class_1297 otherEntity : otherEntities) {
                if (!(otherEntity instanceof class_1545)) continue;
                class_1545 blazeEntity = (class_1545)otherEntity;
                this.highlightBlaze(blazeEntity, count.getAndIncrement());
            }
        });
        if (this.first != null && this.second != null) {
            class_243 actualSecond;
            class_243 actualFirst;
            class_243 firstPos = this.first.method_19538();
            class_243 secondPos = this.second.method_19538();
            if (firstPos.field_1351 > secondPos.field_1351) {
                actualFirst = firstPos;
                actualSecond = secondPos.method_1031(0.0, 2.0, 0.0);
            } else {
                actualFirst = firstPos.method_1031(0.0, 2.0, 0.0);
                actualSecond = secondPos;
            }
            this.addRenderable(new Line(actualFirst, actualSecond, -8921737, -1));
        }
    }

    private void finishBlaze() {
        long finishedAt = System.currentTimeMillis();
        long timeFromEnter = finishedAt - this.enteredBlaze;
        long timeFromStart = finishedAt - this.startedBlaze;
        CookiesUtils.sendSuccessMessage("Finished blaze in " + CookiesUtils.formattedMs(timeFromStart) + " (from start)");
        CookiesUtils.sendSuccessMessage("Finished blaze in " + CookiesUtils.formattedMs(timeFromEnter) + " (from enter)");
    }

    private void highlightBlaze(class_1545 blazeEntity, int count) {
        if (count > 1) {
            return;
        }
        if (count == 0) {
            this.first = blazeEntity;
            GlowingEntityAccessor.setGlowing((class_1297)blazeEntity, true);
            GlowingEntityAccessor.setGlowColor((class_1297)blazeEntity, -8921737);
        } else {
            GlowingEntityAccessor.setGlowing((class_1297)blazeEntity, true);
            this.second = blazeEntity;
        }
    }

    @Override
    protected void onRoomExit() {
        if (this.isDisabled()) {
            return;
        }
        super.onRoomExit();
        if (this.first != null) {
            GlowingEntityAccessor.setGlowing(this.first, false);
        }
        if (this.second != null) {
            GlowingEntityAccessor.setGlowing(this.second, false);
        }
        if (this.lastBlazeCount == 10 || this.lastBlazeCount == -1) {
            this.enteredBlaze = -1L;
            this.startedBlaze = -1L;
        }
    }

    @Override
    protected void resetPuzzle() {
        this.direction = null;
        this.startedBlaze = -1L;
        this.enteredBlaze = -1L;
        this.first = null;
        this.second = null;
        this.clearRenderables();
        super.resetPuzzle();
    }

    @Override
    protected void onEnable() {
        if (this.isLoaded) {
            if (this.first != null) {
                GlowingEntityAccessor.setGlowing(this.first, true);
            }
            if (this.second != null) {
                GlowingEntityAccessor.setGlowing(this.second, true);
            }
        }
    }

    @Override
    protected void onDisalbe() {
        if (this.first != null) {
            GlowingEntityAccessor.setGlowing(this.first, false);
        }
        if (this.second != null) {
            GlowingEntityAccessor.setGlowing(this.second, false);
        }
    }
}

