/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.puzzle;

import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.render.Renderable;
import codes.cookies.mod.render.WorldRender;
import codes.cookies.mod.utils.dev.DevUtils;
import com.teamresourceful.resourcefulconfig.api.types.entries.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class PuzzleSolver {
    protected static final class_2960 DEBUG = DevUtils.createIdentifier("dungeon/puzzles/debug");
    private final Observable<Boolean> option;
    private List<Renderable> debugRenderables = null;
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    boolean isLoaded = false;

    public PuzzleSolver(Observable<Boolean> option) {
        this.option = option;
        this.option.addListener(this::toggle);
        if (PuzzleSolver.isDebugEnabled()) {
            this.debugRenderables = new ArrayList<Renderable>();
        }
    }

    private void toggle(Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            if (this.isLoaded) {
                this.renderables.forEach(WorldRender::addRenderable);
            }
            this.onEnable();
        } else {
            this.onDisalbe();
            this.removeRenderables();
        }
    }

    protected void onDisalbe() {
    }

    protected void onEnable() {
    }

    public boolean isDisabled() {
        return (Boolean)this.option.get() == false;
    }

    public void beforeRender(float tickDelta) {
    }

    public void onInteract(class_1937 world, class_3965 blockHitResult, class_1268 hand) {
    }

    public void onUnloadedChatMessage(String string) {
    }

    protected void addRenderable(Renderable renderable) {
        this.renderables.add(renderable);
        if (this.isLoaded) {
            WorldRender.addRenderable(renderable);
        }
    }

    protected void addDebugRenderable(Renderable renderable) {
        if (this.debugRenderables == null) {
            if (!PuzzleSolver.isDebugEnabled()) {
                return;
            }
            this.debugRenderables = new ArrayList<Renderable>();
        }
        this.debugRenderables.add(renderable);
        WorldRender.addRenderable(renderable);
    }

    protected static boolean isDebugEnabled() {
        return DevUtils.isEnabled(DEBUG);
    }

    protected void clearDebugRenderables() {
        if (this.debugRenderables == null) {
            return;
        }
        this.debugRenderables.forEach(WorldRender::removeRenderable);
        this.debugRenderables.clear();
    }

    protected void clearRenderables() {
        this.removeRenderables();
        this.renderables.clear();
    }

    protected void removeRenderables() {
        this.renderables.forEach(WorldRender::removeRenderable);
    }

    @MustBeInvokedByOverriders
    protected void onRoomEnter(DungeonRoom dungeonRoom) {
        this.isLoaded = true;
        if (this.isDisabled()) {
            return;
        }
        this.renderables.forEach(WorldRender::addRenderable);
    }

    @MustBeInvokedByOverriders
    protected void onRoomExit() {
        this.isLoaded = false;
        this.removeRenderables();
        this.clearDebugRenderables();
    }

    protected void resetPuzzle() {
        this.clearRenderables();
        this.clearDebugRenderables();
    }

    public void onChatMessage(String message) {
    }

    public void tick() {
    }

    protected Optional<class_638> getWorld() {
        return Optional.ofNullable(class_310.method_1551().field_1687);
    }
}

