/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.puzzle;

import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.map.PuzzleType;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.utils.dev.FunctionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PuzzleSolverInstance {
    static final Logger LOGGER = LoggerFactory.getLogger(PuzzleSolverInstance.class);
    private final Map<PuzzleType, PuzzleSolver> solverMap = new HashMap<PuzzleType, PuzzleSolver>();
    private PuzzleSolver current;

    public PuzzleSolverInstance(DungeonInstance dungeonInstance) {
        for (PuzzleType puzzleType : PuzzleType.values()) {
            Optional<PuzzleSolver> apply = puzzleType.getSolverFunction().apply(dungeonInstance);
            if (apply.isEmpty()) {
                LOGGER.warn("No logger present for {}", (Object)puzzleType);
                continue;
            }
            PuzzleSolver puzzleSolver = apply.get();
            if (this.solverMap.containsKey((Object)puzzleType)) {
                LOGGER.warn("Duplicate solver for puzzle type {}", (Object)puzzleType);
            }
            this.solverMap.put(puzzleType, puzzleSolver);
        }
    }

    public void onEnterPuzzleRoom(DungeonRoom dungeonRoom) {
        this.getSolver(dungeonRoom).map(FunctionUtils.function(this::enter)).orElseGet(FunctionUtils::noOp).accept(dungeonRoom);
    }

    public Optional<PuzzleSolver> getSolver(DungeonRoom dungeonRoom) {
        return Optional.ofNullable(dungeonRoom).map(DungeonRoom::getPuzzleType).flatMap(this::getSolver);
    }

    public Collection<PuzzleSolver> getAll() {
        return this.solverMap.values();
    }

    private void enter(PuzzleSolver puzzleSolver, DungeonRoom dungeonRoom) {
        this.current = puzzleSolver;
        puzzleSolver.onRoomEnter(dungeonRoom);
    }

    public Optional<PuzzleSolver> getSolver(PuzzleType puzzleType) {
        Optional<PuzzleSolver> puzzleSolver = Optional.ofNullable(this.solverMap.get((Object)puzzleType));
        if (puzzleSolver.isEmpty()) {
            LOGGER.warn("No solver found for type {}", (Object)puzzleType);
        }
        return puzzleSolver;
    }

    public void onExitRoom(DungeonRoom dungeonRoom) {
        this.getSolver(dungeonRoom).ifPresent(this::exit);
    }

    private void exit(PuzzleSolver puzzleSolver) {
        this.current = null;
        puzzleSolver.onRoomExit();
    }

    public void unloadCurrent() {
        this.getCurrent().ifPresent(this::exit);
    }

    public Optional<PuzzleSolver> getCurrent() {
        return Optional.ofNullable(this.current);
    }
}

