/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.puzzle;

import codes.cookies.mod.config.categories.dungeons.PuzzleCategory;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.render.types.BlockHighlight;
import codes.cookies.mod.repository.constants.dungeons.DungeonConstants;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_1531;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_3341;
import net.minecraft.class_638;
import org.joml.Vector2i;

public class QuizPuzzleSolver
extends PuzzleSolver {
    boolean hasStarted;
    long startedAt = -1L;
    boolean isDone = false;
    private Solution solution;
    private final List<String> solutionStrings = new ArrayList<String>();
    private class_2338 center;
    private class_2350 puzzleDirection;

    public QuizPuzzleSolver() {
        super(PuzzleCategory.quiz);
    }

    @Override
    public void onUnloadedChatMessage(String message) {
        if (this.isDisabled()) {
            return;
        }
        if (message.startsWith("[STATUE] Oruo the Omniscient")) {
            this.solutionStrings.clear();
            this.solution = null;
            this.isDone = false;
            this.clearRenderables();
            if (!this.hasStarted) {
                this.hasStarted = true;
                this.startedAt = System.currentTimeMillis();
            }
        }
        if (!this.hasStarted) {
            return;
        }
        if (DungeonConstants.quizAnswers.containsKey(message)) {
            this.solutionStrings.addAll(DungeonConstants.quizAnswers.getOrDefault(message, Collections.emptyList()));
        }
        if (message.equalsIgnoreCase("What SkyBlock year is it?")) {
            this.solutionStrings.add("Year " + Math.floor(((double)System.currentTimeMillis() / 1000.0 - 1.560276E9) / 446400.0 + 1.0));
            return;
        }
        if (!message.matches("[\u24d0\u24d1\u24d2] .+") || this.solution != null) {
            return;
        }
        String answer = message.substring(1).trim();
        boolean correctAnswer = this.solutionStrings.stream().anyMatch(answer::equalsIgnoreCase);
        if (correctAnswer) {
            this.solution = Solution.getForMessage(message);
            this.placeRenderables();
            CookiesUtils.sendMessage("Correct solution: " + String.valueOf((Object)this.solution));
        }
    }

    @Override
    protected void onRoomEnter(DungeonRoom dungeonRoom) {
        if (this.isDisabled()) {
            return;
        }
        super.onRoomEnter(dungeonRoom);
        Optional<Vector2i> center = dungeonRoom.getCenter();
        if (QuizPuzzleSolver.isDebugEnabled()) {
            center.ifPresent(vector2i -> this.addDebugRenderable(new BlockHighlight(new class_2338(vector2i.x, 56, vector2i.y), -1466946)));
        }
        if (center.isEmpty()) {
            return;
        }
        Vector2i vector2i2 = center.get();
        this.center = new class_2338(vector2i2.x, 56, vector2i2.y);
        List<class_2350> directions = List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
        Optional<class_638> optionalWorld = this.getWorld();
        if (optionalWorld.isEmpty()) {
            return;
        }
        class_638 world = optionalWorld.get();
        for (class_2350 direction : directions) {
            class_2338 add = this.center.method_10081(direction.method_62675().method_35862(2));
            if (world.method_8320(add).method_26204() != class_2246.field_10626) continue;
            this.puzzleDirection = direction;
            if (!QuizPuzzleSolver.isDebugEnabled()) break;
            this.addDebugRenderable(new BlockHighlight(add, -8921737));
            break;
        }
        if (this.puzzleDirection == null) {
            return;
        }
        if (!this.isDone && this.solution != null) {
            this.placeRenderables();
        }
    }

    private void placeRenderables() {
        if (this.center == null || this.puzzleDirection == null || this.solution == null) {
            return;
        }
        Optional<class_638> optionalWorld = this.getWorld();
        if (optionalWorld.isEmpty()) {
            return;
        }
        class_638 world = optionalWorld.get();
        for (Solution value : Solution.values()) {
            class_2338 buttonCenter = value.getButtonCenter(this.center, this.puzzleDirection);
            this.addButtonHighlight(buttonCenter, value == this.solution ? -8921737 : -38559);
            for (class_1531 entitiesByClass : world.method_8390(class_1531.class, class_238.method_19316((class_3341)new class_3341(buttonCenter)).method_1014(1.0), (Predicate)Predicates.alwaysTrue())) {
                if (entitiesByClass.method_5797() == null || Solution.getForMessage(CookiesUtils.stripColor(entitiesByClass.method_5797().getString())) == value) continue;
                entitiesByClass.method_5880(false);
            }
        }
        this.isDone = true;
    }

    private void addButtonHighlight(class_2338 buttonCenter, int color) {
        this.addRenderable(new BlockHighlight(buttonCenter, color));
        this.addRenderable(new BlockHighlight(buttonCenter.method_10069(1, 0, 0), color));
        this.addRenderable(new BlockHighlight(buttonCenter.method_10069(-1, 0, 0), color));
        this.addRenderable(new BlockHighlight(buttonCenter.method_10069(0, 0, 1), color));
        this.addRenderable(new BlockHighlight(buttonCenter.method_10069(0, 0, -1), color));
    }

    @Override
    protected void resetPuzzle() {
        super.resetPuzzle();
        this.startedAt = -1L;
        this.hasStarted = false;
        this.solution = null;
    }

    private static enum Solution {
        A("\u24d0"),
        B("\u24d1"),
        C("\u24d2");

        final String display;

        public class_2338 getButtonCenter(class_2338 center, class_2350 puzzleDirection) {
            if ((this.ordinal() + 1) % 2 == 0) {
                return center.method_10086(14).method_10079(puzzleDirection.method_10153(), 6);
            }
            return center.method_10086(14).method_10079(puzzleDirection.method_10153(), 9).method_10079(this == A ? puzzleDirection.method_10160() : puzzleDirection.method_10170(), 5);
        }

        public static Solution getForMessage(String message) {
            for (Solution value : Solution.values()) {
                if (!message.startsWith(value.display)) continue;
                return value;
            }
            return null;
        }

        @Generated
        private Solution(String display) {
            this.display = display;
        }
    }
}

