/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.puzzle;

import codes.cookies.mod.config.categories.dungeons.PuzzleCategory;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.render.types.BlockHighlight;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ThreeWeirdosPuzzleSolver
extends PuzzleSolver {
    private static final Pattern PATTERN = Pattern.compile("\\[NPC] (\\w+): (.+)");
    private static final List<String> CORRECT_MESSAGES = Arrays.asList("The reward is not in my chest!", "At least one of them is lying, and the reward is not in \\w+'s chest.?", "My chest doesn't have the reward\\. We are all telling the truth.?", "My chest has the reward and I'm telling the truth!", "The reward isn't in any of our chests.?", "Both of them are telling the truth\\. Also, \\w+ has the reward in their chest.?");
    private static final List<class_2338> DIRECTIONS = Arrays.asList(new class_2338(0, 0, 1), new class_2338(1, 0, 0), new class_2338(0, 0, -1), new class_2338(-1, 0, 0));
    private final Set<String> solved = new HashSet<String>();

    public ThreeWeirdosPuzzleSolver() {
        super(PuzzleCategory.threeWeirdos);
    }

    @Override
    protected void onRoomEnter(DungeonRoom dungeonRoom) {
        if (this.isDisabled()) {
            return;
        }
        super.onRoomEnter(dungeonRoom);
    }

    @Override
    protected void onRoomExit() {
        if (this.isDisabled()) {
            return;
        }
        super.onRoomExit();
    }

    @Override
    public void onChatMessage(String literalMessage) {
        if (this.isDisabled()) {
            return;
        }
        Matcher matcher = PATTERN.matcher(literalMessage);
        if (!matcher.find()) {
            return;
        }
        String npc = matcher.group(1);
        String message = matcher.group(2);
        boolean isCorrect = CORRECT_MESSAGES.stream().anyMatch(message::matches);
        if (this.solved.contains(npc)) {
            return;
        }
        this.findBlockPos(npc).ifPresent(blockPos -> this.addHighlight((class_2338)blockPos, isCorrect, npc));
    }

    private Optional<class_2338> findBlockPos(String name) {
        if (class_310.method_1551().field_1687 == null) {
            return Optional.empty();
        }
        for (class_1297 entity : class_310.method_1551().field_1687.method_18112()) {
            String string;
            if (!(entity instanceof class_1531) || entity.method_5858((class_1297)class_310.method_1551().field_1724) > 25.0 || !(string = Optional.ofNullable(entity.method_5476()).map(class_2561::getString).orElse("")).equals(name)) continue;
            return Optional.ofNullable(entity.method_24515());
        }
        return Optional.empty();
    }

    private void addHighlight(class_2338 center, boolean correct, String npc) {
        for (class_2338 direction : DIRECTIONS) {
            class_2338 add = center.method_10081((class_2382)direction);
            if (class_310.method_1551().field_1687 == null) {
                return;
            }
            if (!class_310.method_1551().field_1687.method_8320(add).method_27852(class_2246.field_10034)) continue;
            this.solved.add(npc);
            BlockHighlight blockHighlight = new BlockHighlight(add, correct ? -8921737 : -38559);
            this.addRenderable(blockHighlight);
            return;
        }
    }

    @Override
    protected void resetPuzzle() {
        this.clearRenderables();
        this.solved.clear();
    }
}

