/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.puzzle;

import codes.cookies.mod.config.categories.dungeons.PuzzleCategory;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.map.DungeonRoom;
import codes.cookies.mod.features.dungeons.solver.puzzle.PuzzleSolver;
import codes.cookies.mod.render.Renderable;
import codes.cookies.mod.render.WorldRender;
import codes.cookies.mod.render.types.BlockHighlight;
import codes.cookies.mod.render.types.Line;
import codes.cookies.mod.render.types.WorldText;
import codes.cookies.mod.repository.constants.dungeons.DungeonConstants;
import codes.cookies.mod.repository.constants.dungeons.WaterEntry;
import codes.cookies.mod.utils.RenderUtils;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.minecraft.NonCacheMutableText;
import codes.cookies.mod.utils.minecraft.SupplierTextContent;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Vector2i;

public class WaterBoardPuzzleSolver
extends PuzzleSolver {
    private static final class_2248[] ALLOWED_BLOCKS = new class_2248[]{class_2246.field_10205, class_2246.field_10415, class_2246.field_10234, class_2246.field_10201, class_2246.field_10153, class_2246.field_10381};
    private final DungeonInstance dungeon;
    private final Map<LeverType, List<Double>> solution = new HashMap<LeverType, List<Double>>();
    private class_2350 puzzleDirection = null;
    private class_2338 chestPosition = null;
    private long openedWater = -1L;
    private int totalClicks = 0;
    private int lastTotalClicks = -1;
    private Renderable line;
    private class_243 leverPos;

    public WaterBoardPuzzleSolver(DungeonInstance dungeon) {
        super(PuzzleCategory.waterBoard);
        this.dungeon = dungeon;
    }

    @Override
    protected void onRoomEnter(DungeonRoom dungeonRoom) {
        Optional<WaterEntry> optionalWaterEntry;
        if (this.isDisabled()) {
            return;
        }
        super.onRoomEnter(dungeonRoom);
        Vector2i vector2i = dungeonRoom.getCenter().orElse(null);
        if (vector2i == null) {
            return;
        }
        class_2338 roomCenter = new class_2338(vector2i.x, 56, vector2i.y);
        if (this.puzzleDirection != null) {
            return;
        }
        List<class_2350> directions = List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
        class_2350 puzzleDirection = null;
        class_2338 chestPosition = null;
        for (class_2350 direction : directions) {
            class_2338 add = roomCenter.method_10081(direction.method_62675().method_35862(7));
            if (this.getWorld().map(world -> world.method_8321(add)).orElse(null) == null) continue;
            chestPosition = add;
            puzzleDirection = direction;
            if (!WaterBoardPuzzleSolver.isDebugEnabled()) break;
            this.addDebugRenderable(new BlockHighlight(add, -8921737));
            break;
        }
        if (puzzleDirection == null) {
            return;
        }
        this.puzzleDirection = puzzleDirection;
        this.chestPosition = chestPosition;
        class_2338 boardCenterBottom = this.chestPosition.method_10081(this.puzzleDirection.method_62675().method_35862(4)).method_10069(0, 4, 0);
        class_2350 first = this.puzzleDirection.method_10166() == class_2350.class_2351.field_11048 ? class_2350.field_11043 : class_2350.field_11039;
        class_2350 second = this.puzzleDirection.method_10166() == class_2350.class_2351.field_11048 ? class_2350.field_11035 : class_2350.field_11034;
        class_2338 top = boardCenterBottom.method_33096(77);
        HashSet<class_2248> blocks = new HashSet<class_2248>();
        for (class_2338 blockPos : class_2338.method_10097((class_2338)top.method_10093(first), (class_2338)top.method_10093(second).method_10093(this.puzzleDirection).method_10093(class_2350.field_11036))) {
            class_2248 block = this.getWorld().get().method_8320(blockPos).method_26204();
            if (!ArrayUtils.contains((Object[])ALLOWED_BLOCKS, (Object)block)) continue;
            blocks.add(block);
            if (!WaterBoardPuzzleSolver.isDebugEnabled()) continue;
            this.addDebugRenderable(new BlockHighlight((class_2338)blockPos.method_25503(), -8921737));
        }
        Variant variant = Variant.getVariant(blocks);
        HashSet<class_2248> closedDoors = new HashSet<class_2248>();
        for (class_2248 value : DoorType.values()) {
            if (!this.getWorld().map(arg_0 -> this.lambda$onRoomEnter$1((DoorType)value, arg_0)).orElse(false).booleanValue()) continue;
            closedDoors.add(value);
        }
        if (WaterBoardPuzzleSolver.isDebugEnabled()) {
            CookiesUtils.sendMessage("Closed Doors: [%s]".formatted(String.join((CharSequence)", ", closedDoors.stream().map(Enum::name).toList())));
            CookiesUtils.sendMessage("Variants: " + String.valueOf((Object)variant));
        }
        if ((optionalWaterEntry = DungeonConstants.getFor(variant, closedDoors.stream().sorted(Comparator.comparingInt(Enum::ordinal)).map(Enum::ordinal).map(String::valueOf).collect(Collectors.joining("")))).isEmpty()) {
            CookiesUtils.sendFailedMessage("No solution found for puzzle");
            return;
        }
        CookiesUtils.sendSuccessMessage("Found solution for puzzle!");
        WaterEntry waterEntry = optionalWaterEntry.get();
        this.solution.clear();
        this.solution.putAll(waterEntry.times());
    }

    @Override
    public void tick() {
        class_243 firstLeverPosition;
        if (this.isDisabled()) {
            return;
        }
        super.tick();
        long totalTime = System.nanoTime();
        if (this.totalClicks == this.lastTotalClicks) {
            return;
        }
        this.clearRenderables();
        List<Pair> list = this.solution.entrySet().stream().filter(Predicate.not(entry -> ((List)entry.getValue()).isEmpty())).filter(entry -> ((List)entry.getValue()).size() > ((LeverType)((Object)((Object)entry.getKey()))).get(this.dungeon).orElse(0)).map(entry -> new Pair((Object)((LeverType)((Object)((Object)entry.getKey()))), (Object)((Double)((List)entry.getValue()).get(((LeverType)((Object)((Object)entry.getKey()))).get(this.dungeon).orElse(0))))).sorted(Comparator.comparingDouble(Pair::getSecond).thenComparingInt(value -> ((LeverType)((Object)((Object)value.getFirst()))).ordinal())).toList();
        if (list.isEmpty()) {
            this.leverPos = null;
            return;
        }
        Pair first = list.getFirst();
        LeverType firstType = (LeverType)((Object)first.getFirst());
        Optional<class_2338> firstLeverBlockPosOptional = firstType.getLeverPosition(this.chestPosition, this.puzzleDirection);
        if (firstLeverBlockPosOptional.isEmpty()) {
            return;
        }
        class_2338 firstLeverBlockPos = firstLeverBlockPosOptional.get();
        this.leverPos = firstLeverPosition = firstLeverBlockPos.method_46558();
        this.addRenderable(new BlockHighlight(firstLeverBlockPos, -8921737));
        if (list.size() > 1) {
            Pair second = list.get(1);
            Optional<class_2338> secondLeverBlockPosOptional = ((LeverType)((Object)second.getFirst())).getLeverPosition(this.chestPosition, this.puzzleDirection);
            if (secondLeverBlockPosOptional.isEmpty()) {
                return;
            }
            class_2338 secondLeverBlockPos = secondLeverBlockPosOptional.get();
            class_243 secondLeverPosition = secondLeverBlockPos.method_46558();
            this.addRenderable(new BlockHighlight(secondLeverBlockPos, -38559));
            this.addRenderable(new Line(secondLeverPosition, firstLeverPosition, -38559, -8921737));
        }
        for (Map.Entry<LeverType, List<Double>> entry2 : this.solution.entrySet()) {
            int i = 0;
            LeverType leverType = entry2.getKey();
            Optional<class_2338> leverBlockPosOptional = leverType.getLeverPosition(this.chestPosition, this.puzzleDirection);
            if (leverBlockPosOptional.isEmpty()) continue;
            class_243 add = leverBlockPosOptional.get().method_46558().method_1031(0.0, 1.0, 0.0);
            for (Double rawTime : entry2.getValue()) {
                if (rawTime == null) continue;
                NonCacheMutableText display = NonCacheMutableText.of((class_7417)new SupplierTextContent(this.getTextSupplier(rawTime, leverType)));
                if (i < leverType.get(this.dungeon).orElse(0)) {
                    ++i;
                    continue;
                }
                this.addRenderable(new WorldText(add.method_43206(class_2350.field_11036, (double)(i++ - leverType.get(this.dungeon).orElse(0)) * 0.4), (class_2561)display, true, 0.04f, 0.0f, -1, false));
            }
        }
        if (WaterBoardPuzzleSolver.isDebugEnabled()) {
            this.addDebugRenderable(new WorldText(this.chestPosition.method_46558().method_1031(0.0, 4.0, 0.0), (class_2561)class_2561.method_43470((String)String.valueOf(System.nanoTime() - totalTime))));
        }
        this.lastTotalClicks = this.totalClicks;
    }

    @Override
    public void beforeRender(float tickDelta) {
        if (this.isDisabled()) {
            return;
        }
        if (this.chestPosition == null) {
            return;
        }
        Optional<class_746> optionalPlayer = CookiesUtils.getPlayer();
        if (optionalPlayer.isEmpty()) {
            return;
        }
        class_746 player = optionalPlayer.get();
        if (this.leverPos != null) {
            WorldRender.removeRenderable(this.line);
            this.line = new Line(RenderUtils.getInterpolated((class_1297)player, tickDelta), this.leverPos, -1466946, -8921737);
            WorldRender.addRenderable(this.line);
        } else if (this.line != null) {
            WorldRender.removeRenderable(this.line);
            this.line = null;
        }
    }

    @Override
    protected void onDisalbe() {
        WorldRender.removeRenderable(this.line);
    }

    @Override
    protected void onEnable() {
        if (this.line != null && this.isLoaded) {
            WorldRender.addRenderable(this.line);
        }
    }

    private Supplier<String> getTextSupplier(double rawTime, LeverType leverType) {
        return () -> {
            double time = this.openedWater == -1L ? rawTime : rawTime - (double)(System.currentTimeMillis() - this.openedWater) / 1000.0;
            if (time <= 0.0) {
                if (leverType == LeverType.WATER) {
                    return "\u00a7cClick Me!";
                }
                return "\u00a7aClick Me!";
            }
            return "\u00a7f(%.2fs)".formatted(time);
        };
    }

    @Override
    public void onInteract(class_1937 world, class_3965 blockHitResult, class_1268 hand) {
        if (this.isDisabled()) {
            return;
        }
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        if (this.puzzleDirection == null || this.chestPosition == null) {
            return;
        }
        class_2680 blockState = world.method_8320(blockHitResult.method_17777());
        class_2248 block = blockState.method_26204();
        if (block != class_2246.field_10363) {
            return;
        }
        for (LeverType value : LeverType.values()) {
            Optional<class_2338> leverPositionOptional = value.getLeverPosition(this.chestPosition, this.puzzleDirection);
            if (!leverPositionOptional.isPresent() || !leverPositionOptional.get().equals((Object)blockHitResult.method_17777())) continue;
            if (value.lastInteraction + 100L < System.currentTimeMillis()) {
                value.increment(this.dungeon);
                ++this.totalClicks;
                if (value == LeverType.WATER && this.openedWater == -1L) {
                    this.openedWater = System.currentTimeMillis();
                }
            }
            value.lastInteraction = System.currentTimeMillis();
            return;
        }
    }

    private /* synthetic */ Boolean lambda$onRoomEnter$1(DoorType value, class_638 world) {
        return value.isClosed(this.chestPosition, this.puzzleDirection, world);
    }

    public static enum Variant implements class_3542
    {
        FIRST(class_2246.field_10205, class_2246.field_10415),
        SECOND(class_2246.field_10234, class_2246.field_10153),
        THIRD(class_2246.field_10153, class_2246.field_10201),
        FOURTH(class_2246.field_10205, class_2246.field_10153);

        public static final Codec<Variant> CODEC;
        private final class_2248[] blocks;

        private Variant(class_2248 ... blocks) {
            this.blocks = blocks;
        }

        public static Variant getVariant(Collection<class_2248> blocks) {
            for (Variant value : Variant.values()) {
                if (value.blocks.length != blocks.size() || !value.matches(blocks)) continue;
                return value;
            }
            return null;
        }

        public boolean matches(Collection<class_2248> blocks) {
            for (class_2248 block : blocks) {
                if (ArrayUtils.contains((Object[])this.blocks, (Object)block)) continue;
                return false;
            }
            return true;
        }

        public String method_15434() {
            return String.valueOf(this.ordinal());
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
        }
    }

    static enum DoorType {
        PURPLE(class_2246.field_10259),
        ORANGE(class_2246.field_10095),
        BLUE(class_2246.field_10514),
        GREEN(class_2246.field_10028),
        RED(class_2246.field_10314);

        private final class_2248 block;

        public boolean isClosed(class_2338 chestPos, class_2350 puzzleDirection, class_638 clientWorld) {
            class_2338 offset = chestPos.method_10079(puzzleDirection.method_10153(), 3 + this.ordinal());
            return clientWorld.method_8320(offset).method_26204() == this.block;
        }

        @Generated
        private DoorType(class_2248 block) {
            this.block = block;
        }
    }

    public static enum LeverType implements class_3542
    {
        QUARTZ,
        GOLD,
        COAL,
        DIAMOND,
        EMERALD,
        CLAY,
        WATER,
        NONE;

        public static final Codec<LeverType> CODEC;
        private final Map<DungeonInstance, Integer> instances = new HashMap<DungeonInstance, Integer>();
        private long lastInteraction = -1L;

        public static void remove(DungeonInstance dungeonInstance) {
            for (LeverType value : LeverType.values()) {
                value.instances.remove(dungeonInstance);
            }
        }

        public Optional<Integer> get(DungeonInstance dungeonInstance) {
            return Optional.ofNullable(this.instances.get(dungeonInstance));
        }

        public void increment(DungeonInstance dungeonInstance) {
            this.instances.put(dungeonInstance, this.get(dungeonInstance).map(i -> i + 1).orElse(1));
        }

        public Optional<class_2338> getLeverPosition(class_2338 chestPosition, class_2350 puzzleDirection) {
            if (chestPosition == null || puzzleDirection == null) {
                return Optional.empty();
            }
            if (this == WATER) {
                return Optional.ofNullable(chestPosition.method_10079(puzzleDirection.method_10153(), 17).method_10086(4));
            }
            int offset = this.ordinal() % 3 * 5;
            boolean left = this.ordinal() < 3;
            class_2350 site = left ? puzzleDirection.method_10160() : puzzleDirection.method_10170();
            return Optional.ofNullable(chestPosition.method_10086(5).method_10079(puzzleDirection.method_10153(), 2 + offset).method_10079(site, 5));
        }

        public String method_15434() {
            return String.valueOf(this.ordinal());
        }

        static {
            CODEC = class_3542.method_28140(LeverType::values);
        }
    }
}

