/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.terminals;

import codes.cookies.mod.config.categories.dungeons.TerminalCategory;
import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.features.dungeons.solver.terminals.TerminalSolver;
import codes.cookies.mod.utils.accessors.SlotAccessor;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.types.MiscDataComponentTypes;
import codes.cookies.mod.utils.skyblock.ChatUtils;
import com.google.common.util.concurrent.Runnables;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3902;
import net.minecraft.class_465;

public class MelodyTerminalSolver
extends TerminalSolver {
    private final class_1799 blockedInput;
    private final boolean[] percentagesAnnounced;
    private int currentColumn;
    private int correctColumn;
    private int currentRow;

    public MelodyTerminalSolver() {
        this.blockedInput = this.doneItem.method_7972().method_60503((class_1935)class_1802.field_8077);
        this.percentagesAnnounced = new boolean[4];
        this.currentColumn = -1;
        this.correctColumn = -1;
        this.currentRow = -1;
        InventoryEvents.beforeInit("Click the button on time!", MelodyTerminalSolver.getFloorPredicate().or(MelodyTerminalSolver.getDebugPredicate()), this::modify);
    }

    private static void melodyNotify(String message) {
        if (TerminalCategory.melodyNotifier) {
            ChatUtils.sendPartyMessage(message);
        }
    }

    private void modify(class_465<?> handledScreen) {
        if (!TerminalCategory.melodyTerminal) {
            return;
        }
        ScreenEvents.remove(handledScreen).register(screen -> {
            if (this.percentagesAnnounced[3]) {
                MelodyTerminalSolver.melodyNotify("Melody Terminal complete!");
            } else {
                MelodyTerminalSolver.melodyNotify("Melody closed without completion???");
            }
            CookiesUtils.sendMessage("Melody Terminal reset!");
            this.percentagesAnnounced[0] = false;
            this.percentagesAnnounced[1] = false;
            this.percentagesAnnounced[2] = false;
            this.percentagesAnnounced[3] = false;
            this.clear();
            this.items.clear();
            this.currentColumn = -1;
            this.correctColumn = -1;
            this.currentRow = -1;
        });
        this.openNewTerminal();
        InventoryContentUpdateEvent.register(handledScreen.method_17577(), (slot, stack) -> this.update(slot, stack, handledScreen.method_17577()));
    }

    @Override
    public void openNewTerminal() {
        super.openNewTerminal();
        if (TerminalCategory.preventMissclicks) {
            this.blockedInput.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)Runnables.doNothing());
        } else {
            this.blockedInput.method_57381(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE);
        }
        MelodyTerminalSolver.melodyNotify("Melody Terminal start!");
    }

    private void update(int slot, class_1799 stack, class_1703 handler) {
        if (slot > 53) {
            return;
        }
        this.items.add(stack);
        if (slot == 53) {
            stack.method_57379(MiscDataComponentTypes.TERMINAL_SOLVER_TOGGLE, (Object)class_3902.field_17274);
            if (this.localToggle) {
                stack.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)this.toggleOff);
            } else {
                stack.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)this.toggleOn);
            }
            if (this.localToggle) {
                this.setItems();
            }
            return;
        }
        if (slot % 9 == 0 || slot % 9 == 6 || slot % 9 == 8) {
            return;
        }
        if (stack.method_31574(class_1802.field_8581)) {
            this.currentRow = slot / 9 - 1;
            this.currentColumn = slot % 9;
            if (this.localToggle && this.currentRow > 0 && !this.percentagesAnnounced[this.currentRow]) {
                MelodyTerminalSolver.melodyNotify("Melody is " + String.format("%.0f%%", Float.valueOf((float)this.currentRow / 4.0f * 100.0f)) + " (" + this.currentRow + "/4) complete!");
                this.percentagesAnnounced[this.currentRow] = true;
            }
            class_1735 selectedSlot = handler.method_7611(slot + (7 - this.currentColumn));
            if (!this.localToggle) {
                SlotAccessor.setInteractionLocked(selectedSlot, false);
                SlotAccessor.setItem(selectedSlot, null);
                return;
            }
            if (this.currentColumn == this.correctColumn) {
                SlotAccessor.setInteractionLocked(selectedSlot, false);
                SlotAccessor.setItem(selectedSlot, null);
            } else {
                if (TerminalCategory.preventMissclicks) {
                    SlotAccessor.setInteractionLocked(selectedSlot, true);
                }
                SlotAccessor.setItem(selectedSlot, this.blockedInput);
            }
            return;
        }
        if (stack.method_31574(class_1802.field_8119)) {
            this.correctColumn = slot % 9;
            return;
        }
        if (stack.method_31574(class_1802.field_8672) && this.localToggle) {
            if (this.currentColumn == this.correctColumn) {
                SlotAccessor.setInteractionLocked(handler.method_7611(slot), false);
                SlotAccessor.setItem(handler.method_7611(slot), null);
            } else {
                SlotAccessor.setInteractionLocked(handler.method_7611(slot), true);
                SlotAccessor.setItem(handler.method_7611(slot), this.blockedInput);
            }
        }
    }
}

