/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.dungeons.solver.terminals;

import codes.cookies.mod.config.categories.dungeons.TerminalCategory;
import codes.cookies.mod.features.dungeons.DungeonFeatures;
import codes.cookies.mod.features.dungeons.DungeonInstance;
import codes.cookies.mod.features.dungeons.map.DungeonPhase;
import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.types.MiscDataComponentTypes;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.Runnables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_465;

public abstract class TerminalSolver {
    public static class_2960 DEBUG = DevUtils.createIdentifier("terminals/disable_click_all_check");
    protected boolean localToggle = true;
    protected final List<class_1799> items = new ArrayList<class_1799>();
    protected final class_1799 shouldClick = new ItemBuilder(class_1802.field_8656).hideTooltips().hideAdditionalTooltips().build();
    protected final class_1799 doneItem = new ItemBuilder(class_1802.field_8157).hideAdditionalTooltips().hideTooltips().build();
    protected final class_1799 toggleOn = new ItemBuilder(class_1802.field_19057).setName((class_2561)TextUtils.literal("Click to turn on", class_124.field_1077)).setLore(new class_2561[]{TextUtils.literal("Enables/Disables the solver for this terminal!", class_124.field_1080)}).setClickRunnable(this::turnOn).hideAdditionalTooltips().build();
    protected final class_1799 toggleOff = new ItemBuilder(class_1802.field_19058).setName((class_2561)TextUtils.literal("Click to turn off", class_124.field_1061)).setLore(new class_2561[]{TextUtils.literal("Enables/Disables the solver for this terminal!", class_124.field_1080)}).setClickRunnable(this::turnOff).hideAdditionalTooltips().build();

    public void openNewTerminal() {
        if (TerminalCategory.preventMissclicks) {
            this.doneItem.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)Runnables.doNothing());
        } else {
            this.doneItem.method_57381(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE);
        }
    }

    private void turnOn() {
        this.localToggle = true;
        this.setItems();
    }

    public void setItems() {
        for (class_1799 item : this.items) {
            if (item.method_57826(MiscDataComponentTypes.TERMINAL_SOLVER_MODIFIED)) {
                item.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)((class_1799)item.method_57824(MiscDataComponentTypes.TERMINAL_SOLVER_MODIFIED)));
            } else if (item.method_57826(MiscDataComponentTypes.TERMINAL_SOLVER_MODIFIED_SUPPLIER)) {
                Supplier supplier = (Supplier)item.method_57824(MiscDataComponentTypes.TERMINAL_SOLVER_MODIFIED_SUPPLIER);
                if (supplier != null) {
                    item.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)((class_1799)supplier.get()));
                }
            } else if (item.method_57826(MiscDataComponentTypes.TERMINAL_SOLVER_MODIFIED_STRING)) {
                item.method_57379(CookiesDataComponentTypes.CUSTOM_SLOT_TEXT, (Object)((String)item.method_57824(MiscDataComponentTypes.TERMINAL_SOLVER_MODIFIED_STRING)));
            }
            if (!item.method_57826(MiscDataComponentTypes.TERMINAL_SOLVER_TOGGLE)) continue;
            item.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)this.toggleOff);
        }
    }

    protected static Predicate<class_465<?>> getFloorPredicate() {
        return Predicates.alwaysTrue().and(o -> DungeonFeatures.getInstance().getCurrentInstance().isPresent()).and(o -> DungeonFeatures.getInstance().getCurrentInstance().map(DungeonInstance::floor).orElse(-1) == 7).and(o -> DungeonFeatures.getInstance().getCurrentInstance().map(DungeonInstance::getPhase).orElse(null) == DungeonPhase.BOSS);
    }

    protected static Predicate<class_465<?>> getDebugPredicate() {
        return t -> DevUtils.isEnabled(DEBUG);
    }

    private void turnOff() {
        this.localToggle = false;
        this.clear();
    }

    protected void clear() {
        for (class_1799 item : this.items) {
            item.method_57381(CookiesDataComponentTypes.OVERRIDE_ITEM);
            if (item.method_57826(MiscDataComponentTypes.TERMINAL_SOLVER_MODIFIED_STRING)) {
                item.method_57381(CookiesDataComponentTypes.CUSTOM_SLOT_TEXT);
            }
            if (!item.method_57826(MiscDataComponentTypes.TERMINAL_SOLVER_TOGGLE)) continue;
            item.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)this.toggleOn);
        }
    }
}

