/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.farming;

import codes.cookies.mod.config.categories.FarmingCategory;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.items.ItemUtils;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;

public class YawPitchDisplay {
    private static final class_2960 DEBUG = DevUtils.createIdentifier("yaw_pitch_debug");
    private static double lastYaw = 0.0;
    private static double lastPitch = 0.0;
    private static double lastUpdate = 0.0;

    public static void register() {
        HudRenderCallback.EVENT.register(YawPitchDisplay::renderHud);
    }

    private static void renderHud(class_332 drawContext, class_9779 renderTickCounter) {
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!FarmingCategory.yawPitchDisplay) {
            return;
        }
        if (ItemUtils.getMainHand().skyblockId().get() == null) {
            return;
        }
        if (!ItemUtils.getMainHand().enchantments().getAsOptional().map(map -> map.containsKey("cultivating") || map.containsKey("replenish")).orElse(false).booleanValue()) {
            return;
        }
        double yaw = class_3532.method_15393((float)class_310.method_1551().field_1724.method_36454());
        double pitch = class_310.method_1551().field_1724.method_36455();
        if (lastYaw == yaw && lastPitch == pitch) {
            if (lastUpdate + 5000.0 < (double)System.currentTimeMillis()) {
                return;
            }
        } else {
            lastUpdate = System.currentTimeMillis();
            lastPitch = pitch;
            lastYaw = yaw;
        }
        int crosshairX = (int)((double)(drawContext.method_51421() - 15) / 2.0 * 1.25);
        int crosshairY = (int)((double)(drawContext.method_51443() - 15) / 2.0 * 1.25);
        int delta = (int)((double)System.currentTimeMillis() - lastUpdate);
        float opacity = 1.0f;
        if (delta > 4500) {
            return;
        }
        if (delta > 1000) {
            opacity = 1.0f - (float)(delta - 1000) / 4000.0f;
        }
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_22905(0.8f, 0.8f, 0.8f);
        int color = (int)(opacity * 255.0f) << 24 | class_124.field_1080.method_532() & 0xFFFFFF;
        drawContext.method_51433(class_310.method_1551().field_1772, "%.03f".formatted(yaw), crosshairX + 18, crosshairY + 6, color, true);
        drawContext.method_25300(class_310.method_1551().field_1772, "%.03f".formatted(pitch), crosshairX + 8, crosshairY + 18, color);
        if (DevUtils.isEnabled(DEBUG)) {
            drawContext.method_25300(class_310.method_1551().field_1772, "\u0394t: " + delta, crosshairX + 8, crosshairY - 4, class_124.field_1080.method_532().intValue());
            drawContext.method_25300(class_310.method_1551().field_1772, "opacity: " + opacity, crosshairX + 8, crosshairY - 14, class_124.field_1080.method_532().intValue());
        }
        drawContext.method_51448().method_22909();
    }
}

