/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.farming.garden;

import codes.cookies.mod.config.categories.FarmingCategory;
import codes.cookies.mod.events.ItemLoreEvent;
import codes.cookies.mod.features.farming.garden.Plot;
import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.constants.ComposterUpgrades;
import codes.cookies.mod.repository.constants.RepositoryConstants;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.maths.RomanNumerals;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_9334;

public class CompostUpgrades {
    boolean isScreenOpen = false;

    public CompostUpgrades() {
        ScreenEvents.BEFORE_INIT.register(this::openScreen);
        ItemLoreEvent.EVENT_ITEM.register(this::update);
    }

    private void openScreen(class_310 minecraftClient, class_437 screen, int i, int i1) {
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!LocationUtils.Island.GARDEN.isActive()) {
            return;
        }
        if (!FarmingCategory.showCompostPriceBreakdown) {
            return;
        }
        if (!(screen instanceof class_465)) {
            return;
        }
        if (!screen.method_25440().getString().equals("Composter Upgrades")) {
            return;
        }
        if (RepositoryConstants.composterUpgrades == null) {
            return;
        }
        this.isScreenOpen = true;
        ScreenEvents.remove((class_437)screen).register(s -> {
            this.isScreenOpen = false;
        });
    }

    private void update(class_1799 itemStack, List<class_5250> mutableTexts) {
        List<ComposterUpgrades.CompostUpgrade> upgrades;
        String maxAmount;
        if (!this.isScreenOpen) {
            return;
        }
        if (!Plot.getCurrentPlot().isBarn()) {
            return;
        }
        if (RepositoryConstants.composterUpgrades == null) {
            return;
        }
        if (ItemUtils.getData(itemStack, class_9334.field_49631) == null) {
            return;
        }
        if (!FarmingCategory.showCompostPriceBreakdown) {
            return;
        }
        LinkedList<class_5250> list = new LinkedList<class_5250>();
        String name = itemStack.method_7964().getString();
        if (!(name.startsWith("Composter Speed") || name.startsWith("Multi Drop") || name.startsWith("Fuel Cap") || name.startsWith("Organic Matter Cap") || name.startsWith("Cost Reduction"))) {
            return;
        }
        String upgradeName = name.replaceAll("(Composter Speed|Multi Drop|Fuel Cap|Organic Matter Cap|Cost Reduction).*", "$1");
        String lastPart = name.substring(upgradeName.length()).trim();
        int currentLevel = lastPart.isEmpty() ? 0 : RomanNumerals.romanToArabic(lastPart.trim());
        switch (upgradeName.trim()) {
            case "Composter Speed": {
                maxAmount = "500%";
                upgrades = RepositoryConstants.composterUpgrades.getSpeed();
                break;
            }
            case "Multi Drop": {
                maxAmount = "75%";
                upgrades = RepositoryConstants.composterUpgrades.getMultiDrop();
                break;
            }
            case "Fuel Cap": {
                maxAmount = "850,000";
                upgrades = RepositoryConstants.composterUpgrades.getFuelCap();
                break;
            }
            case "Organic Matter Cap": {
                maxAmount = "540,000";
                upgrades = RepositoryConstants.composterUpgrades.getOrganicMatterCap();
                break;
            }
            case "Cost Reduction": {
                maxAmount = "25%";
                upgrades = RepositoryConstants.composterUpgrades.getCostReduction();
                break;
            }
            default: {
                return;
            }
        }
        for (class_5250 text : mutableTexts) {
            list.add(text);
            if (text.getString().startsWith("Next Tier: ")) {
                list.add(class_2561.method_43471((String)"cookies.compost_upgrade.max_tier").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)maxAmount).method_27692(class_124.field_1060)));
                continue;
            }
            if (!text.getString().startsWith("+")) continue;
            list.add(class_2561.method_43473());
            list.add(class_2561.method_43471((String)"cookies.compost_upgrade.remaining_cost").method_27693(": ").method_27692(class_124.field_1080));
            List<ComposterUpgrades.CompostUpgrade> subList = upgrades.subList(Math.min(currentLevel, upgrades.size()), upgrades.size());
            List<Ingredient> subListIngredients = subList.stream().flatMap(compostUpgrade -> compostUpgrade.cost().stream()).toList();
            Stream<Object> stream = Ingredient.mergeToList(subListIngredients).stream();
            switch (FarmingCategory.sortOrder) {
                case DESCENDING: {
                    stream = stream.sorted(Comparator.comparingInt(Ingredient::getAmount).reversed());
                    break;
                }
                case ASCENDING: {
                    stream = stream.sorted(Comparator.comparingInt(Ingredient::getAmount));
                }
            }
            stream.forEach(ingredient -> {
                class_5250 entry = class_2561.method_43470((String)"  ");
                RepositoryItem item = RepositoryItem.of(ingredient.getId());
                if (item == null) {
                    list.add(class_2561.method_43469((String)"cookies.item_not_found", (Object[])new Object[]{ingredient.getId()}));
                    return;
                }
                entry.method_10852(item.getFormattedName());
                entry.method_10852((class_2561)class_2561.method_43470((String)" x").method_27693(String.valueOf(ingredient.getAmount())).method_27692(class_124.field_1063));
                list.add(entry);
            });
            int sum = subList.stream().mapToInt(ComposterUpgrades.CompostUpgrade::copper).sum();
            list.add(class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(sum)).method_27693(" Copper").method_27692(class_124.field_1061)));
            break;
        }
        mutableTexts.clear();
        mutableTexts.addAll(list);
    }
}

