/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.farming.garden;

import codes.cookies.mod.utils.dev.DevUtils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public enum Plot {
    BARN,
    INNER_EDGE_PLOT,
    INNER_CORNER_PLOT,
    OUTER_EDGE_PLOT,
    OUTER_CORNER_PLOT,
    NONE;

    private static final class_2960 SKIP_PLOT_CHECK;

    public static Plot getCurrentPlot() {
        return Optional.ofNullable(class_310.method_1551().field_1724).map(class_1297::method_19538).map(Plot::getPlotFromRealCoordinate).orElse(NONE);
    }

    public static Plot getPlotFromRealCoordinate(class_243 position) {
        return Plot.getPlotFromPlotCoordinate((int)(Plot.changeToPlotCenter(Math.abs(position.field_1352)) + 48.0) / 96, (int)(Plot.changeToPlotCenter(Math.abs(position.field_1350)) + 48.0) / 96);
    }

    public static Plot getPlotFromPlotCoordinate(int x, int z) {
        return Plot.getPlotFromAbsolutePlotCoordinate(Math.abs(x), Math.abs(z));
    }

    private static double changeToPlotCenter(double coordinate) {
        return coordinate - coordinate % 48.0;
    }

    private static Plot getPlotFromAbsolutePlotCoordinate(int absoluteX, int absoluteY) {
        if (absoluteX == 2 && absoluteY == 2) {
            return OUTER_CORNER_PLOT;
        }
        if (absoluteX == 1 && absoluteY == 1) {
            return INNER_CORNER_PLOT;
        }
        if (Math.min(absoluteX, absoluteY) == 0 && Math.max(absoluteX, absoluteY) == 1) {
            return INNER_EDGE_PLOT;
        }
        if (absoluteX + absoluteY == 0) {
            return BARN;
        }
        if (absoluteX <= 2 && absoluteY <= 2) {
            return OUTER_EDGE_PLOT;
        }
        return NONE;
    }

    private static double changeToPlotCorner(double coordinate) {
        return coordinate - Math.abs(coordinate % 96.0);
    }

    public class_243 getPlotCenter(class_243 position) {
        return new class_243(Plot.changeToPlotCorner(position.field_1352 + 240.0) - 192.0, 0.0, Plot.changeToPlotCorner(position.field_1350 + 240.0) - 192.0);
    }

    public int toPlotId(class_243 position) {
        if (this == BARN || this == NONE) {
            return -1;
        }
        class_243 plotCenter = this.getPlotCenter(position);
        switch (this.ordinal()) {
            case 1: {
                if (plotCenter.field_1350 < 0.0) {
                    return 1;
                }
                if (plotCenter.field_1352 < -48.0) {
                    return 2;
                }
                if (plotCenter.field_1352 > 48.0) {
                    return 3;
                }
                return 4;
            }
            case 2: {
                if (plotCenter.field_1350 < 0.0) {
                    if (plotCenter.field_1352 < 0.0) {
                        return 5;
                    }
                    return 6;
                }
                if (plotCenter.field_1352 < 0.0) {
                    return 7;
                }
                return 8;
            }
            case 3: {
                boolean isXCloser;
                if (plotCenter.field_1352 == 0.0 && plotCenter.field_1350 < 0.0) {
                    return 9;
                }
                if (plotCenter.field_1350 == 0.0 && plotCenter.field_1352 < 0.0) {
                    return 10;
                }
                if (plotCenter.field_1350 == 0.0 && plotCenter.field_1352 > 0.0) {
                    return 11;
                }
                if (plotCenter.field_1352 == 0.0 && plotCenter.field_1350 > 0.0) {
                    return 12;
                }
                boolean bl = isXCloser = Math.min(Math.abs(plotCenter.field_1352), Math.abs(plotCenter.field_1350)) == Math.abs(plotCenter.field_1352);
                if (plotCenter.field_1350 < 0.0 && plotCenter.field_1352 < 0.0) {
                    if (isXCloser) {
                        return 15;
                    }
                    return 13;
                }
                if (plotCenter.field_1352 < 0.0 && plotCenter.field_1350 > 0.0) {
                    if (isXCloser) {
                        return 19;
                    }
                    return 17;
                }
                if (plotCenter.field_1352 > 0.0 && plotCenter.field_1350 < 0.0) {
                    if (isXCloser) {
                        return 14;
                    }
                    return 16;
                }
                if (!(plotCenter.field_1352 > 0.0) || !(plotCenter.field_1350 > 0.0)) break;
                if (isXCloser) {
                    return 20;
                }
                return 18;
            }
            case 4: {
                if (plotCenter.field_1350 < 0.0 && plotCenter.field_1352 < 0.0) {
                    return 21;
                }
                if (plotCenter.field_1350 < 0.0 && plotCenter.field_1352 > 0.0) {
                    return 22;
                }
                if (plotCenter.field_1350 > 0.0 && plotCenter.field_1352 < 0.0) {
                    return 23;
                }
                if (!(plotCenter.field_1350 > 0.0) || !(plotCenter.field_1352 > 0.0)) break;
                return 24;
            }
        }
        return -1;
    }

    public boolean isValidPlot() {
        return this.ordinal() != 5;
    }

    public boolean isInnerCircle() {
        return this.ordinal() == 1 || this.ordinal() == 2 || DevUtils.isEnabled(SKIP_PLOT_CHECK);
    }

    public boolean isOuterCircle() {
        return this.ordinal() == 3 || this.ordinal() == 4 || DevUtils.isEnabled(SKIP_PLOT_CHECK);
    }

    public boolean isBarn() {
        return this.ordinal() == 0 || DevUtils.isEnabled(SKIP_PLOT_CHECK);
    }

    public boolean isEdge() {
        return this.ordinal() == 1 || this.ordinal() == 3 || DevUtils.isEnabled(SKIP_PLOT_CHECK);
    }

    public boolean isCorner() {
        return this.ordinal() == 2 || this.ordinal() == 4 || DevUtils.isEnabled(SKIP_PLOT_CHECK);
    }

    static {
        SKIP_PLOT_CHECK = DevUtils.createIdentifier("plots/skip_check");
    }
}

