/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.farming.garden;

import codes.cookies.mod.config.categories.CraftHelperCategory;
import codes.cookies.mod.config.categories.FarmingCategory;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperLocation;
import codes.cookies.mod.repository.constants.PlotPrice;
import codes.cookies.mod.repository.constants.RepositoryConstants;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.accessors.InventoryScreenAccessor;
import codes.cookies.mod.utils.compatibility.legendarytooltips.LegendaryTooltips;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8001;
import org.apache.commons.lang3.StringUtils;

public class PlotPriceBreakdown {
    private static final int[][] plotIndex = new int[][]{{13, 21, 23, 31}, {12, 14, 30, 32}, {3, 4, 5, 11, 15, 20, 24, 29, 33, 39, 40, 41}, {2, 6, 38, 42}};
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private List<class_5481> lines;
    private int lineWidth = 0;

    public PlotPriceBreakdown() {
        ScreenEvents.AFTER_INIT.register(this::handleScreen);
    }

    private void handleScreen(class_310 minecraftClient, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!LocationUtils.Island.GARDEN.isActive()) {
            return;
        }
        if (!FarmingCategory.showPlotPriceBreakdown) {
            return;
        }
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 handledScreen = (class_465)screen;
        if (!handledScreen.method_25440().getString().equals("Configure Plots")) {
            return;
        }
        if (RepositoryConstants.plotPrice == null) {
            return;
        }
        CraftHelperLocation value = (CraftHelperLocation)((Object)CraftHelperCategory.location.get());
        if (value == CraftHelperLocation.LEFT_INVENTORY || value == CraftHelperLocation.LEFT) {
            InventoryScreenAccessor.setDisabled(screen, InventoryScreenAccessor.Disabled.CRAFT_HELPER);
        }
        ScreenEvents.afterRender((class_437)screen).register(this::draw);
        this.updateList(handledScreen);
        InventoryContentUpdateEvent.register(handledScreen.method_17577(), (slot, item) -> this.updateList(handledScreen));
    }

    private void draw(class_437 screen, class_332 drawContext, int mouseX, int mouseY, float tickDelta) {
        class_465 handledScreen = (class_465)screen;
        LegendaryTooltips.getInstance().beforeTooltipRender(screen, drawContext);
        drawContext.method_51436(class_310.method_1551().field_1772, this.lines, class_8001.field_41687, handledScreen.field_2776 - this.lineWidth - 32, handledScreen.field_2800 + 16);
        LegendaryTooltips.getInstance().afterTooltipRender(screen);
    }

    private void updateList(class_465<?> handledScreen) {
        int missingCompost = 0;
        int missingBundles = 0;
        int missingPlots = 0;
        int ownedPlots = 0;
        for (int index = 0; index < 4; ++index) {
            List<PlotPrice.Cost> cost = RepositoryConstants.plotPrice.getByIndex(index);
            int amountBought = 0;
            int amountMissing = 0;
            for (int groupIndex = 0; groupIndex < plotIndex[index].length; ++groupIndex) {
                class_1735 slot = (class_1735)handledScreen.method_17577().field_7761.get(plotIndex[index][groupIndex]);
                if (slot.method_7677().method_7960()) continue;
                if (slot.method_7677().method_7909() == class_1802.field_8780 || slot.method_7677().method_7909() == class_1802.field_8879) {
                    ++amountMissing;
                    continue;
                }
                ++amountBought;
            }
            missingPlots += amountMissing;
            ownedPlots += amountBought;
            for (int compostIndex = 0; compostIndex < amountMissing; ++compostIndex) {
                PlotPrice.Cost slotCost = cost.get(amountBought + compostIndex);
                if (slotCost.bundle()) {
                    missingBundles += slotCost.amount();
                    continue;
                }
                missingCompost += slotCost.amount();
            }
        }
        if (missingCompost == 0 && missingBundles == 0) {
            this.lines = Collections.emptyList();
            return;
        }
        int regularCompost = missingCompost + missingBundles * 160;
        LinkedList<class_5250> breakdown = new LinkedList<class_5250>();
        breakdown.add(class_2561.method_43473());
        breakdown.add(class_2561.method_43471((String)"cookies.plot_price_breakdown.plots_missing").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(missingPlots)).method_27692(class_124.field_1065)));
        breakdown.add(class_2561.method_43471((String)"cookies.plot_price_breakdown.plots_owned").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(ownedPlots)).method_27692(class_124.field_1065)));
        breakdown.add(class_2561.method_43473());
        breakdown.add(class_2561.method_43473());
        if (missingCompost > 0) {
            breakdown.add(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.numberFormat.format(missingCompost)).method_27692(class_124.field_1065).method_27693("x ")).method_10852((class_2561)class_2561.method_43470((String)"Compost").method_27692(class_124.field_1060)));
        }
        breakdown.add(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.numberFormat.format(missingBundles)).method_27692(class_124.field_1065).method_27693("x ")).method_10852((class_2561)class_2561.method_43470((String)"Compost Bundle").method_27692(class_124.field_1078)));
        breakdown.add(class_2561.method_43470((String)" -> ").method_10852((class_2561)class_2561.method_43470((String)this.numberFormat.format((long)missingBundles * 160L)).method_27692(class_124.field_1065).method_27693("x ")).method_10852((class_2561)class_2561.method_43470((String)"Compost").method_27692(class_124.field_1060)).method_27692(class_124.field_1063));
        breakdown.add(class_2561.method_43471((String)"cookies.plot_price_breakdown.missing").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)this.numberFormat.format(regularCompost)).method_27692(class_124.field_1065).method_27693("x ")).method_10852((class_2561)class_2561.method_43470((String)"Compost").method_27692(class_124.field_1060)));
        int maxLineWidth = 0;
        for (class_5250 mutableText : breakdown) {
            maxLineWidth = Math.max(maxLineWidth, class_310.method_1551().field_1772.method_27525((class_5348)mutableText));
        }
        int equalsWidth = class_310.method_1551().field_1772.method_1727(" ");
        breakdown.add(breakdown.size() - 1, class_2561.method_43470((String)StringUtils.leftPad((String)"", (int)(maxLineWidth / equalsWidth), (String)" ")).method_27695(new class_124[]{class_124.field_1055, class_124.field_1078}));
        class_5250 breakdownLine = class_2561.method_43471((String)"cookies.plot_price_breakdown").method_27693(": ").method_27695(new class_124[]{class_124.field_1067, class_124.field_1078});
        int breakdownWidth = class_310.method_1551().field_1772.method_27525((class_5348)breakdownLine);
        breakdown.addFirst(class_2561.method_43470((String)StringUtils.leftPad((String)"", (int)((maxLineWidth - breakdownWidth) / 2 / equalsWidth))).method_10852((class_2561)breakdownLine));
        class_5250 compostBreakdownLine = class_2561.method_43471((String)"cookies.plot_price_breakdown.compost_breakdown").method_27693(": ").method_27695(new class_124[]{class_124.field_1067, class_124.field_1078});
        int compostBreakdownWidth = class_310.method_1551().field_1772.method_27525((class_5348)compostBreakdownLine);
        breakdown.add(5, class_2561.method_43470((String)StringUtils.leftPad((String)"", (int)((maxLineWidth - compostBreakdownWidth) / 2 / equalsWidth))).method_10852((class_2561)compostBreakdownLine));
        this.lines = Lists.transform(breakdown, class_2561::method_30937);
        this.lineWidth = maxLineWidth;
    }
}

