/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.farming.garden.visitors;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.config.categories.FarmingCategory;
import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.translations.TranslationKeys;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import com.google.common.util.concurrent.Runnables;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_465;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;

public class VisitorDropProtection
implements TranslationKeys {
    private static final Pattern rewardsPattern = Pattern.compile("Rewards:([\\S\\s]*)(?:Click|Missing)");
    protected static final class_1799 disabledItem = new ItemBuilder(class_1802.field_8077).hideAdditionalTooltips().set(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, Runnables.doNothing()).setName((class_2561)class_2561.method_43471((String)"cookies.dropprotectionmessage").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(true)))).set(class_9334.field_50073, class_1814.field_8906).build();
    private static final String[] rareDrops = new String[]{"Bandana", "Music", "Dedication", "Jungle Key", "Soul", "Space", "Harbinger", "Overgrown Grass", "Dye"};
    private static final String[] commonDrops = new String[]{"Candy", "Biofuel", "Pet Cake", "Fine Flour", "Pelt", "Velvet", "Cashmere", "Satin", "Oxford", "Powder"};

    private VisitorDropProtection(class_465<?> handledScreen) {
        InventoryContentUpdateEvent.registerSlot(handledScreen.method_17577(), ExceptionHandler.wrap(this::updateSlots));
    }

    private void updateSlots(class_1735 slot) {
        if (slot.field_7874 == 33) {
            this.handleRejectButton(slot.method_7677(), this.handleAcceptItem(slot.field_7871.method_5438(29)));
        }
    }

    private void handleRejectButton(class_1799 rejectStack, boolean applyProtection) {
        if (!applyProtection || rejectStack == null || rejectStack.method_7960() || !rejectStack.method_31574(class_1802.field_8353)) {
            return;
        }
        rejectStack.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)Runnables.doNothing());
        rejectStack.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)disabledItem);
        CookiesMod.getExecutorService().schedule(() -> {
            rejectStack.method_57381(CookiesDataComponentTypes.OVERRIDE_ITEM);
            rejectStack.method_57381(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE);
        }, 5L, TimeUnit.SECONDS);
    }

    private boolean handleAcceptItem(class_1799 visitorItem) {
        if (visitorItem == null || visitorItem.method_7960() || !visitorItem.method_31574(class_1802.field_8798) || !visitorItem.method_57826(class_9334.field_49632)) {
            return false;
        }
        String lore = String.join((CharSequence)"\n", (CharSequence[])((class_9290)visitorItem.method_57824(class_9334.field_49632)).comp_2400().stream().map(class_2561::getString).toArray(String[]::new));
        Matcher matcher = rewardsPattern.matcher(lore);
        if (!matcher.find()) {
            return false;
        }
        for (String rareDrop : rareDrops) {
            if (!StringUtils.containsIgnoreCase((CharSequence)lore, (CharSequence)rareDrop)) continue;
            return true;
        }
        if (FarmingCategory.visitorCommonDropProtection) {
            for (String commonDrop : commonDrops) {
                if (!StringUtils.containsIgnoreCase((CharSequence)lore, (CharSequence)commonDrop)) continue;
                return true;
            }
        }
        return false;
    }

    public static void init() {
        InventoryEvents.beforeInit("cookies-behaviour:always", inv -> LocationUtils.Island.GARDEN.isActive() && FarmingCategory.visitorRareDropProtection, VisitorDropProtection::new);
    }
}

