/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.farming.inventory;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.config.ConfigManager;
import codes.cookies.mod.config.categories.FarmingCategory;
import codes.cookies.mod.config.data.RancherSpeedConfig;
import codes.cookies.mod.data.farming.RancherSpeeds;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.events.api.ScreenKeyEvents;
import codes.cookies.mod.utils.IntReference;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.minecraft.SoundUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_498;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RancherBootsOverlay {
    private static final class_2960 SKIP_RANCHER_BOOTS_CHECK = DevUtils.createIdentifier("garden/rancher_boots/disable_boots_check");
    boolean useProfile = false;
    private RancherSpeeds rancherSpeeds;
    private int editing = -1;
    private int maxWidth = 0;
    private boolean show = false;
    private float track = 0.0f;
    private String editingValue = "";
    private Runnable save = this::saveConfig;

    public RancherBootsOverlay() {
        ScreenEvents.BEFORE_INIT.register(this::openScreen);
    }

    private void saveCurrent() {
        IntReference intReference;
        if (this.editingValue.isBlank()) {
            this.editingValue = "0";
        }
        if ((intReference = this.indexToReference(this.editing)) != null) {
            intReference.set(Integer.parseInt(this.editingValue));
        }
    }

    private void setEditing(int index) {
        this.saveCurrent();
        this.editing = index;
        IntReference newReference = this.indexToReference(this.editing);
        this.editingValue = newReference != null ? String.valueOf(newReference.get()) : "";
        if (index == -1) {
            CookiesMod.getExecutorService().execute(this.save);
        }
    }

    private void openScreen(class_310 minecraftClient, class_437 screen, int width, int height) {
        if (!(screen instanceof class_498)) {
            return;
        }
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!FarmingCategory.showRancherOptimalSpeed) {
            return;
        }
        if (!DevUtils.isEnabled(SKIP_RANCHER_BOOTS_CHECK) && !this.isRancherBootsScreen((class_498)screen)) {
            return;
        }
        this.evaluateSpeeds();
        this.setEditing(-1);
        this.maxWidth = -1;
        ScreenEvents.afterRender((class_437)screen).register(this::render);
        ScreenMouseEvents.afterMouseClick((class_437)screen).register(this::mouseClick);
        ScreenKeyEvents.getExtension(screen).cookies$allowCharTyped().register(this::charTyped);
        ScreenKeyboardEvents.allowKeyPress((class_437)screen).register(this::keyPressed);
    }

    private boolean isRancherBootsScreen(class_498 screen) {
        return screen.field_40425[1].trim().equals("^^^^^^") && screen.field_40425[2].trim().equals("Set your") && screen.field_40425[3].trim().equals("speed cap!");
    }

    private void evaluateSpeeds() {
        RancherSpeeds rancherSpeeds;
        boolean useProfile;
        RancherSpeedConfig rancherSpeed = FarmingCategory.rancherSpeed.getValue();
        ProfileData profile = ProfileStorage.getCurrentProfile().orElse(null);
        this.useProfile = useProfile = profile != null && rancherSpeed.useProfileSettings.contains(profile.getProfileUuid().toString());
        if (useProfile) {
            rancherSpeeds = profile.getRancherSpeeds().asData();
            this.save = ProfileStorage::saveCurrentProfile;
        } else {
            rancherSpeeds = FarmingCategory.rancherSpeed.getValue().asData();
            this.save = this::saveConfig;
        }
        this.rancherSpeeds = rancherSpeeds;
    }

    private void render(class_437 screen, class_332 drawContext, int mouseX, int mouseY, float tickDelta) {
        drawContext.method_51448().method_22903();
        int x = this.getX(screen);
        int y = this.getY(screen);
        drawContext.method_51448().method_46416((float)x, (float)y, 50.0f);
        int translatedMouseX = mouseX - x;
        int translatedMouseY = mouseY - y;
        drawContext.method_51434(class_310.method_1551().field_1772, this.getText(translatedMouseX, translatedMouseY, tickDelta), 0, 0);
        drawContext.method_51448().method_22909();
    }

    private void mouseClick(class_437 screen, double mouseX, double mouseY, int button) {
        int x = this.getX(screen);
        int y = this.getY(screen);
        int translatedMouseX = (int)(mouseX - (double)x);
        int translatedMouseY = (int)(mouseY - (double)y);
        if (translatedMouseX <= 0 || translatedMouseX >= this.maxWidth) {
            return;
        }
        int index = this.getIndex(translatedMouseY) - 2;
        if (index == 12) {
            this.setEditing(-1);
            SoundUtils.playSound((class_3414)class_3417.field_14622.comp_349(), 3.0f, 1.0f);
            this.toggleUseProfile();
        } else if (index == 13) {
            SoundUtils.playSound((class_3414)class_3417.field_14622.comp_349(), 3.0f, 1.0f);
            this.rancherSpeeds.loadFrom(RancherSpeedConfig.DEFAULT);
            this.setEditing(-1);
        } else if (this.editing == -1 && index == 11) {
            this.setEditing(0);
        } else if (this.editing != -1) {
            this.setEditing(index);
        } else {
            IntReference intReference = this.indexToReference(index);
            if (intReference == null) {
                return;
            }
            class_498 signEditScreen = (class_498)screen;
            signEditScreen.field_40425[0] = String.valueOf(intReference.get());
        }
    }

    private void saveConfig() {
        ConfigManager.saveConfig("ranchers-boots-speed");
    }

    private void toggleUseProfile() {
        ProfileStorage.getCurrentProfile().ifPresent(profileData -> {
            String uuid = profileData.getProfileUuid().toString();
            List<String> uuids = FarmingCategory.rancherSpeed.getValue().useProfileSettings;
            if (this.useProfile) {
                uuids.remove(uuid);
            } else {
                uuids.add(uuid);
            }
            CookiesMod.getExecutorService().execute(this::saveConfig);
            this.evaluateSpeeds();
        });
    }

    private boolean charTyped(class_437 screen, char c, int i) {
        if (this.editing == -1) {
            return true;
        }
        IntReference intReference = this.indexToReference(this.editing);
        if (intReference == null) {
            return true;
        }
        if (c < '0' || c > '9') {
            return false;
        }
        if (this.editingValue.length() >= 3) {
            return false;
        }
        this.editingValue = this.editingValue + c;
        return false;
    }

    private boolean keyPressed(class_437 screen, int key, int scancode, int modifiers) {
        if (this.editing == -1) {
            return true;
        }
        IntReference intReference = this.indexToReference(this.editing);
        if (intReference == null) {
            return true;
        }
        switch (key) {
            case 257: 
            case 335: {
                this.setEditing(-1);
                break;
            }
            case 259: {
                this.editingValue = this.editingValue.length() <= 1 ? "" : this.editingValue.substring(0, this.editingValue.length() - 1);
                return false;
            }
            case 258: {
                int temp = this.editing;
                temp = class_437.method_25442() ? --temp : ++temp;
                if (temp < 0) {
                    temp = 9;
                } else if (temp > 9) {
                    temp = 0;
                }
                this.setEditing(temp);
                break;
            }
            case 256: {
                this.setEditing(-1);
                return true;
            }
            case 265: {
                this.setEditing(Math.max(this.editing - 1, 0));
                break;
            }
            case 264: {
                this.setEditing(Math.min(this.editing + 1, 9));
            }
        }
        return false;
    }

    private int getX(class_437 screen) {
        return screen.field_22789 / 2 + 55;
    }

    private int getY(class_437 screen) {
        int difference = screen.field_22790 / 4 + 55;
        int negativeOffsetY = 0;
        if (difference < 160) {
            negativeOffsetY = 160 - difference;
        }
        return 67 - negativeOffsetY;
    }

    private List<class_2561> getText(int mouseX, int mouseY, float tickDelta) {
        class_5250 textAt;
        ArrayList<class_5250> texts = new ArrayList<class_5250>();
        texts.add(class_2561.method_43471((String)"cookies.rancher_boots.farming_speeds").method_27692(class_124.field_1067).method_54663(-1466946));
        texts.add(class_2561.method_43473());
        texts.add(class_2561.method_43471((String)"item.minecraft.wheat").method_27693(": ").method_54663(16113331).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.wheat().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.carrot").method_27693(": ").method_54663(15569185).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.carrot().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.potato").method_27693(": ").method_54663(12030568).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.potato().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.nether_wart").method_27693(": ").method_54663(10427151).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.netherWart().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.pumpkin").method_27693(": ").method_54663(16741656).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.pumpkin().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.melon").method_27693(": ").method_54663(7646349).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.melon().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.cocoa_beans").method_27693(": ").method_54663(4725788).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.cocoaBeans().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.sugar_cane").method_27693(": ").method_54663(12835705).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.sugarCane().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.cactus").method_27693(": ").method_54663(6059358).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.cactus().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.red_mushroom").method_27693(": ").method_54663(9470061).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.rancherSpeeds.mushroom().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43473());
        texts.add(class_2561.method_43470((String)"\u270e ").method_10852((class_2561)class_2561.method_43471((String)"cookies.click_to_edit")).method_27692(class_124.field_1062));
        if (this.useProfile) {
            texts.add(class_2561.method_43470((String)"\u2610 ").method_10852((class_2561)class_2561.method_43471((String)"cookies.rancher_boots.save_global")).method_27692(class_124.field_1077));
        } else {
            texts.add(class_2561.method_43470((String)"\u2611 ").method_10852((class_2561)class_2561.method_43471((String)"cookies.rancher_boots.save_global")).method_27692(class_124.field_1077));
        }
        texts.add(class_2561.method_43470((String)"\ud83d\udd01 ").method_10852((class_2561)class_2561.method_43471((String)"cookies.rancher_boots.reset_to_default")).method_27692(class_124.field_1061));
        for (class_5250 text : texts) {
            int width = class_310.method_1551().field_1772.method_27525((class_5348)text);
            if (width <= this.maxWidth) continue;
            this.maxWidth = width;
        }
        if (this.editing >= 0 && this.editing <= 9) {
            class_5250 mutableText = (class_5250)texts.get(this.editing + 2);
            mutableText.method_10855().removeLast();
            mutableText.method_10852((class_2561)class_2561.method_43470((String)this.editingValue).method_27692(class_124.field_1080));
            if (this.show) {
                mutableText.method_10852((class_2561)class_2561.method_43470((String)"_").method_27692(class_124.field_1080));
            }
            this.track += tickDelta;
            if (this.track >= 8.0f) {
                this.track = 0.0f;
                boolean bl = this.show = !this.show;
            }
        }
        if (mouseX > 0 && mouseX <= this.maxWidth && this.editing != this.getIndex(mouseY) - 2 && (textAt = this.getTextAt(texts, mouseY)) != null) {
            textAt.method_27692(class_124.field_1073);
            for (class_2561 sibling : textAt.method_10855()) {
                if (!(sibling instanceof class_5250)) continue;
                class_5250 mutableText = (class_5250)sibling;
                mutableText.method_27692(class_124.field_1073);
            }
        }
        return Lists.transform(texts, class_2561.class::cast);
    }

    private int getIndex(int y) {
        return y / 10 + 1;
    }

    private IntReference indexToReference(int index) {
        return switch (index) {
            case 0 -> this.rancherSpeeds.wheat();
            case 1 -> this.rancherSpeeds.carrot();
            case 2 -> this.rancherSpeeds.potato();
            case 3 -> this.rancherSpeeds.netherWart();
            case 4 -> this.rancherSpeeds.pumpkin();
            case 5 -> this.rancherSpeeds.melon();
            case 6 -> this.rancherSpeeds.cocoaBeans();
            case 7 -> this.rancherSpeeds.sugarCane();
            case 8 -> this.rancherSpeeds.cactus();
            case 9 -> this.rancherSpeeds.mushroom();
            default -> null;
        };
    }

    private class_5250 getTextAt(List<class_5250> texts, int y) {
        int i = this.getIndex(y);
        if (i >= 1 && i < texts.size()) {
            return texts.get(i);
        }
        return null;
    }
}

