/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.farming.inventory.squeakymousemat;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.config.ConfigManager;
import codes.cookies.mod.config.categories.FarmingCategory;
import codes.cookies.mod.config.data.SqueakyMousematOption;
import codes.cookies.mod.data.farming.squeakymousemat.SqueakyMousematData;
import codes.cookies.mod.data.farming.squeakymousemat.SqueakyMousematEntry;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.events.api.ScreenKeyEvents;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.minecraft.SoundUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_498;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class SqueakyMousematOverlay {
    private static final class_2960 SKIP_RANCHER_BOOTS_CHECK = DevUtils.createIdentifier("garden/squeaky_mousemat/disable_check");
    boolean useProfile = false;
    private SqueakyMousematData data;
    private int editing = -1;
    private boolean isEditingYaw = true;
    private int maxWidth = 0;
    private boolean show = false;
    private float track = 0.0f;
    private String editingValue = "";

    public SqueakyMousematOverlay() {
        ScreenEvents.BEFORE_INIT.register(this::openScreen);
    }

    private void saveCurrent() {
        SqueakyMousematEntry intReference;
        if (this.editingValue.isBlank()) {
            this.editingValue = "0";
        }
        if ((intReference = this.indexToReference(this.editing)) != null) {
            double newNumber = Double.parseDouble(this.editingValue);
            if (this.isEditingYaw) {
                intReference.setYaw(newNumber);
            } else {
                intReference.setPitch(newNumber);
            }
        }
    }

    private void setEditing(int index, boolean isEditingYaw) {
        this.saveCurrent();
        this.isEditingYaw = isEditingYaw;
        this.editing = index;
        SqueakyMousematEntry entry = this.indexToReference(this.editing);
        this.editingValue = entry != null ? String.valueOf(this.isEditingYaw ? entry.getYaw() : entry.getPitch()) : "";
        if (index == -1) {
            CookiesMod.getExecutorService().execute(this::saveConfig);
        }
    }

    private void openScreen(class_310 minecraftClient, class_437 screen, int width, int height) {
        if (!(screen instanceof class_498)) {
            return;
        }
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!FarmingCategory.mousematOverlay) {
            return;
        }
        if (!DevUtils.isEnabled(SKIP_RANCHER_BOOTS_CHECK) && !this.isRancherBootsScreen((class_498)screen)) {
            return;
        }
        this.evaluateSpeeds();
        this.setEditing(-1, true);
        this.maxWidth = -1;
        ScreenEvents.afterRender((class_437)screen).register(this::render);
        ScreenMouseEvents.afterMouseClick((class_437)screen).register(this::mouseClick);
        ScreenKeyEvents.getExtension(screen).cookies$allowCharTyped().register(this::charTyped);
        ScreenKeyboardEvents.allowKeyPress((class_437)screen).register(this::keyPressed);
    }

    private boolean isRancherBootsScreen(class_498 screen) {
        return screen.field_40425[1].trim().equals("Set Yaw Above!") && screen.field_40425[2].trim().equals("Set Pitch Below!");
    }

    private void evaluateSpeeds() {
        SqueakyMousematOption mousematOption = FarmingCategory.squeakyMousematOption.getValue();
        ProfileData profile = ProfileStorage.getCurrentProfile().orElse(null);
        boolean useProfile = profile != null && mousematOption.useProfileData().contains(profile.getProfileUuid());
        this.data = useProfile ? profile.getSqueakyMousematData() : mousematOption.data();
    }

    private void render(class_437 screen, class_332 drawContext, int mouseX, int mouseY, float tickDelta) {
        drawContext.method_51448().method_22903();
        int x = this.getX(screen);
        int y = this.getY(screen);
        drawContext.method_51448().method_46416((float)x, (float)y, 50.0f);
        int translatedMouseX = mouseX - x;
        int translatedMouseY = mouseY - y;
        drawContext.method_51434(class_310.method_1551().field_1772, this.getText(translatedMouseX, translatedMouseY, tickDelta), 0, 0);
        drawContext.method_51448().method_22909();
    }

    private void mouseClick(class_437 screen, double mouseX, double mouseY, int button) {
        int x = this.getX(screen);
        int y = this.getY(screen);
        int translatedMouseX = (int)(mouseX - (double)x);
        int translatedMouseY = (int)(mouseY - (double)y);
        if (translatedMouseX <= 0 || translatedMouseX >= this.maxWidth) {
            return;
        }
        int index = this.getIndex(translatedMouseY) - 2;
        if (index == 12) {
            this.setEditing(-1, true);
            SoundUtils.playSound((class_3414)class_3417.field_14622.comp_349(), 3.0f, 1.0f);
            this.toggleUseProfile();
        } else if (index == 13) {
            SoundUtils.playSound((class_3414)class_3417.field_14622.comp_349(), 3.0f, 1.0f);
            this.data.loadFrom(SqueakyMousematData.getDefault());
            this.setEditing(-1, true);
        } else if (this.editing == -1 && index == 11) {
            this.setEditing(0, true);
        } else if (this.editing != -1) {
            this.setEditing(index, true);
        } else {
            SqueakyMousematEntry intReference = this.indexToReference(index);
            if (intReference == null) {
                return;
            }
            class_498 signEditScreen = (class_498)screen;
            signEditScreen.field_40425[0] = String.valueOf(intReference.getYaw());
            signEditScreen.field_40425[3] = String.valueOf(intReference.getPitch());
        }
    }

    private void saveConfig() {
        ConfigManager.saveConfig("squeaky-mousemat-overlay");
    }

    private void toggleUseProfile() {
        ProfileStorage.getCurrentProfile().ifPresent(profileData -> {
            UUID uuid = profileData.getProfileUuid();
            List<UUID> uuids = FarmingCategory.squeakyMousematOption.getValue().useProfileData();
            if (this.useProfile) {
                uuids.remove(uuid);
            } else {
                uuids.add(uuid);
            }
            this.useProfile = !this.useProfile;
            CookiesMod.getExecutorService().execute(this::saveConfig);
            this.evaluateSpeeds();
        });
    }

    private boolean charTyped(class_437 screen, char c, int i) {
        if (this.editing == -1) {
            return true;
        }
        SqueakyMousematEntry intReference = this.indexToReference(this.editing);
        if (intReference == null) {
            return true;
        }
        if (this.editingValue.isBlank() && c == '-') {
            this.editingValue = "-";
            return false;
        }
        if (this.editingValue.indexOf(46) == -1 && c == '.') {
            this.editingValue = this.editingValue + ".";
            return false;
        }
        if (c < '0' || c > '9') {
            return false;
        }
        if (!(this.editingValue.contains(".") || this.editingValue.startsWith("-") && this.editingValue.length() < 4 || this.editingValue.length() < 3)) {
            return false;
        }
        this.editingValue = this.editingValue + c;
        return false;
    }

    private boolean keyPressed(class_437 screen, int key, int scancode, int modifiers) {
        if (this.editing == -1) {
            return true;
        }
        SqueakyMousematEntry intReference = this.indexToReference(this.editing);
        if (intReference == null) {
            return true;
        }
        switch (key) {
            case 257: 
            case 335: {
                this.setEditing(-1, true);
                break;
            }
            case 259: {
                this.editingValue = this.editingValue.length() <= 1 ? "" : this.editingValue.substring(0, this.editingValue.length() - 1);
                return false;
            }
            case 258: {
                int temp = this.editing;
                temp = class_437.method_25442() ? --temp : ++temp;
                if (temp < 0) {
                    temp = 18;
                } else if (temp > 18) {
                    temp = 0;
                }
                this.setEditing(temp / 2, temp % 2 == 0);
                break;
            }
            case 256: {
                this.setEditing(-1, true);
                return true;
            }
            case 265: {
                this.setEditing(Math.max(this.editing - 1, 0), this.isEditingYaw);
                break;
            }
            case 264: {
                this.setEditing(Math.min(this.editing + 1, 9), this.isEditingYaw);
                break;
            }
            case 262: 
            case 263: {
                this.setEditing(this.editing, !this.isEditingYaw);
            }
        }
        return false;
    }

    private int getX(class_437 screen) {
        return screen.field_22789 / 2 + 55;
    }

    private int getY(class_437 screen) {
        int difference = screen.field_22790 / 4 + 55;
        int negativeOffsetY = 0;
        if (difference < 160) {
            negativeOffsetY = 160 - difference;
        }
        return 67 - negativeOffsetY;
    }

    private List<class_2561> getText(int mouseX, int mouseY, float tickDelta) {
        class_5250 textAt;
        ArrayList<class_5250> texts = new ArrayList<class_5250>();
        texts.add(class_2561.method_43470((String)"Farming Angles").method_27692(class_124.field_1067).method_54663(-1466946));
        texts.add(class_2561.method_43473());
        texts.add(class_2561.method_43471((String)"item.minecraft.wheat").method_27693(": ").method_54663(16113331).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.wheat().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.carrot").method_27693(": ").method_54663(15569185).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.carrot().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.potato").method_27693(": ").method_54663(12030568).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.potato().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.nether_wart").method_27693(": ").method_54663(10427151).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.netherWart().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.pumpkin").method_27693(": ").method_54663(16741656).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.pumpkin().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.melon").method_27693(": ").method_54663(7646349).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.melon().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"item.minecraft.cocoa_beans").method_27693(": ").method_54663(4725788).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.cocoaBeans().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.sugar_cane").method_27693(": ").method_54663(12835705).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.sugarCane().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.cactus").method_27693(": ").method_54663(6059358).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.cactus().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43471((String)"block.minecraft.red_mushroom").method_27693(": ").method_54663(9470061).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.data.mushroom().get())).method_27692(class_124.field_1080)));
        texts.add(class_2561.method_43473());
        texts.add(class_2561.method_43470((String)"\u270e ").method_10852((class_2561)class_2561.method_43471((String)"cookies.click_to_edit")).method_27692(class_124.field_1062));
        if (this.useProfile) {
            texts.add(class_2561.method_43470((String)"\u2610 ").method_10852((class_2561)class_2561.method_43471((String)"cookies.rancher_boots.save_global")).method_27692(class_124.field_1077));
        } else {
            texts.add(class_2561.method_43470((String)"\u2611 ").method_10852((class_2561)class_2561.method_43471((String)"cookies.rancher_boots.save_global")).method_27692(class_124.field_1077));
        }
        texts.add(class_2561.method_43470((String)"\ud83d\udd01 ").method_10852((class_2561)class_2561.method_43471((String)"cookies.rancher_boots.reset_to_default")).method_27692(class_124.field_1061));
        for (class_5250 text : texts) {
            int width = class_310.method_1551().field_1772.method_27525((class_5348)text);
            if (width <= this.maxWidth) continue;
            this.maxWidth = width;
        }
        if (this.editing >= 0 && this.editing <= 9) {
            class_5250 mutableText = (class_5250)texts.get(this.editing + 2);
            mutableText.method_10855().removeLast();
            class_5250 newSibling = class_2561.method_43473().method_27692(class_124.field_1080);
            SqueakyMousematEntry squeakyMousematEntry = Optional.ofNullable(this.indexToReference(this.editing)).orElse(SqueakyMousematEntry.EMPTY);
            class_5250 editing = class_2561.method_43470((String)this.editingValue);
            if (this.isEditingYaw) {
                newSibling.method_10852((class_2561)editing);
                newSibling.method_27693("/ ").method_27693(String.valueOf(squeakyMousematEntry.getPitch()));
            } else {
                newSibling.method_27693(String.valueOf(squeakyMousematEntry.getYaw())).method_27693(" / ");
                newSibling.method_10852((class_2561)editing);
            }
            if (this.show) {
                editing.method_10852((class_2561)class_2561.method_43470((String)"_").method_27692(class_124.field_1080));
            } else {
                editing.method_10852((class_2561)class_2561.method_43470((String)" ").method_27692(class_124.field_1063));
            }
            mutableText.method_10852((class_2561)newSibling);
            this.track += tickDelta;
            if (this.track >= 8.0f) {
                this.track = 0.0f;
                boolean bl = this.show = !this.show;
            }
        }
        if (mouseX > 0 && mouseX <= this.maxWidth && this.editing != this.getIndex(mouseY) - 2 && (textAt = this.getTextAt(texts, mouseY)) != null) {
            textAt.method_27692(class_124.field_1073);
            for (class_2561 sibling : textAt.method_10855()) {
                if (!(sibling instanceof class_5250)) continue;
                class_5250 mutableText = (class_5250)sibling;
                mutableText.method_27692(class_124.field_1073);
            }
        }
        return Lists.transform(texts, class_2561.class::cast);
    }

    private int getIndex(int y) {
        return y / 10 + 1;
    }

    private SqueakyMousematEntry indexToReference(int index) {
        return switch (index) {
            case 0 -> this.data.wheat();
            case 1 -> this.data.carrot();
            case 2 -> this.data.potato();
            case 3 -> this.data.netherWart();
            case 4 -> this.data.pumpkin();
            case 5 -> this.data.melon();
            case 6 -> this.data.cocoaBeans();
            case 7 -> this.data.sugarCane();
            case 8 -> this.data.cactus();
            case 9 -> this.data.mushroom();
            default -> null;
        };
    }

    private class_5250 getTextAt(List<class_5250> texts, int y) {
        int i = this.getIndex(y);
        if (i >= 1 && i < texts.size()) {
            return texts.get(i);
        }
        return null;
    }
}

