/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining;

import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.ForgeUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ForgeFeatures {
    private ForgeFeatures(class_465<?> handledScreen) {
        InventoryContentUpdateEvent.registerSlot(handledScreen.method_17577(), ExceptionHandler.wrap(this::updateSlots));
    }

    private void updateSlots(class_1735 slot) {
        if (slot.field_7874 < 10 || slot.field_7874 > 16) {
            return;
        }
        slot.method_7677().method_57379(CookiesDataComponentTypes.CUSTOM_SLOT_TEXT, (Object)String.valueOf(slot.field_7874 - 10));
        this.save(slot, slot.field_7874 - 10);
    }

    private void save(class_1735 slot, int id) {
        Optional<ProfileData> optionalProfile = ProfileStorage.getCurrentProfile();
        if (optionalProfile.isEmpty()) {
            return;
        }
        ProfileData profileData = optionalProfile.get();
        class_1799 stack = slot.method_7677();
        String timeRemaining = ForgeUtils.extractTimeRemaining(Optional.ofNullable((class_9290)stack.method_57824(class_9334.field_49632)).map(class_9290::comp_2400).orElseGet(Collections::emptyList));
        if (timeRemaining == null) {
            profileData.getForgeTracker().removeItem(id);
            return;
        }
        RepositoryItem repositoryItem = (RepositoryItem)stack.method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM);
        if (repositoryItem == null) {
            return;
        }
        long startTimeSeconds = ForgeUtils.getStartTimeSeconds(timeRemaining, repositoryItem);
        profileData.getForgeTracker().saveItem(repositoryItem, id, startTimeSeconds);
    }

    public static void init() {
        InventoryEvents.beforeInit("The Forge", o -> LocationUtils.isInSkyblock(), ForgeFeatures::new);
    }
}

