/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining;

import codes.cookies.mod.data.mining.PowderData;
import codes.cookies.mod.data.mining.PowderType;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.events.ChatMessageEvents;
import codes.cookies.mod.events.PlayerListWidgetEvent;
import codes.cookies.mod.events.ScoreboardUpdateEvent;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidgets;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.powder.PowderWidget;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowderTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowderTracker.class);
    private static long lastMithrilUpdate = -1L;
    private static long lastGemstoneUpdate = -1L;
    private static long lastGlaciteUpdate = -1L;

    public static void load() {
        ScoreboardUpdateEvent.EVENT.register(PowderTracker::updateScoreboard);
        ChatMessageEvents.BEFORE_MODIFY.register(PowderTracker::onChat);
        PlayerListWidgetEvent.register(PlayerListWidgets.POWDER, PowderTracker::parseWidget);
    }

    private static void parseWidget(PowderWidget powderWidget) {
        powderWidget.getMithrilPowder().ifPresent(powder -> PowderTracker.updatePowderFromList(PowderType.MITHRIL, powder));
        powderWidget.getGemstonePowder().ifPresent(powder -> PowderTracker.updatePowderFromList(PowderType.GEMSTONE, powder));
        powderWidget.getGlacitePowder().ifPresent(powder -> PowderTracker.updatePowderFromList(PowderType.GLACITE, powder));
    }

    private static void updateWidgetTime(PowderType powderType) {
        switch (powderType) {
            case MITHRIL: {
                lastMithrilUpdate = System.currentTimeMillis();
                break;
            }
            case GEMSTONE: {
                lastGemstoneUpdate = System.currentTimeMillis();
                break;
            }
            case GLACITE: {
                lastGlaciteUpdate = System.currentTimeMillis();
            }
        }
    }

    private static long getLastUpdateTime(PowderType powderType) {
        return switch (powderType) {
            default -> throw new MatchException(null, null);
            case PowderType.MITHRIL -> lastMithrilUpdate;
            case PowderType.GEMSTONE -> lastGemstoneUpdate;
            case PowderType.GLACITE -> lastGlaciteUpdate;
        };
    }

    private static void onChat(class_2561 text, boolean overlay) {
        if (overlay) {
            return;
        }
        String literalText = CookiesUtils.stripColor(text.getString());
        if (literalText == null || literalText.isEmpty()) {
            return;
        }
        if ("Reset your Heart of the Mountain! Your Perks and Abilities have been reset.".equalsIgnoreCase(literalText)) {
            ProfileStorage.getCurrentProfile().map(ProfileData::getPowderData).ifPresent(PowderData::reset);
        }
    }

    private static void updateScoreboard(int line, String text) {
        if (!text.startsWith("\u1805")) {
            return;
        }
        String nameAndPowder = text.substring(2);
        if (!nameAndPowder.contains(" ")) {
            return;
        }
        String name = nameAndPowder.substring(0, nameAndPowder.indexOf(32) - 1);
        String powder = nameAndPowder.substring(nameAndPowder.indexOf(32) + 1);
        Optional<PowderType> powderType = PowderType.getByDisplayName(name);
        powderType.ifPresent(type -> PowderTracker.updatePowderFromScoreboard(type, powder));
    }

    private static void updatePowderFromList(PowderType powderType, int powder) {
        PowderTracker.updateWidgetTime(powderType);
        PowderTracker.updatePowder(powderType, powder);
    }

    private static void updatePowderFromScoreboard(PowderType powderType, String powder) {
        if (PowderTracker.getLastUpdateTime(powderType) + 2000L > System.currentTimeMillis()) {
            return;
        }
        try {
            PowderTracker.updatePowder(powderType, Integer.parseInt(powder.replaceAll("\\W", "")));
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse powder of {} {}", (Object)powderType, (Object)powder);
        }
    }

    private static void updatePowder(PowderType powderType, int powder) {
        ProfileStorage.getCurrentProfile().ifPresent(profile -> profile.getPowderData().update(powderType, powder));
    }
}

