/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining;

import codes.cookies.mod.config.categories.mining.MiningCategory;
import codes.cookies.mod.events.profile.ServerSwapEvent;
import codes.cookies.mod.generated.Regions;
import codes.cookies.mod.render.Renderable;
import codes.cookies.mod.render.WorldRender;
import codes.cookies.mod.render.types.BlockHighlight;
import codes.cookies.mod.render.types.Composite;
import codes.cookies.mod.render.types.Line;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class PuzzlerSolver {
    private static final class_2960 DEBUG = DevUtils.createIdentifier("puzzler_debug");
    private static final class_2338 location = new class_2338(181, 195, 135);
    private BlockHighlight highlight = null;
    private Renderable line = null;

    public PuzzlerSolver() {
        ClientReceiveMessageEvents.GAME.register(this::messageReceive);
        ServerSwapEvent.SERVER_SWAP.register(() -> this.setHighlight(null));
    }

    private void messageReceive(class_2561 text, boolean overlay) {
        if (overlay) {
            return;
        }
        if (!LocationUtils.Island.DWARVEN_MINES.isActive()) {
            return;
        }
        if (LocationUtils.getRegion() != Regions.DWARVEN_MINES) {
            return;
        }
        if (!MiningCategory.puzzlerSolver) {
            return;
        }
        String literalContent = text.getString().replaceAll("(?i)\u00a7[A-Z0-9]", "");
        if (!literalContent.startsWith("[NPC] Puzzler: ")) {
            return;
        }
        String puzzlerString = literalContent.substring(15).trim();
        class_2338 block = location;
        boolean isTask = true;
        block6: for (char c : puzzlerString.toCharArray()) {
            switch (c) {
                case '\u25b2': {
                    block = this.move(block, 0, 1);
                    continue block6;
                }
                case '\u25c0': {
                    block = this.move(block, 1, 0);
                    continue block6;
                }
                case '\u25b6': {
                    block = this.move(block, -1, 0);
                    continue block6;
                }
                case '\u25bc': {
                    block = this.move(block, 0, -1);
                    continue block6;
                }
                default: {
                    isTask = false;
                }
            }
        }
        if (!isTask) {
            this.solved();
        } else {
            this.setHighlight(block);
        }
    }

    private void setHighlight(class_2338 highlight) {
        WorldRender.removeRenderable(this.highlight);
        WorldRender.removeRenderable(this.line);
        if (highlight == null) {
            this.highlight = null;
            this.line = null;
            return;
        }
        if (this.line != null) {
            WorldRender.addRenderable(this.line);
        }
        this.highlight = new BlockHighlight(highlight, -8921737);
        WorldRender.addRenderable(this.highlight);
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2680 blockState = world.method_8320(highlight);
        if (blockState.method_26204() == class_2246.field_10161 || blockState.method_26204() == class_2246.field_9975 || blockState.method_26204() == class_2246.field_10148) {
            world.method_8501(highlight, class_2246.field_22127.method_9564());
        }
    }

    private class_2338 move(class_2338 pos, int x, int y) {
        class_2338 add = pos.method_10069(x, 0, y);
        if (DevUtils.isEnabled(DEBUG)) {
            Line newLine = new Line(this.centerPos(pos), this.centerPos(add), -1466946);
            this.line = this.line == null ? newLine : new Composite(this.line, newLine);
        }
        return add;
    }

    private void solved() {
        this.setHighlight(null);
    }

    private class_243 centerPos(class_2338 pos) {
        return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.1, (double)pos.method_10260() + 0.5);
    }
}

