/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining.hollows;

import codes.cookies.mod.data.mining.crystal.CrystalStatus;
import codes.cookies.mod.data.mining.crystal.CrystalType;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.generated.Regions;
import codes.cookies.mod.render.hud.HudManager;
import codes.cookies.mod.render.hud.elements.MultiLineTextHudElement;
import codes.cookies.mod.render.hud.internal.HudEditAction;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.services.mining.CrystalStatusService;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class CrystalRunHud
extends MultiLineTextHudElement {
    private long lastUpdate;
    private final List<class_2561> defaultTexts = new ArrayList<class_2561>();
    private final Map<Regions, List<class_2561>> regionTexts = new HashMap<Regions, List<class_2561>>();

    public CrystalRunHud() {
        super(class_2960.method_60655((String)"cookies", (String)"mining/crystal_hud"));
        HudManager.register(this);
    }

    @Override
    protected List<class_2561> getText() {
        if (ProfileStorage.getCurrentProfile().isEmpty()) {
            return List.of();
        }
        this.updateItemIndex();
        return this.regionTexts.getOrDefault((Object)LocationUtils.getRegion(), this.defaultTexts);
    }

    private void updateItemIndex() {
        if (this.lastUpdate + 1000L > System.currentTimeMillis()) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        Collection<Item<?>> relevantItemsOnPlayer = this.getRelevantItemsOnPlayer();
        this.createLostPrecursorCityTexts(relevantItemsOnPlayer);
        this.createMinesOfDivanText(relevantItemsOnPlayer);
        this.createDefaultTexts();
    }

    private void createMinesOfDivanText(Collection<Item<?>> relevantItems) {
        ArrayList<class_2561> minesOfDivanText = new ArrayList<class_2561>();
        this.addItem("DWARVEN_LAPIS_SWORD", relevantItems, minesOfDivanText);
        this.addItem("DWARVEN_GOLD_HAMMER", relevantItems, minesOfDivanText);
        this.addItem("DWARVEN_DIAMOND_AXE", relevantItems, minesOfDivanText);
        this.addItem("DWARVEN_EMERALD_HAMMER", relevantItems, minesOfDivanText);
        this.regionTexts.put(Regions.MINES_OF_DIVAN, minesOfDivanText);
    }

    private void createLostPrecursorCityTexts(Collection<Item<?>> relevantItems) {
        ArrayList<class_2561> lostPrecursorCityText = new ArrayList<class_2561>();
        this.addItem("CONTROL_SWITCH", relevantItems, lostPrecursorCityText);
        this.addItem("ELECTRON_TRANSMITTER", relevantItems, lostPrecursorCityText);
        this.addItem("FTX_3070", relevantItems, lostPrecursorCityText);
        this.addItem("ROBOTRON_REFLECTOR", relevantItems, lostPrecursorCityText);
        this.addItem("SUPERLITE_MOTOR", relevantItems, lostPrecursorCityText);
        this.addItem("SYNTHETIC_HEART", relevantItems, lostPrecursorCityText);
        this.addItem("PRECURSOR_APPARATUS", relevantItems, lostPrecursorCityText);
        this.regionTexts.put(Regions.LOST_PRECURSOR_CITY, lostPrecursorCityText);
    }

    private void addItem(String id, Collection<Item<?>> relevantItems, List<class_2561> texts) {
        int itemAmountAvailable = this.getAmountOfItemAvailable(relevantItems, id);
        RepositoryItem repositoryItem = RepositoryItem.ofOrEmpty(id);
        class_2561 itemName = repositoryItem.getFormattedName();
        class_5250 append = class_2561.method_43473().method_10852(itemName).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(itemAmountAvailable)).method_27692(class_124.field_1054));
        texts.add((class_2561)append);
    }

    private void createDefaultTexts() {
        ArrayList<class_2561> defaultText = new ArrayList<class_2561>();
        this.addCrystalStatusFor(CrystalType.JADE, defaultText);
        this.addCrystalStatusFor(CrystalType.AMBER, defaultText);
        this.addCrystalStatusFor(CrystalType.AMETHYST, defaultText);
        this.addCrystalStatusFor(CrystalType.SAPPHIRE, defaultText);
        this.addCrystalStatusFor(CrystalType.TOPAZ, defaultText);
        this.defaultTexts.clear();
        this.defaultTexts.addAll(defaultText);
    }

    private int getAmountOfItemAvailable(Collection<Item<?>> items, String itemId) {
        return items.stream().filter(item -> itemId.equalsIgnoreCase(ItemUtils.getId(item))).mapToInt(Item::amount).sum();
    }

    private Collection<Item<?>> getRelevantItemsOnPlayer() {
        return ItemSources.getItems(ItemSources.INVENTORY, ItemSources.STORAGE, ItemSources.SACKS);
    }

    private void addCrystalStatusFor(CrystalType type, List<class_2561> texts) {
        String name = StringUtils.capitalize((String)type.name().toLowerCase(Locale.ROOT));
        texts.add((class_2561)class_2561.method_43470((String)name).method_27692(type.getFormatting()).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852(this.getStatusForOrNotFound(type).getText()));
    }

    private CrystalStatus getStatusForOrNotFound(CrystalType type) {
        return CrystalStatusService.getCrystalStatus(type).orElse(CrystalStatus.NOT_FOUND);
    }

    @Override
    public int getMaxRows() {
        return 7;
    }

    @Override
    public boolean shouldRender() {
        if (this.hudEditAction == HudEditAction.SHOW_ALL) {
            return true;
        }
        if (this.hudEditAction == HudEditAction.ALL_ENABLED) {
            return true;
        }
        return LocationUtils.Island.CRYSTAL_HOLLOWS.isActive();
    }

    @Override
    public int getWidth() {
        if (this.hudEditAction != HudEditAction.NONE) {
            return 170;
        }
        return this.lastWidth;
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43470((String)"Crystals").method_27692(class_124.field_1061);
    }
}

