/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining.hollows;

import codes.cookies.mod.config.categories.mining.MiningCategory;
import codes.cookies.mod.events.profile.ServerSwapEvent;
import codes.cookies.mod.generated.Regions;
import codes.cookies.mod.render.Renderable;
import codes.cookies.mod.render.WorldRender;
import codes.cookies.mod.render.types.BeaconBeam;
import codes.cookies.mod.render.types.Box;
import codes.cookies.mod.render.types.Composite;
import codes.cookies.mod.render.types.Line;
import codes.cookies.mod.render.types.WorldText;
import codes.cookies.mod.repository.constants.RepositoryConstants;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;

public class MinesOfDivanHelper {
    static class_2960 DEBUG = DevUtils.createIdentifier("ch/mod_debug");
    @Language(value="RegExp")
    static String REGEX = "\\[NPC] Keeper of (\\w+): .*?!";
    static class_2338 centerPos;
    static class_2338 lastEntityClicked;
    static Renderable latest;
    static class_243 lastPlayerPos;
    static double lastDistance;
    static int matches;
    static class_2338 lastSolution;
    static long lastMessageSentAt;

    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(MinesOfDivanHelper::allowGame);
        UseBlockCallback.EVENT.register(MinesOfDivanHelper::blockInteract);
        AttackEntityCallback.EVENT.register(MinesOfDivanHelper::attackEntity);
        UseEntityCallback.EVENT.register(MinesOfDivanHelper::useEntity);
        ServerSwapEvent.SERVER_SWAP.register(MinesOfDivanHelper::reset);
    }

    private static void reset() {
        MinesOfDivanHelper.reset(false, false);
    }

    public static void clickEntity(class_1297 entity) {
        if (MinesOfDivanHelper.isNotInMinesOfDivan()) {
            return;
        }
        lastEntityClicked = entity.method_24515();
    }

    public static boolean isEnabled() {
        return (Boolean)MiningCategory.modHelper.get();
    }

    public static boolean isNotInMinesOfDivan() {
        return !LocationUtils.Island.CRYSTAL_HOLLOWS.isActive() || LocationUtils.getRegion() != Regions.MINES_OF_DIVAN;
    }

    public static void reset(boolean ignored1, boolean ignored2) {
        MinesOfDivanHelper.removeRenderables();
        centerPos = null;
        lastEntityClicked = null;
        matches = 0;
        lastPlayerPos = null;
        lastDistance = 0.0;
    }

    public static void removeRenderables() {
        if (latest != null) {
            WorldRender.removeRenderable(latest);
            latest = null;
        }
    }

    private static class_1269 useEntity(class_1657 playerEntity, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        if (MinesOfDivanHelper.isEnabled()) {
            MinesOfDivanHelper.clickEntity(entity);
        }
        return class_1269.field_5811;
    }

    private static class_1269 attackEntity(class_1657 playerEntity, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        if (MinesOfDivanHelper.isEnabled()) {
            MinesOfDivanHelper.clickEntity(entity);
        }
        return class_1269.field_5811;
    }

    private static boolean allowGame(class_2561 text, boolean overlay) {
        if (MinesOfDivanHelper.isEnabled()) {
            if (overlay) {
                MinesOfDivanHelper.onActionBarUpdate(text);
            } else {
                MinesOfDivanHelper.onInGameMessage(text);
            }
        }
        return true;
    }

    private static class_1269 blockInteract(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (MinesOfDivanHelper.isEnabled()) {
            MinesOfDivanHelper.onBlockInteract(world, blockHitResult);
        }
        return class_1269.field_5811;
    }

    private static void onActionBarUpdate(class_2561 text) {
        double chestDistance;
        if (MinesOfDivanHelper.isNotInMinesOfDivan()) {
            MinesOfDivanHelper.removeRenderables();
            lastEntityClicked = null;
            return;
        }
        if (centerPos == null) {
            if (lastMessageSentAt + 60000L < System.currentTimeMillis()) {
                lastMessageSentAt = System.currentTimeMillis();
                CookiesUtils.sendFailedMessage("Click a keeper to enable the solver!");
            }
            MinesOfDivanHelper.removeRenderables();
            return;
        }
        String literal = CookiesUtils.stripColor(text.getString());
        String distanceLiteral = literal.replaceAll(".* TREASURE: ([\\d.]+)m.*", "$1");
        try {
            chestDistance = Double.parseDouble(distanceLiteral);
        }
        catch (NumberFormatException ignored) {
            return;
        }
        class_243 playerPos = CookiesUtils.getPlayer().map(class_1297::method_19538).orElse(null);
        if (playerPos == null) {
            return;
        }
        class_243 centerPos3d = centerPos.method_46558().method_1023(0.5, 0.5, 0.5);
        class_243 relative = playerPos.method_1020(centerPos3d);
        if (lastPlayerPos == playerPos && lastDistance == chestDistance) {
            if (matches < 2) {
                ++matches;
                return;
            }
        } else {
            lastPlayerPos = playerPos;
            lastDistance = chestDistance;
            matches = 0;
            return;
        }
        boolean debug = DevUtils.isEnabled(DEBUG);
        Record renderable = debug ? new BeaconBeam(relative, 0, -1466946) : null;
        class_2338 closest = null;
        double distanceDelta = Double.MAX_VALUE;
        for (class_2338 relativePos : RepositoryConstants.modLocations) {
            class_243 pos = relativePos.method_46558().method_1023(0.5, 0.0, 0.5);
            double distance = Math.abs(relative.method_1022(pos) - chestDistance);
            if (debug) {
                renderable = new Composite(new Renderable[]{renderable, new Line(relative.method_1019(centerPos3d), pos.method_1019(centerPos3d).method_1031(0.5, 0.5, 0.5), -1466946, -8921737), new WorldText(pos.method_1019(centerPos3d).method_1031(0.5, 2.0, 0.5), (class_2561)class_2561.method_43470((String)("D: " + distance)))});
            }
            if (closest == null) {
                closest = relativePos;
                distanceDelta = distance;
            }
            if (!(distanceDelta > distance)) continue;
            closest = relativePos;
            distanceDelta = distance;
        }
        if (closest == null || lastSolution == closest) {
            return;
        }
        CookiesUtils.sendSuccessMessage("Found new solution!");
        lastSolution = closest;
        WorldRender.removeRenderable(latest);
        renderable = new Composite(new Renderable[]{renderable, MinesOfDivanHelper.create(closest.method_10081((class_2382)centerPos))});
        latest = renderable;
        WorldRender.addRenderable(renderable);
        matches = 0;
    }

    private static void onInGameMessage(class_2561 text) {
        class_2350 direction;
        if (MinesOfDivanHelper.isNotInMinesOfDivan()) {
            return;
        }
        String literal = CookiesUtils.stripColor(text.getString());
        if (!literal.matches(REGEX)) {
            return;
        }
        String clicked = literal.replaceAll(REGEX, "$1");
        if (DevUtils.isEnabled(DEBUG)) {
            CookiesUtils.sendMessage(clicked);
        }
        switch (clicked) {
            case "Diamond": {
                direction = class_2350.field_11034;
                break;
            }
            case "Gold": {
                direction = class_2350.field_11043;
                break;
            }
            case "Lapis": {
                direction = class_2350.field_11039;
                break;
            }
            case "Emerald": {
                direction = class_2350.field_11035;
                break;
            }
            default: {
                return;
            }
        }
        if (lastEntityClicked == null) {
            return;
        }
        class_2338 offset = lastEntityClicked.method_10079(direction.method_10170(), 3).method_10079(direction, 33);
        if (DevUtils.isEnabled(DEBUG)) {
            CookiesUtils.sendMessage(offset.toString());
        }
        if (centerPos == offset) {
            return;
        }
        CookiesUtils.sendSuccessMessage("Enabled solver!");
        centerPos = offset;
    }

    private static void onBlockInteract(class_1937 world, class_3965 blockHitResult) {
        if (MinesOfDivanHelper.isNotInMinesOfDivan()) {
            return;
        }
        if (centerPos == null || blockHitResult == null) {
            return;
        }
        class_2338 blockPos = blockHitResult.method_17777();
        if (world == null || world.method_8320(blockPos).method_26204() != class_2246.field_10034) {
            return;
        }
        class_2338 localPos = blockPos.method_10059((class_2382)centerPos);
        if (RepositoryConstants.modLocations.contains(localPos)) {
            return;
        }
        RepositoryConstants.modLocations.add(localPos);
    }

    private static Renderable create(class_2338 blockPos) {
        class_238 expand = new class_238(blockPos).method_1009(5.0, 50.0, 5.0);
        return new Composite(new Box(blockPos, -8921737, false), new BeaconBeam(blockPos.method_46558(), 200, -8921737), new Box(expand.method_61125(), expand.method_61126(), -1887969929));
    }

    static {
        matches = 0;
    }
}

