/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining.shafts;

import codes.cookies.mod.config.categories.mining.ShaftCategory;
import codes.cookies.mod.events.PlayerListWidgetEvent;
import codes.cookies.mod.events.mining.MineshaftEvents;
import codes.cookies.mod.repository.constants.mining.ShaftCorpseLocations;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.skyblock.PartyUtils;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidgets;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.corpse.CorpseEntry;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.corpse.CorpseType;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.corpse.FrozenCorpseWidget;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MineshaftAnnouncements {
    private static boolean hasSendMessage = false;
    private static ShaftCorpseLocations.ShaftLocations shaftType;
    private static long lastShaftFoundAt;

    public static void register() {
        MineshaftEvents.JOIN_SHAFT.register(MineshaftAnnouncements::join);
        MineshaftEvents.LEAVE.register(MineshaftAnnouncements::leave);
        MineshaftEvents.FIND.register(MineshaftAnnouncements::find);
        PlayerListWidgetEvent.register(PlayerListWidgets.CORPSE, MineshaftAnnouncements::corpseWidgetUpdate);
    }

    private static void find() {
        lastShaftFoundAt = System.currentTimeMillis();
        PartyUtils.request();
    }

    private static void join(ShaftCorpseLocations.ShaftLocations shaftLocations) {
        if (lastShaftFoundAt + 60000L < System.currentTimeMillis()) {
            return;
        }
        shaftType = shaftLocations;
        hasSendMessage = false;
    }

    private static void corpseWidgetUpdate(FrozenCorpseWidget widget) {
        if (hasSendMessage || shaftType == null) {
            return;
        }
        Map<CorpseType, List<CorpseEntry>> collect = widget.getCorpses().stream().sorted(Comparator.comparingInt(entry -> entry.corpseType().ordinal())).collect(Collectors.groupingBy(CorpseEntry::corpseType));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Mineshaft entered | ");
        stringBuilder.append(shaftType.id()).append(" | ");
        List<CorpseEntry> unknown = collect.remove((Object)CorpseType.UNKNOWN);
        if (collect.containsKey((Object)CorpseType.VANGUARD)) {
            stringBuilder.append("vang ");
        } else {
            collect.forEach((type, list) -> stringBuilder.append(list.size()).append(type.name().charAt(0)).append(" "));
        }
        if (unknown != null) {
            stringBuilder.append("| ").append(unknown.size()).append(" Unknown");
        }
        switch (ShaftCategory.type) {
            case CHAT: {
                CookiesUtils.sendWhiteMessage(stringBuilder.toString());
                break;
            }
            case PARTY: {
                if (PartyUtils.isInParty()) {
                    CookiesUtils.sendInformation("Sending message into party chat!");
                    CookiesUtils.sendCommand("pc " + String.valueOf(stringBuilder));
                    break;
                }
                CookiesUtils.sendFailedMessage("Not in a party!");
                CookiesUtils.sendWhiteMessage(stringBuilder.toString());
            }
        }
        hasSendMessage = true;
    }

    private static void leave() {
        hasSendMessage = true;
        shaftType = null;
    }

    static {
        lastShaftFoundAt = -1L;
    }
}

