/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining.shafts;

import codes.cookies.mod.config.categories.mining.ShaftCategory;
import codes.cookies.mod.events.IslandChangeEvent;
import codes.cookies.mod.events.ScoreboardUpdateEvent;
import codes.cookies.mod.events.mining.MineshaftEvents;
import codes.cookies.mod.repository.constants.mining.ShaftCorpseLocations;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;

public class ShaftFeatures {
    private static boolean isInShaft = false;
    public static long lastShaftFoundAt = -1L;
    private static ShaftCorpseLocations.ShaftLocations locations;

    public static Optional<ShaftCorpseLocations.ShaftLocations> getCurrentMineshaftLocations() {
        return Optional.ofNullable(locations);
    }

    public static void load() {
        IslandChangeEvent.EVENT.register(ShaftFeatures::swapIsland);
        ScoreboardUpdateEvent.EVENT.register(ShaftFeatures::updateLine);
    }

    private static void swapIsland(LocationUtils.Island previous, LocationUtils.Island current) {
        if (isInShaft) {
            ((Runnable)MineshaftEvents.LEAVE.invoker()).run();
        }
        isInShaft = false;
        locations = null;
        if (current == LocationUtils.Island.MINESHAFT) {
            isInShaft = true;
            ((Runnable)MineshaftEvents.JOIN.invoker()).run();
        }
    }

    private static void updateLine(int index, String line) {
        if (!ShaftCategory.enabled) {
            return;
        }
        if (!isInShaft) {
            return;
        }
        if (locations != null) {
            return;
        }
        String server = LocationUtils.getServerDisplayName().orElse("");
        if (!line.contains(server)) {
            return;
        }
        String[] split = line.split(server);
        if (split.length != 2) {
            return;
        }
        String shaftType = split[1].trim();
        locations = ShaftCorpseLocations.getCachedOrCreate(shaftType);
        if (!locations.cached()) {
            CookiesUtils.sendFailedMessage("No cached data found, creating new one!");
        }
        ((Consumer)MineshaftEvents.JOIN_SHAFT.invoker()).accept(locations);
    }

    @Generated
    public static long getLastShaftFoundAt() {
        return lastShaftFoundAt;
    }
}

